/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.guava;

import java.io.IOException;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.common.guava.Accumulator;
import org.apache.hive.druid.com.metamx.common.guava.CloseQuietly;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Yielder;
import org.apache.hive.druid.com.metamx.common.guava.Yielders;
import org.apache.hive.druid.com.metamx.common.guava.YieldingAccumulator;

public class ConcatSequence<T>
implements Sequence<T> {
    private final Sequence<Sequence<T>> baseSequences;

    public ConcatSequence(Sequence<Sequence<T>> baseSequences) {
        this.baseSequences = baseSequences;
    }

    @Override
    public <OutType> OutType accumulate(OutType initValue, final Accumulator<OutType, T> accumulator) {
        return this.baseSequences.accumulate(initValue, new Accumulator<OutType, Sequence<T>>(){

            @Override
            public OutType accumulate(OutType accumulated, Sequence<T> in) {
                return in.accumulate(accumulated, accumulator);
            }
        });
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        Yielder<Object> yielderYielder = this.baseSequences.toYielder(null, new YieldingAccumulator<Sequence<T>, Sequence<T>>(){

            @Override
            public Sequence<T> accumulate(Sequence<T> accumulated, Sequence<T> in) {
                this.yield();
                return in;
            }
        });
        try {
            return this.makeYielder(yielderYielder, initValue, accumulator);
        }
        catch (RuntimeException e) {
            CloseQuietly.close(yielderYielder);
            throw e;
        }
    }

    public <OutType> Yielder<OutType> makeYielder(Yielder<Sequence<T>> yielderYielder, OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        if (yielderYielder.isDone()) {
            return Yielders.done(initValue, yielderYielder);
        }
        while (!yielderYielder.isDone()) {
            Yielder<OutType> yielder = yielderYielder.get().toYielder(initValue, accumulator);
            if (accumulator.yielded()) {
                return this.wrapYielder(yielder, yielderYielder, accumulator);
            }
            initValue = yielder.get();
            try {
                yielder.close();
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
            yielderYielder = yielderYielder.next(null);
        }
        return Yielders.done(initValue, yielderYielder);
    }

    private <OutType> Yielder<OutType> wrapYielder(final Yielder<OutType> yielder, final Yielder<Sequence<T>> yielderYielder, final YieldingAccumulator<OutType, T> accumulator) {
        if (!accumulator.yielded()) {
            OutType nextInit = yielder.get();
            try {
                yielder.close();
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
            return this.makeYielder(yielderYielder.next(null), nextInit, accumulator);
        }
        return new Yielder<OutType>(){

            @Override
            public OutType get() {
                return yielder.get();
            }

            @Override
            public Yielder<OutType> next(OutType initValue) {
                return ConcatSequence.this.wrapYielder(yielder.next(initValue), yielderYielder, accumulator);
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public void close() throws IOException {
                yielder.close();
                yielderYielder.close();
            }
        };
    }
}

