/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.fasterxml.jackson.datatype.guava;

import org.apache.hive.druid.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JavaType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.SerializationConfig;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ser.Serializers;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.type.MapLikeType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.type.TypeFactory;
import org.apache.hive.druid.com.fasterxml.jackson.databind.util.StdConverter;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.ser.GuavaOptionalSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.ser.MultimapSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.ser.RangeSerializer;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.cache.CacheBuilder;
import org.apache.hive.druid.com.google.common.cache.CacheBuilderSpec;
import org.apache.hive.druid.com.google.common.collect.FluentIterable;
import org.apache.hive.druid.com.google.common.collect.Multimap;
import org.apache.hive.druid.com.google.common.collect.Range;
import org.apache.hive.druid.com.google.common.net.HostAndPort;
import org.apache.hive.druid.com.google.common.net.InternetDomainName;

public class GuavaSerializers
extends Serializers.Base {
    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class<?> raw = type.getRawClass();
        if (Optional.class.isAssignableFrom(raw)) {
            return new GuavaOptionalSerializer(type);
        }
        if (Range.class.isAssignableFrom(raw)) {
            return new RangeSerializer(type);
        }
        if (HostAndPort.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (InternetDomainName.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (CacheBuilderSpec.class.isAssignableFrom(raw) || CacheBuilder.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (FluentIterable.class.isAssignableFrom(raw)) {
            JavaType[] params = config.getTypeFactory().findTypeParameters(type, Iterable.class);
            JavaType vt = params == null || params.length != 1 ? TypeFactory.unknownType() : params[0];
            JavaType delegate = config.getTypeFactory().constructParametricType(Iterable.class, vt);
            return new StdDelegatingSerializer(FluentConverter.instance, delegate, null);
        }
        return super.findSerializer(config, type, beanDesc);
    }

    @Override
    public JsonSerializer<?> findMapLikeSerializer(SerializationConfig config, MapLikeType type, BeanDescription beanDesc, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        if (Multimap.class.isAssignableFrom(type.getRawClass())) {
            return new MultimapSerializer(config, type, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer);
        }
        return null;
    }

    static class FluentConverter
    extends StdConverter<Object, Iterable<?>> {
        static final FluentConverter instance = new FluentConverter();

        FluentConverter() {
        }

        @Override
        public Iterable<?> convert(Object value) {
            return (Iterable)value;
        }
    }
}

