/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.serde.DruidQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JavaType;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.topn.DimensionAndMetricValueExtractor;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNResultValue;

public class DruidTopNQueryRecordReader
extends DruidQueryRecordReader<TopNQuery, Result<TopNResultValue>> {
    private static final TypeReference<Result<TopNResultValue>> TYPE_REFERENCE = new TypeReference<Result<TopNResultValue>>(){};
    private Result<TopNResultValue> current;
    private Iterator<DimensionAndMetricValueExtractor> values = Iterators.emptyIterator();

    @Override
    protected JavaType getResultTypeDef() {
        return DruidStorageHandlerUtils.JSON_MAPPER.getTypeFactory().constructType(TYPE_REFERENCE);
    }

    @Override
    public boolean nextKeyValue() {
        if (this.values.hasNext()) {
            return true;
        }
        if (this.queryResultsIterator.hasNext()) {
            this.current = (Result)this.queryResultsIterator.next();
            this.values = this.current.getValue().getValue().iterator();
            return this.nextKeyValue();
        }
        return false;
    }

    @Override
    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    @Override
    public DruidWritable getCurrentValue() throws IOException, InterruptedException {
        DruidWritable value = new DruidWritable();
        value.getValue().put("__time", this.current.getTimestamp().getMillis());
        if (this.values.hasNext()) {
            value.getValue().putAll(this.values.next().getBaseObject());
            return value;
        }
        return value;
    }

    @Override
    public boolean next(NullWritable key, DruidWritable value) {
        if (this.nextKeyValue()) {
            value.getValue().clear();
            value.getValue().put("__time", this.current.getTimestamp().getMillis());
            if (this.values.hasNext()) {
                value.getValue().putAll(this.values.next().getBaseObject());
            }
            return true;
        }
        return false;
    }

    @Override
    public float getProgress() {
        return this.queryResultsIterator.hasNext() || this.values.hasNext() ? 0.0f : 1.0f;
    }
}

