/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.serde.DruidQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JavaType;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.select.EventHolder;
import org.apache.hive.druid.io.druid.query.select.SelectQuery;
import org.apache.hive.druid.io.druid.query.select.SelectResultValue;

public class DruidSelectQueryRecordReader
extends DruidQueryRecordReader<SelectQuery, Result<SelectResultValue>> {
    private static final TypeReference<Result<SelectResultValue>> TYPE_REFERENCE = new TypeReference<Result<SelectResultValue>>(){};
    private Result<SelectResultValue> current;
    private Iterator<EventHolder> values = Iterators.emptyIterator();

    @Override
    protected JavaType getResultTypeDef() {
        return DruidStorageHandlerUtils.JSON_MAPPER.getTypeFactory().constructType(TYPE_REFERENCE);
    }

    @Override
    public boolean nextKeyValue() throws IOException {
        if (this.values.hasNext()) {
            return true;
        }
        if (this.queryResultsIterator.hasNext()) {
            this.current = (Result)this.queryResultsIterator.next();
            this.values = this.current.getValue().getEvents().iterator();
            return this.nextKeyValue();
        }
        return false;
    }

    @Override
    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    @Override
    public DruidWritable getCurrentValue() throws IOException, InterruptedException {
        DruidWritable value = new DruidWritable();
        EventHolder e = this.values.next();
        value.getValue().put("__time", e.getTimestamp().getMillis());
        value.getValue().putAll(e.getEvent());
        return value;
    }

    @Override
    public boolean next(NullWritable key, DruidWritable value) throws IOException {
        if (this.nextKeyValue()) {
            value.getValue().clear();
            EventHolder e = this.values.next();
            value.getValue().put("__time", e.getTimestamp().getMillis());
            value.getValue().putAll(e.getEvent());
            return true;
        }
        return false;
    }

    @Override
    public float getProgress() {
        return this.queryResultsIterator.hasNext() || this.values.hasNext() ? 0.0f : 1.0f;
    }
}

