/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hbase.thirdparty.io.netty.util.internal.shaded.org.jctools.queues.atomic;

import org.apache.hbase.thirdparty.io.netty.util.internal.shaded.org.jctools.util.Pow2;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.hbase.thirdparty.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import org.apache.hbase.thirdparty.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue.Supplier;
import org.apache.hbase.thirdparty.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import org.apache.hbase.thirdparty.io.netty.util.internal.shaded.org.jctools.queues.IndexedQueueSizeUtil;
import static org.apache.hbase.thirdparty.io.netty.util.internal.shaded.org.jctools.queues.atomic.LinkedAtomicArrayQueueUtil.*;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.hbase.thirdparty.io.netty.util.internal.shaded.org.jctools.queues.MpmcArrayQueue;

/**
 * NOTE: This class was automatically generated by org.apache.hbase.thirdparty.io.netty.util.internal.shaded.org.jctools.queues.atomic.JavaParsingAtomicLinkedQueueGenerator
 * which can found in the jctools-build module. The original source file is SpscUnboundedArrayQueue.java.
 */
public class SpscUnboundedAtomicArrayQueue<E> extends BaseSpscLinkedAtomicArrayQueue<E> {

    public SpscUnboundedAtomicArrayQueue(int chunkSize) {
        int chunkCapacity = Math.max(Pow2.roundToPowerOfTwo(chunkSize), 16);
        long mask = chunkCapacity - 1;
        AtomicReferenceArray<E> buffer = allocate(chunkCapacity + 1);
        producerBuffer = buffer;
        producerMask = mask;
        consumerBuffer = buffer;
        consumerMask = mask;
        // we know it's all empty to start with
        producerBufferLimit = mask - 1;
    }

    @Override
    final boolean offerColdPath(AtomicReferenceArray<E> buffer, long mask, long pIndex, int offset, E v, Supplier<? extends E> s) {
        // use a fixed lookahead step based on buffer capacity
        final long lookAheadStep = (mask + 1) / 4;
        long pBufferLimit = pIndex + lookAheadStep;
        // go around the buffer or add a new buffer
        if (null == lvElement(buffer, calcElementOffset(pBufferLimit, mask))) {
            // joy, there's plenty of room
            producerBufferLimit = pBufferLimit - 1;
            writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else if (null == lvElement(buffer, calcElementOffset(pIndex + 1, mask))) {
            // buffer is not full
            writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else {
            // we got one slot left to write into, and we are not full. Need to link new buffer.
            // allocate new buffer of same length
            final AtomicReferenceArray<E> newBuffer = allocate((int) (mask + 2));
            producerBuffer = newBuffer;
            producerBufferLimit = pIndex + mask - 1;
            linkOldToNew(pIndex, buffer, offset, newBuffer, offset, v == null ? s.get() : v);
        }
        return true;
    }

    @Override
    public int capacity() {
        return UNBOUNDED_CAPACITY;
    }
}
