/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * This package contains implementations of collection and map related key/value classes.
 * These are usually used in maps, however they can be used as data holders in any collection.
 * <p>
 * The following key/value designs are included:
 * <ul>
 *   <li>Map Entry - various map entry implementations
 *   <li>KeyValue - a key and value pair, without map entry semantics
 *   <li>MultiKey - a holder of multiple keys tied together
 * </ul>
 *
 */
package org.apache.hbase.thirdparty.org.apache.commons.collections4.keyvalue;
