/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.CopyListingFileStatus;

final class DeletedDirTracker {
    private final Cache<Path, Path> directories;
    private final int cacheSize;

    DeletedDirTracker(int cacheSize) {
        this.cacheSize = cacheSize;
        this.directories = CacheBuilder.newBuilder().maximumSize((long)this.cacheSize).build();
    }

    boolean isDirectoryOrAncestorDeleted(Path dir) {
        if (dir == null) {
            return false;
        }
        if (this.isContained(dir)) {
            return true;
        }
        return this.isDirectoryOrAncestorDeleted(dir.getParent());
    }

    private boolean isInDeletedDirectory(Path path) {
        Preconditions.checkArgument((!path.isRoot() ? 1 : 0) != 0, (Object)"Root Dir");
        return this.isDirectoryOrAncestorDeleted(path.getParent());
    }

    boolean shouldDelete(CopyListingFileStatus status) {
        Path path = status.getPath();
        Preconditions.checkArgument((!path.isRoot() ? 1 : 0) != 0, (Object)"Root Dir");
        if (status.isDirectory()) {
            boolean deleted = this.isDirectoryOrAncestorDeleted(path);
            this.directories.put((Object)path, (Object)path);
            return !deleted;
        }
        return !this.isInDeletedDirectory(path);
    }

    boolean isContained(Path dir) {
        return this.directories.getIfPresent((Object)dir) != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DeletedDirTracker{");
        sb.append("maximum size=").append(this.cacheSize);
        sb.append("; current size=").append(this.directories.size());
        sb.append('}');
        return sb.toString();
    }

    long size() {
        return this.directories.size();
    }
}

