/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.util;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclUtil;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.tools.CopyListing;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.mapred.UniformSizeInputFormat;

public class DistCpUtils {
    private static final Log LOG = LogFactory.getLog(DistCpUtils.class);
    private static final ThreadLocal<DecimalFormat> FORMATTER = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("0.0");
        }
    };

    public static long getFileSize(Path path, Configuration configuration) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Retrieving file size for: " + path));
        }
        return path.getFileSystem(configuration).getFileStatus(path).getLen();
    }

    public static <T> void publish(Configuration configuration, String label, T value) {
        configuration.set(label, String.valueOf(value));
    }

    public static int getInt(Configuration configuration, String label) {
        int value = configuration.getInt(label, -1);
        assert (value >= 0) : "Couldn't find " + label;
        return value;
    }

    public static long getLong(Configuration configuration, String label) {
        long value = configuration.getLong(label, -1L);
        assert (value >= 0L) : "Couldn't find " + label;
        return value;
    }

    public static Class<? extends InputFormat> getStrategy(Configuration conf, DistCpOptions options) {
        String confLabel = "distcp." + options.getCopyStrategy().toLowerCase(Locale.getDefault()) + ".strategy.impl";
        return conf.getClass(confLabel, UniformSizeInputFormat.class, InputFormat.class);
    }

    public static String getRelativePath(Path sourceRootPath, Path childPath) {
        String childPathString = childPath.toUri().getPath();
        String sourceRootPathString = sourceRootPath.toUri().getPath();
        return sourceRootPathString.equals("/") ? childPathString : childPathString.substring(sourceRootPathString.length());
    }

    public static String packAttributes(EnumSet<DistCpOptions.FileAttribute> attributes) {
        StringBuffer buffer = new StringBuffer(DistCpOptions.FileAttribute.values().length);
        int len = 0;
        for (DistCpOptions.FileAttribute attribute : attributes) {
            buffer.append(attribute.name().charAt(0));
            ++len;
        }
        return buffer.substring(0, len);
    }

    public static EnumSet<DistCpOptions.FileAttribute> unpackAttributes(String attributes) {
        EnumSet<DistCpOptions.FileAttribute> retValue = EnumSet.noneOf(DistCpOptions.FileAttribute.class);
        if (attributes != null) {
            for (int index = 0; index < attributes.length(); ++index) {
                retValue.add(DistCpOptions.FileAttribute.getAttribute(attributes.charAt(index)));
            }
        }
        return retValue;
    }

    public static void preserve(FileSystem targetFS, Path path, CopyListingFileStatus srcFileStatus, EnumSet<DistCpOptions.FileAttribute> attributes, boolean preserveRawXattrs) throws IOException {
        FileStatus targetFileStatus = attributes.isEmpty() ? null : targetFS.getFileStatus(path);
        String group = targetFileStatus == null ? null : targetFileStatus.getGroup();
        String user = targetFileStatus == null ? null : targetFileStatus.getOwner();
        boolean chown = false;
        if (attributes.contains((Object)DistCpOptions.FileAttribute.ACL)) {
            List<AclEntry> targetAcl;
            List<AclEntry> srcAcl = srcFileStatus.getAclEntries();
            if (!srcAcl.equals(targetAcl = DistCpUtils.getAcl(targetFS, targetFileStatus))) {
                targetFS.setAcl(path, srcAcl);
            }
            if (srcFileStatus.getPermission().getStickyBit() != targetFileStatus.getPermission().getStickyBit()) {
                targetFS.setPermission(path, srcFileStatus.getPermission());
            }
        } else if (attributes.contains((Object)DistCpOptions.FileAttribute.PERMISSION) && !srcFileStatus.getPermission().equals((Object)targetFileStatus.getPermission())) {
            targetFS.setPermission(path, srcFileStatus.getPermission());
        }
        boolean preserveXAttrs = attributes.contains((Object)DistCpOptions.FileAttribute.XATTR);
        if (preserveXAttrs || preserveRawXattrs) {
            String rawNS = XAttr.NameSpace.RAW.name().toLowerCase();
            Map<String, byte[]> srcXAttrs = srcFileStatus.getXAttrs();
            Map<String, byte[]> targetXAttrs = DistCpUtils.getXAttrs(targetFS, path);
            if (srcXAttrs != null && !srcXAttrs.equals(targetXAttrs)) {
                for (Map.Entry<String, byte[]> entry : srcXAttrs.entrySet()) {
                    String xattrName = entry.getKey();
                    if (!xattrName.startsWith(rawNS) && !preserveXAttrs) continue;
                    targetFS.setXAttr(path, xattrName, entry.getValue());
                }
            }
        }
        if (attributes.contains((Object)DistCpOptions.FileAttribute.REPLICATION) && !targetFileStatus.isDirectory() && srcFileStatus.getReplication() != targetFileStatus.getReplication()) {
            targetFS.setReplication(path, srcFileStatus.getReplication());
        }
        if (attributes.contains((Object)DistCpOptions.FileAttribute.GROUP) && !group.equals(srcFileStatus.getGroup())) {
            group = srcFileStatus.getGroup();
            chown = true;
        }
        if (attributes.contains((Object)DistCpOptions.FileAttribute.USER) && !user.equals(srcFileStatus.getOwner())) {
            user = srcFileStatus.getOwner();
            chown = true;
        }
        if (chown) {
            targetFS.setOwner(path, user, group);
        }
        if (attributes.contains((Object)DistCpOptions.FileAttribute.TIMES)) {
            targetFS.setTimes(path, srcFileStatus.getModificationTime(), srcFileStatus.getAccessTime());
        }
    }

    public static List<AclEntry> getAcl(FileSystem fileSystem, FileStatus fileStatus) throws IOException {
        List entries = fileSystem.getAclStatus(fileStatus.getPath()).getEntries();
        return AclUtil.getAclFromPermAndEntries((FsPermission)fileStatus.getPermission(), (List)entries);
    }

    public static Map<String, byte[]> getXAttrs(FileSystem fileSystem, Path path) throws IOException {
        return fileSystem.getXAttrs(path);
    }

    public static LinkedList<CopyListingFileStatus> toCopyListingFileStatus(FileSystem fileSystem, FileStatus fileStatus, boolean preserveAcls, boolean preserveXAttrs, boolean preserveRawXAttrs, int blocksPerChunk) throws IOException {
        LinkedList<CopyListingFileStatus> copyListingFileStatus = new LinkedList<CopyListingFileStatus>();
        CopyListingFileStatus clfs = DistCpUtils.toCopyListingFileStatusHelper(fileSystem, fileStatus, preserveAcls, preserveXAttrs, preserveRawXAttrs, 0L, fileStatus.getLen());
        long blockSize = fileStatus.getBlockSize();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("toCopyListing: " + fileStatus + " chunkSize: " + blocksPerChunk + " isDFS: " + (fileSystem instanceof DistributedFileSystem)));
        }
        if (blocksPerChunk > 0 && !fileStatus.isDirectory() && fileStatus.getLen() > blockSize * (long)blocksPerChunk) {
            BlockLocation[] blockLocations = fileSystem.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen());
            int numBlocks = blockLocations.length;
            long curPos = 0L;
            if (numBlocks <= blocksPerChunk) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("  add file " + clfs));
                }
                copyListingFileStatus.add(clfs);
            } else {
                int i = 0;
                while (i < numBlocks) {
                    long curLength = 0L;
                    for (int j = 0; j < blocksPerChunk && i < numBlocks; ++j, ++i) {
                        curLength += blockLocations[i].getLength();
                    }
                    if (curLength <= 0L) continue;
                    CopyListingFileStatus clfs1 = new CopyListingFileStatus(clfs);
                    clfs1.setChunkOffset(curPos);
                    clfs1.setChunkLength(curLength);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("  add file chunk " + clfs1));
                    }
                    copyListingFileStatus.add(clfs1);
                    curPos += curLength;
                }
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("  add file/dir " + clfs));
            }
            copyListingFileStatus.add(clfs);
        }
        return copyListingFileStatus;
    }

    public static CopyListingFileStatus toCopyListingFileStatusHelper(FileSystem fileSystem, FileStatus fileStatus, boolean preserveAcls, boolean preserveXAttrs, boolean preserveRawXAttrs, long chunkOffset, long chunkLength) throws IOException {
        FsPermission perm;
        CopyListingFileStatus copyListingFileStatus = new CopyListingFileStatus(fileStatus, chunkOffset, chunkLength);
        if (preserveAcls && (perm = fileStatus.getPermission()).getAclBit()) {
            List aclEntries = fileSystem.getAclStatus(fileStatus.getPath()).getEntries();
            copyListingFileStatus.setAclEntries(aclEntries);
        }
        if (preserveXAttrs || preserveRawXAttrs) {
            Map srcXAttrs = fileSystem.getXAttrs(fileStatus.getPath());
            if (preserveXAttrs && preserveRawXAttrs) {
                copyListingFileStatus.setXAttrs(srcXAttrs);
            } else {
                HashMap trgXAttrs = Maps.newHashMap();
                String rawNS = XAttr.NameSpace.RAW.name().toLowerCase();
                for (Map.Entry ent : srcXAttrs.entrySet()) {
                    String xattrName = (String)ent.getKey();
                    if (xattrName.startsWith(rawNS)) {
                        if (!preserveRawXAttrs) continue;
                        trgXAttrs.put(xattrName, ent.getValue());
                        continue;
                    }
                    if (!preserveXAttrs) continue;
                    trgXAttrs.put(xattrName, ent.getValue());
                }
                copyListingFileStatus.setXAttrs(trgXAttrs);
            }
        }
        return copyListingFileStatus;
    }

    public static Path sortListing(FileSystem fs, Configuration conf, Path sourceListing) throws IOException {
        SequenceFile.Sorter sorter = new SequenceFile.Sorter(fs, Text.class, CopyListingFileStatus.class, conf);
        Path output = new Path(sourceListing.toString() + "_sorted");
        if (fs.exists(output)) {
            fs.delete(output, false);
        }
        sorter.sort(sourceListing, output);
        return output;
    }

    public static void checkFileSystemAclSupport(FileSystem fs) throws CopyListing.AclsNotSupportedException {
        try {
            fs.getAclStatus(new Path("/"));
        }
        catch (Exception e) {
            throw new CopyListing.AclsNotSupportedException("ACLs not supported for file system: " + fs.getUri());
        }
    }

    public static void checkFileSystemXAttrSupport(FileSystem fs) throws CopyListing.XAttrsNotSupportedException {
        try {
            fs.getXAttrs(new Path("/"));
        }
        catch (Exception e) {
            throw new CopyListing.XAttrsNotSupportedException("XAttrs not supported for file system: " + fs.getUri());
        }
    }

    public static DecimalFormat getFormatter() {
        return FORMATTER.get();
    }

    public static String getStringDescriptionFor(long nBytes) {
        double current;
        char[] units = new char[]{'B', 'K', 'M', 'G', 'T', 'P'};
        double prev = current = (double)nBytes;
        int index = 0;
        while (true) {
            double d;
            current /= 1024.0;
            if (!(d >= 1.0)) break;
            prev = current;
            ++index;
        }
        assert (index < units.length) : "Too large a number.";
        return DistCpUtils.getFormatter().format(prev) + units[index];
    }

    public static boolean checksumsAreEqual(FileSystem sourceFS, Path source, FileChecksum sourceChecksum, FileSystem targetFS, Path target) throws IOException {
        FileChecksum targetChecksum = null;
        try {
            sourceChecksum = sourceChecksum != null ? sourceChecksum : sourceFS.getFileChecksum(source);
            targetChecksum = targetFS.getFileChecksum(target);
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to retrieve checksum for " + source + " or " + target), (Throwable)e);
        }
        return sourceChecksum == null || targetChecksum == null || sourceChecksum.equals((Object)targetChecksum);
    }

    public static Path getSplitChunkPath(Path targetFile, CopyListingFileStatus srcFileStatus) {
        return new Path(targetFile.toString() + ".____distcpSplit____" + srcFileStatus.getChunkOffset() + "." + srcFileStatus.getChunkLength());
    }
}

