/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.zookeeper.CreateMode;
import org.apache.hadoop.shaded.org.apache.zookeeper.data.ACL;
import org.apache.hadoop.util.curator.ZKCuratorManager;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;

public class ZKConfigurationStore
extends YarnConfigurationStore {
    public static final Log LOG = LogFactory.getLog(ZKConfigurationStore.class);
    private long maxLogs;
    @VisibleForTesting
    protected static final Version CURRENT_VERSION_INFO = Version.newInstance(0, 1);
    private Configuration conf;
    private YarnConfigurationStore.LogMutation pendingMutation;
    private String znodeParentPath;
    private static final String ZK_VERSION_PATH = "VERSION";
    private static final String LOGS_PATH = "LOGS";
    private static final String CONF_STORE_PATH = "CONF_STORE";
    private static final String FENCING_PATH = "FENCING";
    private String zkVersionPath;
    private String logsPath;
    private String confStorePath;
    private String fencingNodePath;
    @VisibleForTesting
    protected ZKCuratorManager zkManager;
    private List<ACL> zkAcl;

    @Override
    public void initialize(Configuration config, Configuration schedConf, RMContext rmContext) throws Exception {
        this.conf = config;
        this.maxLogs = this.conf.getLong("yarn.scheduler.configuration.store.max-logs", 1000L);
        this.znodeParentPath = this.conf.get("yarn.scheduler.configuration.zk-store.parent-path", "/confstore");
        this.zkManager = rmContext.getResourceManager().createAndStartZKManager(this.conf);
        this.zkAcl = ZKCuratorManager.getZKAcls((Configuration)this.conf);
        this.zkVersionPath = ZKConfigurationStore.getNodePath(this.znodeParentPath, ZK_VERSION_PATH);
        this.logsPath = ZKConfigurationStore.getNodePath(this.znodeParentPath, LOGS_PATH);
        this.confStorePath = ZKConfigurationStore.getNodePath(this.znodeParentPath, CONF_STORE_PATH);
        this.fencingNodePath = ZKConfigurationStore.getNodePath(this.znodeParentPath, FENCING_PATH);
        this.zkManager.createRootDirRecursively(this.znodeParentPath, this.zkAcl);
        this.zkManager.delete(this.fencingNodePath);
        if (!this.zkManager.exists(this.logsPath)) {
            this.zkManager.create(this.logsPath);
            this.zkManager.setData(this.logsPath, ZKConfigurationStore.serializeObject(new LinkedList()), -1);
        }
        if (!this.zkManager.exists(this.confStorePath)) {
            this.zkManager.create(this.confStorePath);
            HashMap mapSchedConf = new HashMap();
            for (Map.Entry entry : schedConf) {
                mapSchedConf.put(entry.getKey(), entry.getValue());
            }
            this.zkManager.setData(this.confStorePath, ZKConfigurationStore.serializeObject(mapSchedConf), -1);
        }
    }

    @VisibleForTesting
    protected LinkedList<YarnConfigurationStore.LogMutation> getLogs() throws Exception {
        return (LinkedList)ZKConfigurationStore.deserializeObject(this.zkManager.getData(this.logsPath));
    }

    @Override
    public Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    @Override
    public Version getConfStoreVersion() throws Exception {
        if (this.zkManager.exists(this.zkVersionPath)) {
            byte[] data = this.zkManager.getData(this.zkVersionPath);
            return new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom(data));
        }
        return null;
    }

    @Override
    public synchronized void storeVersion() throws Exception {
        byte[] data = ((VersionPBImpl)CURRENT_VERSION_INFO).getProto().toByteArray();
        if (this.zkManager.exists(this.zkVersionPath)) {
            this.zkManager.safeSetData(this.zkVersionPath, data, -1, this.zkAcl, this.fencingNodePath);
        } else {
            this.zkManager.safeCreate(this.zkVersionPath, data, this.zkAcl, CreateMode.PERSISTENT, this.zkAcl, this.fencingNodePath);
        }
    }

    @Override
    public void logMutation(YarnConfigurationStore.LogMutation logMutation) throws Exception {
        byte[] storedLogs = this.zkManager.getData(this.logsPath);
        LinkedList logs = new LinkedList();
        if (storedLogs != null) {
            logs = (LinkedList)ZKConfigurationStore.deserializeObject(storedLogs);
        }
        logs.add(logMutation);
        if ((long)logs.size() > this.maxLogs) {
            logs.remove(logs.removeFirst());
        }
        this.zkManager.safeSetData(this.logsPath, ZKConfigurationStore.serializeObject(logs), -1, this.zkAcl, this.fencingNodePath);
        this.pendingMutation = logMutation;
    }

    @Override
    public void confirmMutation(boolean isValid) throws Exception {
        if (isValid) {
            Configuration storedConfigs = this.retrieve();
            HashMap mapConf = new HashMap();
            for (Map.Entry storedConf : storedConfigs) {
                mapConf.put(storedConf.getKey(), storedConf.getValue());
            }
            for (Map.Entry<String, String> confChange : this.pendingMutation.getUpdates().entrySet()) {
                if (confChange.getValue() == null || confChange.getValue().isEmpty()) {
                    mapConf.remove(confChange.getKey());
                    continue;
                }
                mapConf.put(confChange.getKey(), confChange.getValue());
            }
            this.zkManager.safeSetData(this.confStorePath, ZKConfigurationStore.serializeObject(mapConf), -1, this.zkAcl, this.fencingNodePath);
        }
        this.pendingMutation = null;
    }

    @Override
    public synchronized Configuration retrieve() {
        byte[] serializedSchedConf;
        try {
            serializedSchedConf = this.zkManager.getData(this.confStorePath);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to retrieve configuration from zookeeper store", (Throwable)e);
            return null;
        }
        try {
            HashMap map = (HashMap)ZKConfigurationStore.deserializeObject(serializedSchedConf);
            Configuration c = new Configuration();
            for (Map.Entry e : map.entrySet()) {
                c.set((String)e.getKey(), (String)e.getValue());
            }
            return c;
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while deserializing scheduler configuration from store", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<YarnConfigurationStore.LogMutation> getConfirmedConfHistory(long fromId) {
        return null;
    }

    private static String getNodePath(String root, String nodeName) {
        return ZKCuratorManager.getNodePath((String)root, (String)nodeName);
    }

    /*
     * Exception decompiling
     */
    private static byte[] serializeObject(Object o) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static Object deserializeObject(byte[] bytes) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

