/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum;

import org.apache.hadoop.shaded.org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.DataTreeBean;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServerBean;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.LocalPeerBean;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.ReadOnlyBean;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.ReadOnlyRequestProcessor;

public class ReadOnlyZooKeeperServer
extends QuorumZooKeeperServer {
    private volatile boolean shutdown = false;

    ReadOnlyZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZooKeeperServer.DataTreeBuilder treeBuilder, ZKDatabase zkDb) {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, treeBuilder, zkDb, self);
    }

    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        PrepRequestProcessor prepProcessor = new PrepRequestProcessor(this, finalProcessor);
        prepProcessor.start();
        this.firstProcessor = new ReadOnlyRequestProcessor(this, prepProcessor);
        ((ReadOnlyRequestProcessor)this.firstProcessor).start();
    }

    public synchronized void startup() {
        if (this.shutdown) {
            LOG.warn("Not starting Read-only server as startup follows shutdown!");
            return;
        }
        this.registerJMX(new ReadOnlyBean(this), this.self.jmxLocalPeerBean);
        super.startup();
        this.self.cnxnFactory.setZooKeeperServer(this);
        LOG.info("Read-only server started");
    }

    protected void registerJMX() {
        try {
            this.jmxDataTreeBean = new DataTreeBean(this.getZKDatabase().getDataTree());
            MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
            this.jmxDataTreeBean = null;
        }
    }

    public void registerJMX(ZooKeeperServerBean serverBean, LocalPeerBean localPeerBean) {
        try {
            this.jmxServerBean = serverBean;
            MBeanRegistry.getInstance().register(serverBean, localPeerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
            this.jmxServerBean = null;
        }
    }

    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxDataTreeBean = null;
    }

    protected void unregisterJMX(ZooKeeperServer zks) {
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxServerBean = null;
    }

    public String getState() {
        return "read-only";
    }

    public long getServerId() {
        return this.self.getId();
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.unregisterJMX(this);
        this.self.cnxnFactory.setZooKeeperServer(null);
        this.self.cnxnFactory.closeAll();
        super.shutdown();
    }
}

