/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.cedarsoftware.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.shaded.com.cedarsoftware.util.StringUtilities;
import org.apache.hadoop.shaded.com.cedarsoftware.util.SystemUtilities;

public class UniqueIdGenerator {
    private static int count = 0;
    private static final int lastIp;
    private static final Map<Long, Long> lastId;
    private static final Log LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUniqueId() {
        Class<UniqueIdGenerator> clazz = UniqueIdGenerator.class;
        synchronized (UniqueIdGenerator.class) {
            long newId = UniqueIdGenerator.getUniqueIdAttempt();
            while (lastId.containsKey(newId)) {
                newId = UniqueIdGenerator.getUniqueIdAttempt();
            }
            lastId.put(newId, null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return newId;
        }
    }

    private static long getUniqueIdAttempt() {
        if (++count >= 1000) {
            count = 0;
        }
        return System.currentTimeMillis() * 100000L + (long)(count * 100) + (long)lastIp;
    }

    static {
        lastId = new LinkedHashMap<Long, Long>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, Long> eldest) {
                return this.size() > 1000;
            }
        };
        LOG = LogFactory.getLog(UniqueIdGenerator.class);
        String id = SystemUtilities.getExternalVariable("JAVA_UTIL_CLUSTERID");
        if (StringUtilities.isEmpty(id)) {
            byte[] ip;
            try {
                ip = InetAddress.getLocalHost().getAddress();
            }
            catch (UnknownHostException e) {
                ip = new byte[]{0, 0, 0, 0};
                LOG.warn((Object)"Failed to obtain computer's IP address", (Throwable)e);
            }
            lastIp = (ip[3] & 0xFF) % 100;
        } else {
            try {
                lastIp = Integer.parseInt(id) % 100;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Environment / System variable JAVA_UTIL_CLUSTERID must be 0-99");
            }
        }
    }
}

