/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.server.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.registry.client.types.Endpoint;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.registry.server.dns.BaseServiceRecordProcessor;
import org.apache.hadoop.registry.server.dns.RecordCreatorFactory;
import org.apache.hadoop.registry.server.dns.ZoneSelector;
import org.apache.hadoop.shaded.org.xbill.DNS.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationServiceRecordProcessor
extends BaseServiceRecordProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationServiceRecordProcessor.class);

    public ApplicationServiceRecordProcessor(ServiceRecord record, String path, String domain, ZoneSelector zoneSelector) throws Exception {
        super(record, path, domain, zoneSelector);
    }

    @Override
    public void initTypeToInfoMapping(ServiceRecord serviceRecord) throws Exception {
        if (serviceRecord.external.isEmpty()) {
            LOG.info(serviceRecord.description + ": No external endpoints defined.");
            return;
        }
        block7: for (int type : this.getRecordTypes()) {
            switch (type) {
                case 1: {
                    this.createAInfo(serviceRecord);
                    continue block7;
                }
                case 28: {
                    this.createAAAAInfo(serviceRecord);
                    continue block7;
                }
                case 16: {
                    this.createTXTInfo(serviceRecord);
                    continue block7;
                }
                case 5: {
                    this.createCNAMEInfo(serviceRecord);
                    continue block7;
                }
                case 33: {
                    this.createSRVInfo(serviceRecord);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type " + type);
                }
            }
        }
    }

    protected void createTXTInfo(ServiceRecord serviceRecord) throws Exception {
        List<Endpoint> endpoints = serviceRecord.external;
        ArrayList<BaseServiceRecordProcessor.RecordDescriptor> recordDescriptors = new ArrayList<BaseServiceRecordProcessor.RecordDescriptor>();
        for (Endpoint endpoint : endpoints) {
            TXTApplicationRecordDescriptor txtInfo = new TXTApplicationRecordDescriptor(serviceRecord, endpoint);
            recordDescriptors.add(txtInfo);
        }
        this.registerRecordDescriptor(16, recordDescriptors);
    }

    protected void createSRVInfo(ServiceRecord serviceRecord) throws Exception {
        List<Endpoint> endpoints = serviceRecord.external;
        ArrayList<BaseServiceRecordProcessor.RecordDescriptor> recordDescriptors = new ArrayList<BaseServiceRecordProcessor.RecordDescriptor>();
        for (Endpoint endpoint : endpoints) {
            SRVApplicationRecordDescriptor srvInfo = new SRVApplicationRecordDescriptor(serviceRecord, endpoint);
            recordDescriptors.add(srvInfo);
        }
        this.registerRecordDescriptor(33, recordDescriptors);
    }

    protected void createCNAMEInfo(ServiceRecord serviceRecord) throws Exception {
        List<Endpoint> endpoints = serviceRecord.external;
        ArrayList<BaseServiceRecordProcessor.RecordDescriptor> recordDescriptors = new ArrayList<BaseServiceRecordProcessor.RecordDescriptor>();
        for (Endpoint endpoint : endpoints) {
            CNAMEApplicationRecordDescriptor cnameInfo = new CNAMEApplicationRecordDescriptor(serviceRecord, endpoint);
            recordDescriptors.add(cnameInfo);
        }
        this.registerRecordDescriptor(5, recordDescriptors);
    }

    protected void createAAAAInfo(ServiceRecord record) throws Exception {
        AAAAApplicationRecordDescriptor recordInfo = new AAAAApplicationRecordDescriptor(this.getPath(), record);
        this.registerRecordDescriptor(28, recordInfo);
    }

    protected void createAInfo(ServiceRecord record) throws Exception {
        AApplicationRecordDescriptor recordInfo = new AApplicationRecordDescriptor(this.getPath(), record);
        this.registerRecordDescriptor(1, recordInfo);
    }

    @Override
    public int[] getRecordTypes() {
        return new int[]{1, 28, 5, 33, 16};
    }

    class AAAAApplicationRecordDescriptor
    extends AApplicationRecordDescriptor {
        public AAAAApplicationRecordDescriptor(String path, ServiceRecord record) throws Exception {
            super(path, record);
        }

        @Override
        protected void init(ServiceRecord serviceRecord) throws Exception {
            super.init(serviceRecord);
            if (this.getTarget() == null) {
                return;
            }
            try {
                this.setTarget(BaseServiceRecordProcessor.getIpv6Address((InetAddress)this.getTarget()));
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    class AApplicationRecordDescriptor
    extends BaseServiceRecordProcessor.ApplicationRecordDescriptor<InetAddress> {
        public AApplicationRecordDescriptor(String path, ServiceRecord record) throws Exception {
            super(record);
        }

        @Override
        protected void init(ServiceRecord serviceRecord) throws Exception {
            this.setNames(new Name[]{this.getServiceName()});
            List<Endpoint> endpoints = serviceRecord.external;
            if (endpoints.isEmpty()) {
                return;
            }
            this.setTarget(InetAddress.getByName(this.getHost(endpoints.get(0))));
        }
    }

    class CNAMEApplicationRecordDescriptor
    extends BaseServiceRecordProcessor.ApplicationRecordDescriptor<Name> {
        public CNAMEApplicationRecordDescriptor(String path, ServiceRecord record) throws Exception {
            super(record);
        }

        public CNAMEApplicationRecordDescriptor(ServiceRecord record, Endpoint endpoint) throws Exception {
            super(record, endpoint);
        }

        @Override
        protected void init(ServiceRecord serviceRecord) throws Exception {
            if (this.getEndpoint() != null) {
                this.setNames(new Name[]{this.getEndpointName()});
                this.setTarget(this.getServiceName());
            }
        }
    }

    class SRVApplicationRecordDescriptor
    extends BaseServiceRecordProcessor.ApplicationRecordDescriptor<RecordCreatorFactory.HostPortInfo> {
        public SRVApplicationRecordDescriptor(ServiceRecord record, Endpoint endpoint) throws Exception {
            super(record, endpoint);
        }

        @Override
        protected void init(ServiceRecord serviceRecord) throws Exception {
            if (this.getEndpoint() != null) {
                this.setNames(new Name[]{this.getServiceName(), this.getEndpointName()});
                this.setTarget(new RecordCreatorFactory.HostPortInfo(Name.fromString(this.getHost(this.getEndpoint()) + "."), this.getPort(this.getEndpoint())));
            }
        }
    }

    class TXTApplicationRecordDescriptor
    extends BaseServiceRecordProcessor.ApplicationRecordDescriptor<List<String>> {
        public TXTApplicationRecordDescriptor(ServiceRecord record, Endpoint endpoint) throws Exception {
            super(record, endpoint);
        }

        @Override
        protected void init(ServiceRecord serviceRecord) throws Exception {
            if (this.getEndpoint() != null) {
                this.setNames(new Name[]{this.getServiceName(), this.getEndpointName()});
                this.setTarget(this.getTextRecords(this.getEndpoint()));
            }
        }
    }
}

