/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;

public class INodesInPath {
    public static final Log LOG = LogFactory.getLog(INodesInPath.class);
    private final byte[][] path;
    private volatile String pathname;
    private final INode[] inodes;
    private final boolean isSnapshot;
    private final boolean isRaw;
    private final int snapshotId;

    private static boolean isDotSnapshotDir(byte[] pathComponent) {
        return pathComponent != null && Arrays.equals(HdfsServerConstants.DOT_SNAPSHOT_DIR_BYTES, pathComponent);
    }

    private static INode[] getINodes(INode inode) {
        INode tmp;
        int depth = 0;
        for (tmp = inode; tmp != null; tmp = tmp.getParent()) {
            ++depth;
        }
        INode[] inodes = new INode[depth];
        int index = depth;
        for (tmp = inode; tmp != null; tmp = tmp.getParent()) {
            inodes[--index] = tmp;
        }
        return inodes;
    }

    private static byte[][] getPaths(INode[] inodes) {
        byte[][] paths = new byte[inodes.length][];
        for (int i = 0; i < inodes.length; ++i) {
            paths[i] = inodes[i].getKey();
        }
        return paths;
    }

    static INodesInPath fromINode(INode inode) {
        INode[] inodes = INodesInPath.getINodes(inode);
        byte[][] paths = INodesInPath.getPaths(inodes);
        return new INodesInPath(inodes, paths);
    }

    static INodesInPath fromINode(INodeDirectory rootDir, INode inode) {
        byte[][] paths = INodesInPath.getPaths(INodesInPath.getINodes(inode));
        return INodesInPath.resolve(rootDir, paths);
    }

    static INodesInPath fromComponents(byte[][] components) {
        return new INodesInPath(new INode[components.length], components);
    }

    static INodesInPath resolve(INodeDirectory startingDir, byte[][] components) {
        return INodesInPath.resolve(startingDir, components, false);
    }

    static INodesInPath resolve(INodeDirectory startingDir, byte[][] components, boolean isRaw) {
        Preconditions.checkArgument((startingDir.compareTo(components[0]) == 0 ? 1 : 0) != 0);
        INode curNode = startingDir;
        int count = 0;
        int inodeNum = 0;
        INode[] inodes = new INode[components.length];
        boolean isSnapshot = false;
        int snapshotId = 0x7FFFFFFE;
        while (count < components.length && curNode != null) {
            byte[] childName;
            INodeDirectory dir;
            boolean lastComp = count == components.length - 1;
            inodes[inodeNum++] = curNode;
            boolean isRef = curNode.isReference();
            boolean isDir = ((INode)curNode).isDirectory();
            INodeDirectory iNodeDirectory = dir = isDir ? ((INode)curNode).asDirectory() : null;
            if (!isRef && isDir && dir.isWithSnapshot()) {
                if (!isSnapshot && INodesInPath.shouldUpdateLatestId(dir.getDirectoryWithSnapshotFeature().getLastSnapshotId(), snapshotId)) {
                    snapshotId = dir.getDirectoryWithSnapshotFeature().getLastSnapshotId();
                }
            } else if (isRef && isDir && !lastComp && !isSnapshot) {
                int dstSnapshotId = curNode.asReference().getDstSnapshotId();
                if (snapshotId == 0x7FFFFFFE || dstSnapshotId != 0x7FFFFFFE && dstSnapshotId >= snapshotId) {
                    DirectoryWithSnapshotFeature sf;
                    int lastSnapshot = 0x7FFFFFFE;
                    if (((INode)curNode).isDirectory() && (sf = ((INode)curNode).asDirectory().getDirectoryWithSnapshotFeature()) != null) {
                        lastSnapshot = sf.getLastSnapshotId();
                    }
                    snapshotId = lastSnapshot;
                }
            }
            if (lastComp || !isDir) break;
            if (INodesInPath.isDotSnapshotDir(childName = components[++count]) && dir.isSnapshottable()) {
                isSnapshot = true;
                if (count == components.length - 1) break;
                Snapshot s = dir.getSnapshot(components[count + 1]);
                if (s == null) {
                    curNode = null;
                } else {
                    curNode = s.getRoot();
                    snapshotId = s.getId();
                }
                byte[][] componentsCopy = (byte[][])Arrays.copyOf(components, components.length - 1);
                componentsCopy[count] = DFSUtil.string2Bytes(DFSUtil.byteArray2PathString(components, count, 2));
                int start = count + 2;
                System.arraycopy(components, start, componentsCopy, count + 1, components.length - start);
                components = componentsCopy;
                inodes = Arrays.copyOf(inodes, components.length);
                continue;
            }
            curNode = dir.getChild(childName, isSnapshot ? snapshotId : 0x7FFFFFFE);
        }
        return new INodesInPath(inodes, components, isRaw, isSnapshot, snapshotId);
    }

    private static boolean shouldUpdateLatestId(int sid, int snapshotId) {
        return snapshotId == 0x7FFFFFFE || sid != 0x7FFFFFFE && Snapshot.ID_INTEGER_COMPARATOR.compare(snapshotId, sid) < 0;
    }

    public static INodesInPath replace(INodesInPath iip, int pos, INode inode) {
        Preconditions.checkArgument((iip.length() > 0 && pos > 0 && pos < iip.length() ? 1 : 0) != 0);
        if (iip.getINode(pos) == null) {
            Preconditions.checkState((iip.getINode(pos - 1) != null ? 1 : 0) != 0);
        }
        INode[] inodes = new INode[iip.inodes.length];
        System.arraycopy(iip.inodes, 0, inodes, 0, inodes.length);
        inodes[pos] = inode;
        return new INodesInPath(inodes, iip.path, iip.isRaw, iip.isSnapshot, iip.snapshotId);
    }

    public static INodesInPath append(INodesInPath iip, INode child, byte[] childName) {
        Preconditions.checkArgument((iip.length() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((iip.getLastINode() != null && iip.getLastINode().isDirectory() ? 1 : 0) != 0);
        INode[] inodes = new INode[iip.length() + 1];
        System.arraycopy(iip.inodes, 0, inodes, 0, inodes.length - 1);
        inodes[inodes.length - 1] = child;
        byte[][] path = new byte[iip.path.length + 1][];
        System.arraycopy(iip.path, 0, path, 0, path.length - 1);
        path[path.length - 1] = childName;
        return new INodesInPath(inodes, path, iip.isRaw, iip.isSnapshot, iip.snapshotId);
    }

    private INodesInPath(INode[] inodes, byte[][] path, boolean isRaw, boolean isSnapshot, int snapshotId) {
        Preconditions.checkArgument((inodes != null && path != null ? 1 : 0) != 0);
        this.inodes = inodes;
        this.path = path;
        this.isRaw = isRaw;
        this.isSnapshot = isSnapshot;
        this.snapshotId = snapshotId;
    }

    private INodesInPath(INode[] inodes, byte[][] path) {
        this(inodes, path, false, false, 0x7FFFFFFE);
    }

    public int getLatestSnapshotId() {
        Preconditions.checkState((!this.isSnapshot ? 1 : 0) != 0);
        return this.snapshotId;
    }

    public int getPathSnapshotId() {
        return this.isSnapshot ? this.snapshotId : 0x7FFFFFFE;
    }

    public INode getINode(int i) {
        return this.inodes[i < 0 ? this.inodes.length + i : i];
    }

    public INode getLastINode() {
        return this.getINode(-1);
    }

    byte[] getLastLocalName() {
        return this.path[this.path.length - 1];
    }

    public byte[][] getPathComponents() {
        return this.path;
    }

    public byte[] getPathComponent(int i) {
        return this.path[i];
    }

    public String getPath() {
        if (this.pathname == null) {
            this.pathname = DFSUtil.byteArray2PathString(this.path);
        }
        return this.pathname;
    }

    public String getParentPath() {
        return this.getPath(this.path.length - 2);
    }

    public String getPath(int pos) {
        return DFSUtil.byteArray2PathString(this.path, 0, pos + 1);
    }

    public int length() {
        return this.inodes.length;
    }

    public INode[] getINodesArray() {
        INode[] retArr = new INode[this.inodes.length];
        System.arraycopy(this.inodes, 0, retArr, 0, this.inodes.length);
        return retArr;
    }

    private INodesInPath getAncestorINodesInPath(int length) {
        Preconditions.checkArgument((length >= 0 && length < this.inodes.length ? 1 : 0) != 0);
        Preconditions.checkState((this.isDotSnapshotDir() || !this.isSnapshot() ? 1 : 0) != 0);
        INode[] anodes = new INode[length];
        byte[][] apath = new byte[length][];
        System.arraycopy(this.inodes, 0, anodes, 0, length);
        System.arraycopy(this.path, 0, apath, 0, length);
        return new INodesInPath(anodes, apath, this.isRaw, false, this.snapshotId);
    }

    public INodesInPath getParentINodesInPath() {
        return this.inodes.length > 1 ? this.getAncestorINodesInPath(this.inodes.length - 1) : null;
    }

    public boolean isDescendant(INodeDirectory inodeDirectory) {
        INodesInPath dirIIP = INodesInPath.fromINode(inodeDirectory);
        return this.isDescendant(dirIIP);
    }

    private boolean isDescendant(INodesInPath ancestorDirIIP) {
        int ancestorDirINodesLength = ancestorDirIIP.length();
        int myParentINodesLength = this.length() - 1;
        if (myParentINodesLength < ancestorDirINodesLength) {
            return false;
        }
        for (int index = 0; index < ancestorDirINodesLength; ++index) {
            if (this.inodes[index] == ancestorDirIIP.getINode(index)) continue;
            return false;
        }
        return true;
    }

    public INodesInPath getExistingINodes() {
        Preconditions.checkState((!this.isSnapshot() ? 1 : 0) != 0);
        for (int i = this.inodes.length; i > 0; --i) {
            if (this.inodes[i - 1] == null) continue;
            return i == this.inodes.length ? this : this.getAncestorINodesInPath(i);
        }
        return null;
    }

    boolean isSnapshot() {
        return this.isSnapshot;
    }

    boolean isDotSnapshotDir() {
        return INodesInPath.isDotSnapshotDir(this.getLastLocalName());
    }

    public boolean isRaw() {
        return this.isRaw;
    }

    private static String toString(INode inode) {
        return inode == null ? null : inode.getLocalName();
    }

    public String toString() {
        return this.toString(true);
    }

    private String toString(boolean vaildateObject) {
        if (vaildateObject) {
            this.validate();
        }
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName()).append(": path = ").append(this.getPath()).append("\n  inodes = ");
        if (this.inodes == null) {
            b.append("null");
        } else if (this.inodes.length == 0) {
            b.append("[]");
        } else {
            b.append("[").append(INodesInPath.toString(this.inodes[0]));
            for (int i = 1; i < this.inodes.length; ++i) {
                b.append(", ").append(INodesInPath.toString(this.inodes[i]));
            }
            b.append("], length=").append(this.inodes.length);
        }
        b.append("\n  isSnapshot        = ").append(this.isSnapshot).append("\n  snapshotId        = ").append(this.snapshotId);
        return b.toString();
    }

    void validate() {
        int i = 0;
        if (this.inodes[i] != null) {
            ++i;
            while (i < this.inodes.length && this.inodes[i] != null) {
                INodeDirectory parent_i = this.inodes[i].getParent();
                INodeDirectory parent_i_1 = this.inodes[i - 1].getParent();
                if (!(parent_i == this.inodes[i - 1] || parent_i_1 != null && parent_i_1.isSnapshottable() && parent_i == parent_i_1)) {
                    throw new AssertionError((Object)("inodes[" + i + "].getParent() != inodes[" + (i - 1) + "]\n  inodes[" + i + "]=" + this.inodes[i].toDetailString() + "\n  inodes[" + (i - 1) + "]=" + this.inodes[i - 1].toDetailString() + "\n this=" + this.toString(false)));
                }
                ++i;
            }
        }
        if (i != this.inodes.length) {
            throw new AssertionError((Object)("i = " + i + " != " + this.inodes.length + ", this=" + this.toString(false)));
        }
    }
}

