/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.command;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.diskbalancer.command.CancelCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.command.Command;
import org.apache.hadoop.hdfs.server.diskbalancer.command.ExecuteCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.command.PlanCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.command.QueryCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.command.ReportCommand;
import org.apache.hadoop.hdfs.tools.DiskBalancerCLI;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.shaded.org.apache.commons.cli.HelpFormatter;

public class HelpCommand
extends Command {
    public HelpCommand(Configuration conf) {
        super(conf);
        this.addValidCommandParameters("help", "Help Command");
    }

    @Override
    public void execute(CommandLine cmd) throws Exception {
        LOG.debug("Processing help Command.");
        if (cmd == null) {
            this.printHelp();
            return;
        }
        Preconditions.checkState((boolean)cmd.hasOption("help"));
        this.verifyCommandOptions("help", cmd);
        String helpCommand = cmd.getOptionValue("help");
        if (helpCommand == null || helpCommand.isEmpty()) {
            this.printHelp();
            return;
        }
        helpCommand = helpCommand.trim();
        helpCommand = helpCommand.toLowerCase();
        Command command = null;
        switch (helpCommand) {
            case "plan": {
                command = new PlanCommand(this.getConf());
                break;
            }
            case "execute": {
                command = new ExecuteCommand(this.getConf());
                break;
            }
            case "query": {
                command = new QueryCommand(this.getConf());
                break;
            }
            case "cancel": {
                command = new CancelCommand(this.getConf());
                break;
            }
            case "report": {
                command = new ReportCommand(this.getConf());
                break;
            }
            default: {
                command = this;
            }
        }
        ((Command)command).printHelp();
    }

    @Override
    public void printHelp() {
        String header = "\nDiskBalancer distributes data evenly between different disks on a datanode. DiskBalancer operates by generating a plan, that tells datanode how to move data between disks. Users can execute a plan by submitting it to the datanode. \nTo get specific help on a particular command please run \n\n hdfs diskbalancer -help <command>.";
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("hdfs diskbalancer [command] [options]", header, DiskBalancerCLI.getHelpOptions(), "");
    }
}

