/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Set;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.util.resource.Resources;

public class CapacityHeadroomProvider {
    UsersManager.User user;
    LeafQueue queue;
    FiCaSchedulerApp application;
    LeafQueue.QueueResourceLimitsInfo queueResourceLimitsInfo;

    public CapacityHeadroomProvider(UsersManager.User user, LeafQueue queue, FiCaSchedulerApp application, LeafQueue.QueueResourceLimitsInfo queueResourceLimitsInfo) {
        this.user = user;
        this.queue = queue;
        this.application = application;
        this.queueResourceLimitsInfo = queueResourceLimitsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getHeadroom() {
        Resource headroom;
        Resource clusterResource;
        Resource queueCurrentLimit;
        LeafQueue.QueueResourceLimitsInfo queueResourceLimitsInfo = this.queueResourceLimitsInfo;
        synchronized (queueResourceLimitsInfo) {
            queueCurrentLimit = this.queueResourceLimitsInfo.getQueueCurrentLimit();
            clusterResource = this.queueResourceLimitsInfo.getClusterResource();
        }
        Set<String> requestedPartitions = this.application.getAppSchedulingInfo().getRequestedPartitions();
        if (requestedPartitions.isEmpty() || requestedPartitions.size() == 1 && requestedPartitions.contains("")) {
            headroom = this.queue.getHeadroom(this.user, queueCurrentLimit, clusterResource, this.application);
        } else {
            headroom = Resource.newInstance((int)0, (int)0);
            for (String partition : requestedPartitions) {
                Resource partitionHeadRoom = this.queue.getHeadroom(this.user, queueCurrentLimit, clusterResource, this.application, partition);
                Resources.addTo((Resource)headroom, (Resource)partitionHeadRoom);
            }
        }
        if (headroom.getMemorySize() < 0L) {
            headroom.setMemorySize(0L);
        }
        return headroom;
    }
}

