/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.org.fusesource.leveldbjni.JniDBFactory;
import org.apache.hadoop.shaded.org.fusesource.leveldbjni.internal.NativeDB;
import org.apache.hadoop.shaded.org.iq80.leveldb.DB;
import org.apache.hadoop.shaded.org.iq80.leveldb.DBException;
import org.apache.hadoop.shaded.org.iq80.leveldb.Options;
import org.apache.hadoop.shaded.org.iq80.leveldb.WriteBatch;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerRecoveryProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreUtils;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.AMRMTokenSecretManagerState;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.Epoch;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMDelegationTokenIdentifierData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.AMRMTokenSecretManagerStatePBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.utils.LeveldbIterator;

public class LeveldbRMStateStore
extends RMStateStore {
    public static final Log LOG = LogFactory.getLog(LeveldbRMStateStore.class);
    private static final String SEPARATOR = "/";
    private static final String DB_NAME = "yarn-rm-state";
    private static final String RM_DT_MASTER_KEY_KEY_PREFIX = "RMDTSecretManagerRoot/DelegationKey_";
    private static final String RM_DT_TOKEN_KEY_PREFIX = "RMDTSecretManagerRoot/RMDelegationToken_";
    private static final String RM_DT_SEQUENCE_NUMBER_KEY = "RMDTSecretManagerRoot/RMDTSequentialNumber";
    private static final String RM_APP_KEY_PREFIX = "RMAppRoot/application";
    private static final String RM_RESERVATION_KEY_PREFIX = "ReservationSystemRoot/";
    private static final Version CURRENT_VERSION_INFO = Version.newInstance(1, 1);
    private DB db;
    private Timer compactionTimer;
    private long compactionIntervalMsec;

    private String getApplicationNodeKey(ApplicationId appId) {
        return "RMAppRoot/" + appId;
    }

    private String getApplicationAttemptNodeKey(ApplicationAttemptId attemptId) {
        return this.getApplicationAttemptNodeKey(this.getApplicationNodeKey(attemptId.getApplicationId()), attemptId);
    }

    private String getApplicationAttemptNodeKey(String appNodeKey, ApplicationAttemptId attemptId) {
        return appNodeKey + SEPARATOR + attemptId;
    }

    private String getRMDTMasterKeyNodeKey(DelegationKey masterKey) {
        return RM_DT_MASTER_KEY_KEY_PREFIX + masterKey.getKeyId();
    }

    private String getRMDTTokenNodeKey(RMDelegationTokenIdentifier tokenId) {
        return RM_DT_TOKEN_KEY_PREFIX + tokenId.getSequenceNumber();
    }

    private String getReservationNodeKey(String planName, String reservationId) {
        return RM_RESERVATION_KEY_PREFIX + planName + SEPARATOR + reservationId;
    }

    @Override
    protected void initInternal(Configuration conf) throws Exception {
        this.compactionIntervalMsec = conf.getLong("yarn.resourcemanager.leveldb-state-store.compaction-interval-secs", 3600L) * 1000L;
    }

    private Path getStorageDir() throws IOException {
        Configuration conf = this.getConfig();
        String storePath = conf.get("yarn.resourcemanager.leveldb-state-store.path");
        if (storePath == null) {
            throw new IOException("No store location directory configured in yarn.resourcemanager.leveldb-state-store.path");
        }
        return new Path(storePath, DB_NAME);
    }

    private Path createStorageDir() throws IOException {
        Path root = this.getStorageDir();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.getConfig());
        fs.mkdirs(root, new FsPermission(448));
        return root;
    }

    @Override
    protected void startInternal() throws Exception {
        this.db = this.openDatabase();
        this.startCompactionTimer();
    }

    protected DB openDatabase() throws Exception {
        Path storeRoot = this.createStorageDir();
        Options options = new Options();
        options.createIfMissing(false);
        LOG.info((Object)("Using state database at " + storeRoot + " for recovery"));
        File dbfile = new File(storeRoot.toString());
        try {
            this.db = JniDBFactory.factory.open(dbfile, options);
        }
        catch (NativeDB.DBException e) {
            if (e.isNotFound() || e.getMessage().contains(" does not exist ")) {
                LOG.info((Object)("Creating state database at " + dbfile));
                options.createIfMissing(true);
                try {
                    this.db = JniDBFactory.factory.open(dbfile, options);
                    this.storeVersion();
                }
                catch (DBException dbErr) {
                    throw new IOException(dbErr.getMessage(), dbErr);
                }
            }
            throw e;
        }
        return this.db;
    }

    private void startCompactionTimer() {
        if (this.compactionIntervalMsec > 0L) {
            this.compactionTimer = new Timer(((Object)((Object)this)).getClass().getSimpleName() + " compaction timer", true);
            this.compactionTimer.schedule((TimerTask)new CompactionTimerTask(), this.compactionIntervalMsec, this.compactionIntervalMsec);
        }
    }

    @Override
    protected void closeInternal() throws Exception {
        if (this.compactionTimer != null) {
            this.compactionTimer.cancel();
            this.compactionTimer = null;
        }
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
    }

    @VisibleForTesting
    boolean isClosed() {
        return this.db == null;
    }

    @VisibleForTesting
    DB getDatabase() {
        return this.db;
    }

    @Override
    protected Version loadVersion() throws Exception {
        VersionPBImpl version = null;
        try {
            byte[] data = this.db.get(JniDBFactory.bytes((String)"RMVersionNode"));
            if (data != null) {
                version = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom(data));
            }
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        return version;
    }

    @Override
    protected void storeVersion() throws Exception {
        this.dbStoreVersion(CURRENT_VERSION_INFO);
    }

    void dbStoreVersion(Version state) throws IOException {
        String key = "RMVersionNode";
        byte[] data = ((VersionPBImpl)state).getProto().toByteArray();
        try {
            this.db.put(JniDBFactory.bytes((String)key), data);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    @Override
    public synchronized long getAndIncrementEpoch() throws Exception {
        long currentEpoch = this.baseEpoch;
        byte[] dbKeyBytes = JniDBFactory.bytes((String)"EpochNode");
        try {
            byte[] data = this.db.get(dbKeyBytes);
            if (data != null) {
                currentEpoch = YarnServerResourceManagerRecoveryProtos.EpochProto.parseFrom(data).getEpoch();
            }
            YarnServerResourceManagerRecoveryProtos.EpochProto proto = Epoch.newInstance(currentEpoch + 1L).getProto();
            this.db.put(dbKeyBytes, proto.toByteArray());
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        return currentEpoch;
    }

    @Override
    public RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState rmState = new RMStateStore.RMState();
        this.loadRMDTSecretManagerState(rmState);
        this.loadRMApps(rmState);
        this.loadAMRMTokenSecretManagerState(rmState);
        this.loadReservationState(rmState);
        return rmState;
    }

    private void loadReservationState(RMStateStore.RMState rmState) throws IOException {
        int numReservations = 0;
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)RM_RESERVATION_KEY_PREFIX));
            while (iter.hasNext()) {
                Object entry = iter.next();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(RM_RESERVATION_KEY_PREFIX)) {
                    break;
                }
                String planReservationString = key.substring(RM_RESERVATION_KEY_PREFIX.length());
                String[] parts = planReservationString.split(SEPARATOR);
                if (parts.length != 2) {
                    LOG.warn((Object)("Incorrect reservation state key " + key));
                    continue;
                }
                String planName = parts[0];
                String reservationName = parts[1];
                YarnProtos.ReservationAllocationStateProto allocationState = YarnProtos.ReservationAllocationStateProto.parseFrom((byte[])((byte[])entry.getValue()));
                if (!rmState.getReservationState().containsKey(planName)) {
                    rmState.getReservationState().put(planName, new HashMap());
                }
                ReservationId reservationId = ReservationId.parseReservationId((String)reservationName);
                rmState.getReservationState().get(planName).put(reservationId, allocationState);
                ++numReservations;
            }
        }
        LOG.info((Object)("Recovered " + numReservations + " reservations"));
    }

    private void loadRMDTSecretManagerState(RMStateStore.RMState state) throws IOException {
        int numKeys = this.loadRMDTSecretManagerKeys(state);
        LOG.info((Object)("Recovered " + numKeys + " RM delegation token master keys"));
        int numTokens = this.loadRMDTSecretManagerTokens(state);
        LOG.info((Object)("Recovered " + numTokens + " RM delegation tokens"));
        this.loadRMDTSecretManagerTokenSequenceNumber(state);
    }

    private int loadRMDTSecretManagerKeys(RMStateStore.RMState state) throws IOException {
        int numKeys = 0;
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)RM_DT_MASTER_KEY_KEY_PREFIX));
            while (iter.hasNext()) {
                Object entry = iter.next();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(RM_DT_MASTER_KEY_KEY_PREFIX)) {
                    break;
                }
                DelegationKey masterKey = this.loadDelegationKey((byte[])entry.getValue());
                state.rmSecretManagerState.masterKeyState.add(masterKey);
                ++numKeys;
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Loaded RM delegation key from " + key + ": keyId=" + masterKey.getKeyId() + ", expirationDate=" + masterKey.getExpiryDate()));
            }
        }
        return numKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DelegationKey loadDelegationKey(byte[] data) throws IOException {
        DelegationKey key = new DelegationKey();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        try {
            key.readFields((DataInput)in);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
        return key;
    }

    private int loadRMDTSecretManagerTokens(RMStateStore.RMState state) throws IOException {
        int numTokens = 0;
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)RM_DT_TOKEN_KEY_PREFIX));
            while (iter.hasNext()) {
                Object entry = iter.next();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(RM_DT_TOKEN_KEY_PREFIX)) {
                    break;
                }
                RMDelegationTokenIdentifierData tokenData = this.loadDelegationToken((byte[])entry.getValue());
                RMDelegationTokenIdentifier tokenId = tokenData.getTokenIdentifier();
                long renewDate = tokenData.getRenewDate();
                state.rmSecretManagerState.delegationTokenState.put(tokenId, renewDate);
                ++numTokens;
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Loaded RM delegation token from " + key + ": tokenId=" + tokenId + ", renewDate=" + renewDate));
            }
        }
        return numTokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RMDelegationTokenIdentifierData loadDelegationToken(byte[] data) throws IOException {
        RMDelegationTokenIdentifierData tokenData = null;
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        try {
            tokenData = RMStateStoreUtils.readRMDelegationTokenIdentifierData(in);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
        return tokenData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRMDTSecretManagerTokenSequenceNumber(RMStateStore.RMState state) throws IOException {
        byte[] data = null;
        try {
            data = this.db.get(JniDBFactory.bytes((String)RM_DT_SEQUENCE_NUMBER_KEY));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        if (data != null) {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            try {
                state.rmSecretManagerState.dtSequenceNumber = in.readInt();
            }
            catch (Throwable throwable) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
                throw throwable;
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
        }
    }

    private void loadRMApps(RMStateStore.RMState state) throws IOException {
        int numApps = 0;
        int numAppAttempts = 0;
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)RM_APP_KEY_PREFIX));
            while (iter.hasNext()) {
                Object entry = iter.next();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(RM_APP_KEY_PREFIX)) {
                    break;
                }
                String appIdStr = key.substring("RMAppRoot".length() + 1);
                if (appIdStr.contains(SEPARATOR)) {
                    LOG.warn((Object)("Skipping extraneous data " + key));
                    continue;
                }
                numAppAttempts += this.loadRMApp(state, iter, appIdStr, (byte[])entry.getValue());
                ++numApps;
            }
        }
        LOG.info((Object)("Recovered " + numApps + " applications and " + numAppAttempts + " application attempts"));
    }

    private int loadRMApp(RMStateStore.RMState rmState, LeveldbIterator iter, String appIdStr, byte[] appData) throws IOException {
        Map.Entry<byte[], byte[]> entry;
        String key;
        ApplicationStateData appState = this.createApplicationState(appIdStr, appData);
        ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
        rmState.appState.put(appId, appState);
        String attemptNodePrefix = this.getApplicationNodeKey(appId) + SEPARATOR;
        while (iter.hasNext() && (key = JniDBFactory.asString((byte[])(entry = iter.peekNext()).getKey())).startsWith(attemptNodePrefix)) {
            String attemptId = key.substring(attemptNodePrefix.length());
            if (attemptId.startsWith("appattempt")) {
                ApplicationAttemptStateData attemptState = this.createAttemptState(attemptId, entry.getValue());
                appState.attempts.put(attemptState.getAttemptId(), attemptState);
            } else {
                LOG.warn((Object)("Ignoring unknown application key: " + key));
            }
            iter.next();
        }
        int numAttempts = appState.attempts.size();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loaded application " + appId + " with " + numAttempts + " attempts"));
        }
        return numAttempts;
    }

    private ApplicationStateData createApplicationState(String appIdStr, byte[] data) throws IOException {
        ApplicationStateDataPBImpl appState;
        ApplicationId appId = ApplicationId.fromString((String)appIdStr);
        if (!appId.equals((Object)(appState = new ApplicationStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationStateDataProto.parseFrom(data))).getApplicationSubmissionContext().getApplicationId())) {
            throw new YarnRuntimeException("The database entry for " + appId + " contains data for " + appState.getApplicationSubmissionContext().getApplicationId());
        }
        return appState;
    }

    @VisibleForTesting
    ApplicationStateData loadRMAppState(ApplicationId appId) throws IOException {
        String appKey = this.getApplicationNodeKey(appId);
        byte[] data = null;
        try {
            data = this.db.get(JniDBFactory.bytes((String)appKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        if (data == null) {
            return null;
        }
        return this.createApplicationState(appId.toString(), data);
    }

    @VisibleForTesting
    ApplicationAttemptStateData loadRMAppAttemptState(ApplicationAttemptId attemptId) throws IOException {
        String attemptKey = this.getApplicationAttemptNodeKey(attemptId);
        byte[] data = null;
        try {
            data = this.db.get(JniDBFactory.bytes((String)attemptKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        if (data == null) {
            return null;
        }
        return this.createAttemptState(attemptId.toString(), data);
    }

    private ApplicationAttemptStateData createAttemptState(String itemName, byte[] data) throws IOException {
        ApplicationAttemptStateDataPBImpl attemptState;
        ApplicationAttemptId attemptId = ApplicationAttemptId.fromString((String)itemName);
        if (!attemptId.equals((Object)(attemptState = new ApplicationAttemptStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto.parseFrom(data))).getAttemptId())) {
            throw new YarnRuntimeException("The database entry for " + attemptId + " contains data for " + attemptState.getAttemptId());
        }
        return attemptState;
    }

    private void loadAMRMTokenSecretManagerState(RMStateStore.RMState rmState) throws IOException {
        try {
            byte[] data = this.db.get(JniDBFactory.bytes((String)"AMRMTokenSecretManagerRoot"));
            if (data != null) {
                AMRMTokenSecretManagerStatePBImpl stateData = new AMRMTokenSecretManagerStatePBImpl(YarnServerResourceManagerRecoveryProtos.AMRMTokenSecretManagerStateProto.parseFrom(data));
                rmState.amrmTokenSecretManagerState = AMRMTokenSecretManagerState.newInstance(stateData.getCurrentMasterKey(), stateData.getNextMasterKey());
            }
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void storeApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateData) throws IOException {
        String key = this.getApplicationNodeKey(appId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing state for app " + appId + " at " + key));
        }
        try {
            this.db.put(JniDBFactory.bytes((String)key), appStateData.getProto().toByteArray());
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateData) throws IOException {
        this.storeApplicationStateInternal(appId, appStateData);
    }

    @Override
    protected void storeApplicationAttemptStateInternal(ApplicationAttemptId attemptId, ApplicationAttemptStateData attemptStateData) throws IOException {
        String key = this.getApplicationAttemptNodeKey(attemptId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing state for attempt " + attemptId + " at " + key));
        }
        try {
            this.db.put(JniDBFactory.bytes((String)key), attemptStateData.getProto().toByteArray());
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void updateApplicationAttemptStateInternal(ApplicationAttemptId attemptId, ApplicationAttemptStateData attemptStateData) throws IOException {
        this.storeApplicationAttemptStateInternal(attemptId, attemptStateData);
    }

    @Override
    public synchronized void removeApplicationAttemptInternal(ApplicationAttemptId attemptId) throws IOException {
        String attemptKey = this.getApplicationAttemptNodeKey(attemptId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing state for attempt " + attemptId + " at " + attemptKey));
        }
        try {
            this.db.delete(JniDBFactory.bytes((String)attemptKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeApplicationStateInternal(ApplicationStateData appState) throws IOException {
        ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
        String appKey = this.getApplicationNodeKey(appId);
        try (WriteBatch batch = this.db.createWriteBatch();){
            batch.delete(JniDBFactory.bytes((String)appKey));
            for (ApplicationAttemptId attemptId : appState.attempts.keySet()) {
                String attemptKey = this.getApplicationAttemptNodeKey(appKey, attemptId);
                batch.delete(JniDBFactory.bytes((String)attemptKey));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing state for app " + appId + " and " + appState.attempts.size() + " attempts" + " at " + appKey));
            }
            this.db.write(batch);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void storeReservationState(YarnProtos.ReservationAllocationStateProto reservationAllocation, String planName, String reservationIdName) throws Exception {
        try (WriteBatch batch = this.db.createWriteBatch();){
            String key = this.getReservationNodeKey(planName, reservationIdName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Storing state for reservation " + reservationIdName + " plan " + planName + " at " + key));
            }
            batch.put(JniDBFactory.bytes((String)key), reservationAllocation.toByteArray());
            this.db.write(batch);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeReservationState(String planName, String reservationIdName) throws Exception {
        try (WriteBatch batch = this.db.createWriteBatch();){
            String reservationKey = this.getReservationNodeKey(planName, reservationIdName);
            batch.delete(JniDBFactory.bytes((String)reservationKey));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing state for reservation " + reservationIdName + " plan " + planName + " at " + reservationKey));
            }
            this.db.write(batch);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeOrUpdateRMDT(RMDelegationTokenIdentifier tokenId, Long renewDate, boolean isUpdate) throws IOException {
        String tokenKey = this.getRMDTTokenNodeKey(tokenId);
        RMDelegationTokenIdentifierData tokenData = new RMDelegationTokenIdentifierData((YARNDelegationTokenIdentifier)tokenId, renewDate);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing token to " + tokenKey));
        }
        try (WriteBatch batch = this.db.createWriteBatch();){
            batch.put(JniDBFactory.bytes((String)tokenKey), tokenData.toByteArray());
            if (!isUpdate) {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                try (DataOutputStream ds = new DataOutputStream(bs);){
                    ds.writeInt(tokenId.getSequenceNumber());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Storing " + tokenId.getSequenceNumber() + " to " + RM_DT_SEQUENCE_NUMBER_KEY));
                }
                batch.put(JniDBFactory.bytes((String)RM_DT_SEQUENCE_NUMBER_KEY), bs.toByteArray());
            }
            this.db.write(batch);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void storeRMDelegationTokenState(RMDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        this.storeOrUpdateRMDT(tokenId, renewDate, false);
    }

    @Override
    protected void updateRMDelegationTokenState(RMDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        this.storeOrUpdateRMDT(tokenId, renewDate, true);
    }

    @Override
    protected void removeRMDelegationTokenState(RMDelegationTokenIdentifier tokenId) throws IOException {
        String tokenKey = this.getRMDTTokenNodeKey(tokenId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing token at " + tokenKey));
        }
        try {
            this.db.delete(JniDBFactory.bytes((String)tokenKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void storeRMDTMasterKeyState(DelegationKey masterKey) throws IOException {
        String dbKey = this.getRMDTMasterKeyNodeKey(masterKey);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing token master key to " + dbKey));
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(os);){
            masterKey.write((DataOutput)out);
        }
        try {
            this.db.put(JniDBFactory.bytes((String)dbKey), os.toByteArray());
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void removeRMDTMasterKeyState(DelegationKey masterKey) throws IOException {
        String dbKey = this.getRMDTMasterKeyNodeKey(masterKey);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing token master key at " + dbKey));
        }
        try {
            this.db.delete(JniDBFactory.bytes((String)dbKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void storeOrUpdateAMRMTokenSecretManagerState(AMRMTokenSecretManagerState state, boolean isUpdate) {
        AMRMTokenSecretManagerState data = AMRMTokenSecretManagerState.newInstance(state);
        byte[] stateData = data.getProto().toByteArray();
        this.db.put(JniDBFactory.bytes((String)"AMRMTokenSecretManagerRoot"), stateData);
    }

    @Override
    public void deleteStore() throws IOException {
        Path root = this.getStorageDir();
        LOG.info((Object)("Deleting state database at " + root));
        this.db.close();
        this.db = null;
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.getConfig());
        fs.delete(root, true);
    }

    @Override
    public synchronized void removeApplication(ApplicationId removeAppId) throws IOException {
        String appKey = this.getApplicationNodeKey(removeAppId);
        LOG.info((Object)("Removing state for app " + removeAppId));
        try {
            this.db.delete(JniDBFactory.bytes((String)appKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    int getNumEntriesInDatabase() throws IOException {
        int numEntries = 0;
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seekToFirst();
            while (iter.hasNext()) {
                Object entry = iter.next();
                LOG.info((Object)("entry: " + JniDBFactory.asString((byte[])((byte[])entry.getKey()))));
                ++numEntries;
            }
        }
        return numEntries;
    }

    private class CompactionTimerTask
    extends TimerTask {
        private CompactionTimerTask() {
        }

        @Override
        public void run() {
            long start = Time.monotonicNow();
            LOG.info((Object)"Starting full compaction cycle");
            try {
                LeveldbRMStateStore.this.db.compactRange(null, null);
            }
            catch (DBException e) {
                LOG.error((Object)"Error compacting database", (Throwable)e);
            }
            long duration = Time.monotonicNow() - start;
            LOG.info((Object)("Full compaction cycle completed in " + duration + " msec"));
        }
    }
}

