/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.hadoop.shaded.org.apache.commons.lang.math.LongRange;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceProfilesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceProfilesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetResourceProfileRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetResourceProfileResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.ReservationACL;
import org.apache.hadoop.yarn.api.records.ReservationAllocationState;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.ContainerNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInputValidator;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceProfilesManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppKillByClientEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeSignalContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ReservationsACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.authorize.RMPolicyProvider;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.UTCClock;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;

public class ClientRMService
extends AbstractService
implements ApplicationClientProtocol {
    private static final ArrayList<ApplicationReport> EMPTY_APPS_REPORT = new ArrayList();
    private static final Log LOG = LogFactory.getLog(ClientRMService.class);
    private final AtomicInteger applicationCounter = new AtomicInteger(0);
    private final YarnScheduler scheduler;
    private final RMContext rmContext;
    private final RMAppManager rmAppManager;
    private Server server;
    protected RMDelegationTokenSecretManager rmDTSecretManager;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private InetSocketAddress clientBindAddress;
    private final ApplicationACLsManager applicationsACLsManager;
    private final QueueACLsManager queueACLsManager;
    private Clock clock;
    private ReservationSystem reservationSystem;
    private ReservationInputValidator rValidator;
    private boolean filterAppsByUser = false;
    private static final EnumSet<RMAppState> ACTIVE_APP_STATES = EnumSet.of(RMAppState.ACCEPTED, RMAppState.RUNNING);
    private ResourceProfilesManager resourceProfilesManager;

    public ClientRMService(RMContext rmContext, YarnScheduler scheduler, RMAppManager rmAppManager, ApplicationACLsManager applicationACLsManager, QueueACLsManager queueACLsManager, RMDelegationTokenSecretManager rmDTSecretManager) {
        this(rmContext, scheduler, rmAppManager, applicationACLsManager, queueACLsManager, rmDTSecretManager, (Clock)new UTCClock());
    }

    public ClientRMService(RMContext rmContext, YarnScheduler scheduler, RMAppManager rmAppManager, ApplicationACLsManager applicationACLsManager, QueueACLsManager queueACLsManager, RMDelegationTokenSecretManager rmDTSecretManager, Clock clock) {
        super(ClientRMService.class.getName());
        this.scheduler = scheduler;
        this.rmContext = rmContext;
        this.rmAppManager = rmAppManager;
        this.applicationsACLsManager = applicationACLsManager;
        this.queueACLsManager = queueACLsManager;
        this.rmDTSecretManager = rmDTSecretManager;
        this.reservationSystem = rmContext.getReservationSystem();
        this.clock = clock;
        this.rValidator = new ReservationInputValidator(clock);
        this.resourceProfilesManager = rmContext.getResourceProfilesManager();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.clientBindAddress = this.getBindAddress(conf);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = rpc.getServer(ApplicationClientProtocol.class, (Object)this, this.clientBindAddress, conf, (SecretManager)this.rmDTSecretManager, conf.getInt("yarn.resourcemanager.client.thread-count", 50));
        this.server.addTerseExceptions(new Class[]{ApplicationNotFoundException.class, ApplicationAttemptNotFoundException.class, ContainerNotFoundException.class});
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            InputStream inputStream = this.rmContext.getConfigurationProvider().getConfigurationInputStream(conf, "hadoop-policy.xml");
            if (inputStream != null) {
                conf.addResource(inputStream);
            }
            this.refreshServiceAcls(conf, RMPolicyProvider.getInstance());
        }
        this.filterAppsByUser = conf.getBoolean("yarn.webapp.filter-entity-list-by-user", false);
        this.server.start();
        this.clientBindAddress = conf.updateConnectAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.address", "0.0.0.0:8032", this.server.getListenerAddress());
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    InetSocketAddress getBindAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    @InterfaceAudience.Private
    public InetSocketAddress getBindAddress() {
        return this.clientBindAddress;
    }

    private boolean checkAccess(UserGroupInformation callerUGI, String owner, ApplicationAccessType operationPerformed, RMApp application) {
        return this.applicationsACLsManager.checkAccess(callerUGI, operationPerformed, owner, application.getApplicationId()) || this.queueACLsManager.checkAccess(callerUGI, QueueACL.ADMINISTER_QUEUE, application, Server.getRemoteAddress(), null);
    }

    ApplicationId getNewApplicationId() {
        ApplicationId applicationId = BuilderUtils.newApplicationId(this.recordFactory, ResourceManager.getClusterTimeStamp(), this.applicationCounter.incrementAndGet());
        LOG.info((Object)("Allocated new applicationId: " + applicationId.getId()));
        return applicationId;
    }

    public GetNewApplicationResponse getNewApplication(GetNewApplicationRequest request) throws YarnException {
        GetNewApplicationResponse response = (GetNewApplicationResponse)this.recordFactory.newRecordInstance(GetNewApplicationResponse.class);
        response.setApplicationId(this.getNewApplicationId());
        response.setMaximumResourceCapability(this.scheduler.getMaximumResourceCapability());
        return response;
    }

    public GetApplicationReportResponse getApplicationReport(GetApplicationReportRequest request) throws YarnException {
        UserGroupInformation callerUGI;
        ApplicationId applicationId = request.getApplicationId();
        if (applicationId == null) {
            throw new ApplicationNotFoundException("Invalid application id: null");
        }
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(applicationId);
        if (application == null) {
            throw new ApplicationNotFoundException("Application with id '" + applicationId + "' doesn't exist in RM. Please check " + "that the job submission was successful.");
        }
        boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
        ApplicationReport report = application.createAndGetApplicationReport(callerUGI.getUserName(), allowAccess);
        GetApplicationReportResponse response = (GetApplicationReportResponse)this.recordFactory.newRecordInstance(GetApplicationReportResponse.class);
        response.setApplicationReport(report);
        return response;
    }

    public GetApplicationAttemptReportResponse getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        RMAppAttempt appAttempt;
        ApplicationId applicationId = request.getApplicationAttemptId().getApplicationId();
        ApplicationAttemptId appAttemptId = request.getApplicationAttemptId();
        UserGroupInformation callerUGI = this.getCallerUgi(applicationId, "Get Application Attempt Report");
        RMApp application = this.verifyUserAccessForRMApp(applicationId, callerUGI, "Get Application Attempt Report", ApplicationAccessType.VIEW_APP, false);
        boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
        GetApplicationAttemptReportResponse response = null;
        if (allowAccess) {
            appAttempt = application.getAppAttempts().get(appAttemptId);
            if (appAttempt == null) {
                throw new ApplicationAttemptNotFoundException("ApplicationAttempt with id '" + appAttemptId + "' doesn't exist in RM.");
            }
        } else {
            throw new YarnException("User " + callerUGI.getShortUserName() + " does not have privilege to see this attempt " + appAttemptId);
        }
        ApplicationAttemptReport attemptReport = appAttempt.createApplicationAttemptReport();
        response = GetApplicationAttemptReportResponse.newInstance((ApplicationAttemptReport)attemptReport);
        return response;
    }

    public GetApplicationAttemptsResponse getApplicationAttempts(GetApplicationAttemptsRequest request) throws YarnException, IOException {
        ArrayList<ApplicationAttemptReport> listAttempts;
        ApplicationId appId = request.getApplicationId();
        UserGroupInformation callerUGI = this.getCallerUgi(appId, "Get Application Attempts");
        RMApp application = this.verifyUserAccessForRMApp(appId, callerUGI, "Get Application Attempts", ApplicationAccessType.VIEW_APP, false);
        boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
        GetApplicationAttemptsResponse response = null;
        if (allowAccess) {
            Map<ApplicationAttemptId, RMAppAttempt> attempts = application.getAppAttempts();
            listAttempts = new ArrayList<ApplicationAttemptReport>();
            Iterator<Map.Entry<ApplicationAttemptId, RMAppAttempt>> iter = attempts.entrySet().iterator();
            while (iter.hasNext()) {
                listAttempts.add(iter.next().getValue().createApplicationAttemptReport());
            }
        } else {
            throw new YarnException("User " + callerUGI.getShortUserName() + " does not have privilege to see this application " + appId);
        }
        response = GetApplicationAttemptsResponse.newInstance(listAttempts);
        return response;
    }

    public GetContainerReportResponse getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
        RMContainer rmContainer;
        ContainerId containerId = request.getContainerId();
        ApplicationAttemptId appAttemptId = containerId.getApplicationAttemptId();
        ApplicationId appId = appAttemptId.getApplicationId();
        UserGroupInformation callerUGI = this.getCallerUgi(appId, "Get Container Report");
        RMApp application = this.verifyUserAccessForRMApp(appId, callerUGI, "Get Container Report", ApplicationAccessType.VIEW_APP, false);
        boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
        GetContainerReportResponse response = null;
        if (allowAccess) {
            RMAppAttempt appAttempt = application.getAppAttempts().get(appAttemptId);
            if (appAttempt == null) {
                throw new ApplicationAttemptNotFoundException("ApplicationAttempt with id '" + appAttemptId + "' doesn't exist in RM.");
            }
            rmContainer = this.rmContext.getScheduler().getRMContainer(containerId);
            if (rmContainer == null) {
                throw new ContainerNotFoundException("Container with id '" + containerId + "' doesn't exist in RM.");
            }
        } else {
            throw new YarnException("User " + callerUGI.getShortUserName() + " does not have privilege to see this application " + appId);
        }
        response = GetContainerReportResponse.newInstance((ContainerReport)rmContainer.createContainerReport());
        return response;
    }

    public GetContainersResponse getContainers(GetContainersRequest request) throws YarnException, IOException {
        ArrayList<ContainerReport> listContainers;
        ApplicationAttemptId appAttemptId = request.getApplicationAttemptId();
        ApplicationId appId = appAttemptId.getApplicationId();
        UserGroupInformation callerUGI = this.getCallerUgi(appId, "Get Containers");
        RMApp application = this.verifyUserAccessForRMApp(appId, callerUGI, "Get Containers", ApplicationAccessType.VIEW_APP, false);
        boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
        GetContainersResponse response = null;
        if (allowAccess) {
            RMAppAttempt appAttempt = application.getAppAttempts().get(appAttemptId);
            if (appAttempt == null) {
                throw new ApplicationAttemptNotFoundException("ApplicationAttempt with id '" + appAttemptId + "' doesn't exist in RM.");
            }
            Collection<Object> rmContainers = Collections.emptyList();
            SchedulerAppReport schedulerAppReport = this.rmContext.getScheduler().getSchedulerAppInfo(appAttemptId);
            if (schedulerAppReport != null) {
                rmContainers = schedulerAppReport.getLiveContainers();
            }
            listContainers = new ArrayList<ContainerReport>();
            for (RMContainer rMContainer : rmContainers) {
                listContainers.add(rMContainer.createContainerReport());
            }
        } else {
            throw new YarnException("User " + callerUGI.getShortUserName() + " does not have privilege to see this application " + appId);
        }
        response = GetContainersResponse.newInstance(listContainers);
        return response;
    }

    public SubmitApplicationResponse submitApplication(SubmitApplicationRequest request) throws YarnException, IOException {
        ApplicationSubmissionContext submissionContext = request.getApplicationSubmissionContext();
        ApplicationId applicationId = submissionContext.getApplicationId();
        CallerContext callerContext = CallerContext.getCurrent();
        String user = null;
        try {
            user = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException ie) {
            LOG.warn((Object)"Unable to get the current user.", (Throwable)ie);
            RMAuditLogger.logFailure(user, "Submit Application Request", ie.getMessage(), "ClientRMService", "Exception in submitting application", applicationId, callerContext);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        if (YarnConfiguration.timelineServiceV2Enabled((Configuration)this.getConfig())) {
            String value = null;
            try {
                for (String tag : submissionContext.getApplicationTags()) {
                    if (!tag.startsWith("TIMELINE_FLOW_RUN_ID_TAG:") && !tag.startsWith("TIMELINE_FLOW_RUN_ID_TAG".toLowerCase() + ":")) continue;
                    value = tag.substring("TIMELINE_FLOW_RUN_ID_TAG".length() + 1);
                    Long.valueOf(value);
                }
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Invalid to flow run: " + value + ". Flow run should be a long integer"), (Throwable)e);
                RMAuditLogger.logFailure(user, "Submit Application Request", e.getMessage(), "ClientRMService", "Exception in submitting application", applicationId);
                throw RPCUtil.getRemoteException((Throwable)e);
            }
        }
        if (this.rmContext.getRMApps().get(applicationId) != null) {
            LOG.info((Object)("This is an earlier submitted application: " + applicationId));
            return SubmitApplicationResponse.newInstance();
        }
        ByteBuffer tokenConf = submissionContext.getAMContainerSpec().getTokensConf();
        if (tokenConf != null) {
            int maxSize = this.getConfig().getInt("yarn.resourcemanager.delegation-token.max-conf-size-bytes", 12800);
            LOG.info((Object)("Using app provided configurations for delegation token renewal, total size = " + tokenConf.capacity()));
            if (tokenConf.capacity() > maxSize) {
                throw new YarnException("Exceed yarn.resourcemanager.delegation-token.max-conf-size-bytes = " + maxSize + " bytes, current conf size = " + tokenConf.capacity() + " bytes.");
            }
        }
        if (submissionContext.getQueue() == null) {
            submissionContext.setQueue("default");
        }
        if (submissionContext.getApplicationName() == null) {
            submissionContext.setApplicationName("N/A");
        }
        if (submissionContext.getApplicationType() == null) {
            submissionContext.setApplicationType("YARN");
        } else if (submissionContext.getApplicationType().length() > 20) {
            submissionContext.setApplicationType(submissionContext.getApplicationType().substring(0, 20));
        }
        ReservationId reservationId = request.getApplicationSubmissionContext().getReservationID();
        this.checkReservationACLs(submissionContext.getQueue(), "Submit Reservation Request", reservationId);
        try {
            this.rmAppManager.submitApplication(submissionContext, System.currentTimeMillis(), user);
            LOG.info((Object)("Application with id " + applicationId.getId() + " submitted by user " + user));
            RMAuditLogger.logSuccess(user, "Submit Application Request", "ClientRMService", applicationId, callerContext);
        }
        catch (YarnException e) {
            LOG.info((Object)("Exception in submitting " + applicationId), (Throwable)e);
            RMAuditLogger.logFailure(user, "Submit Application Request", e.getMessage(), "ClientRMService", "Exception in submitting application", applicationId, callerContext);
            throw e;
        }
        return (SubmitApplicationResponse)this.recordFactory.newRecordInstance(SubmitApplicationResponse.class);
    }

    public FailApplicationAttemptResponse failApplicationAttempt(FailApplicationAttemptRequest request) throws YarnException {
        UserGroupInformation callerUGI;
        ApplicationAttemptId attemptId = request.getApplicationAttemptId();
        ApplicationId applicationId = attemptId.getApplicationId();
        RMApp application = this.verifyUserAccessForRMApp(applicationId, callerUGI = this.getCallerUgi(applicationId, "Fail Attempt Request"), "Fail Attempt Request", ApplicationAccessType.MODIFY_APP, true);
        RMAppAttempt appAttempt = application.getAppAttempts().get(attemptId);
        if (appAttempt == null) {
            throw new ApplicationAttemptNotFoundException("ApplicationAttempt with id '" + attemptId + "' doesn't exist in RM.");
        }
        FailApplicationAttemptResponse response = (FailApplicationAttemptResponse)this.recordFactory.newRecordInstance(FailApplicationAttemptResponse.class);
        if (application.isAppInCompletedStates()) {
            RMAuditLogger.logSuccess(callerUGI.getShortUserName(), "Fail Attempt Request", "ClientRMService", applicationId);
            return response;
        }
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(attemptId, RMAppAttemptEventType.FAIL, "Attempt failed by user."));
        RMAuditLogger.logSuccess(callerUGI.getShortUserName(), "Fail Attempt Request", "ClientRMService", applicationId, attemptId);
        return response;
    }

    public KillApplicationResponse forceKillApplication(KillApplicationRequest request) throws YarnException {
        String diagnostics;
        UserGroupInformation callerUGI;
        ApplicationId applicationId = request.getApplicationId();
        CallerContext callerContext = CallerContext.getCurrent();
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            RMAuditLogger.logFailure("UNKNOWN", "Kill Application Request", "UNKNOWN", "ClientRMService", "Error getting UGI", applicationId, callerContext);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(applicationId);
        if (application == null) {
            RMAuditLogger.logFailure(callerUGI.getUserName(), "Kill Application Request", "UNKNOWN", "ClientRMService", "Trying to kill an absent application", applicationId, callerContext);
            throw new ApplicationNotFoundException("Trying to kill an absent application " + applicationId);
        }
        if (!this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.MODIFY_APP, application)) {
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Kill Application Request", "User doesn't have permissions to " + ApplicationAccessType.MODIFY_APP.toString(), "ClientRMService", "Unauthorized user", applicationId, callerContext);
            throw RPCUtil.getRemoteException((Throwable)new AccessControlException("User " + callerUGI.getShortUserName() + " cannot perform operation " + ApplicationAccessType.MODIFY_APP.name() + " on " + applicationId));
        }
        if (application.isAppFinalStateStored()) {
            return KillApplicationResponse.newInstance((boolean)true);
        }
        StringBuilder message = new StringBuilder();
        message.append("Application ").append(applicationId).append(" was killed by user ").append(callerUGI.getShortUserName());
        InetAddress remoteAddress = Server.getRemoteIp();
        if (null != remoteAddress) {
            message.append(" at ").append(remoteAddress.getHostAddress());
        }
        if ((diagnostics = org.apache.hadoop.shaded.org.apache.commons.lang.StringUtils.trimToNull((String)request.getDiagnostics())) != null) {
            message.append(" with diagnostic message: ");
            message.append(diagnostics);
        }
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppKillByClientEvent(applicationId, message.toString(), callerUGI, remoteAddress));
        return KillApplicationResponse.newInstance((boolean)application.getApplicationSubmissionContext().getUnmanagedAM());
    }

    public GetClusterMetricsResponse getClusterMetrics(GetClusterMetricsRequest request) throws YarnException {
        GetClusterMetricsResponse response = (GetClusterMetricsResponse)this.recordFactory.newRecordInstance(GetClusterMetricsResponse.class);
        YarnClusterMetrics ymetrics = (YarnClusterMetrics)this.recordFactory.newRecordInstance(YarnClusterMetrics.class);
        ymetrics.setNumNodeManagers(this.rmContext.getRMNodes().size());
        ClusterMetrics clusterMetrics = ClusterMetrics.getMetrics();
        ymetrics.setNumDecommissionedNodeManagers(clusterMetrics.getNumDecommisionedNMs());
        ymetrics.setNumActiveNodeManagers(clusterMetrics.getNumActiveNMs());
        ymetrics.setNumLostNodeManagers(clusterMetrics.getNumLostNMs());
        ymetrics.setNumUnhealthyNodeManagers(clusterMetrics.getUnhealthyNMs());
        ymetrics.setNumRebootedNodeManagers(clusterMetrics.getNumRebootedNMs());
        response.setClusterMetrics(ymetrics);
        return response;
    }

    public GetApplicationsResponse getApplications(GetApplicationsRequest request) throws YarnException {
        Iterator<RMApp> appsIter;
        UserGroupInformation callerUGI;
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        Set<String> applicationTypes = this.getLowerCasedAppTypes(request);
        EnumSet applicationStates = request.getApplicationStates();
        Set users = request.getUsers();
        Set queues = request.getQueues();
        Set tags = request.getApplicationTags();
        long limit = request.getLimit();
        LongRange start = request.getStartRange();
        LongRange finish = request.getFinishRange();
        ApplicationsRequestScope scope = request.getScope();
        final ConcurrentMap<ApplicationId, RMApp> apps = this.rmContext.getRMApps();
        if (queues != null && !queues.isEmpty()) {
            final ArrayList<List<ApplicationAttemptId>> queueAppLists = new ArrayList<List<ApplicationAttemptId>>();
            for (String queue : queues) {
                List<ApplicationAttemptId> appsInQueue = this.scheduler.getAppsInQueue(queue);
                if (appsInQueue == null || appsInQueue.isEmpty()) continue;
                queueAppLists.add(appsInQueue);
            }
            appsIter = new Iterator<RMApp>(){
                Iterator<List<ApplicationAttemptId>> appListIter;
                Iterator<ApplicationAttemptId> schedAppsIter;
                {
                    this.appListIter = queueAppLists.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.schedAppsIter != null && this.schedAppsIter.hasNext() || this.appListIter.hasNext();
                }

                @Override
                public RMApp next() {
                    if (this.schedAppsIter == null || !this.schedAppsIter.hasNext()) {
                        this.schedAppsIter = this.appListIter.next().iterator();
                    }
                    return (RMApp)apps.get(this.schedAppsIter.next().getApplicationId());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Remove not supported");
                }
            };
        } else {
            appsIter = apps.values().iterator();
        }
        ArrayList<ApplicationReport> reports = new ArrayList<ApplicationReport>();
        while (appsIter.hasNext() && (long)reports.size() < limit) {
            String appTypeToMatch;
            RMApp application = (RMApp)appsIter.next();
            if (scope == ApplicationsRequestScope.OWN && !callerUGI.getUserName().equals(application.getUser()) || applicationTypes != null && !applicationTypes.isEmpty() && !applicationTypes.contains(appTypeToMatch = StringUtils.toLowerCase((String)application.getApplicationType())) || applicationStates != null && !applicationStates.isEmpty() && !applicationStates.contains(application.createApplicationState()) || users != null && !users.isEmpty() && !users.contains(application.getUser()) || start != null && !start.containsLong(application.getStartTime()) || finish != null && !finish.containsLong(application.getFinishTime())) continue;
            if (tags != null && !tags.isEmpty()) {
                Set<String> appTags = application.getApplicationTags();
                if (appTags == null || appTags.isEmpty()) continue;
                boolean match = false;
                for (String tag : tags) {
                    if (!appTags.contains(tag)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
            }
            boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
            if (scope == ApplicationsRequestScope.VIEWABLE && !allowAccess || this.filterAppsByUser && !allowAccess) continue;
            reports.add(application.createAndGetApplicationReport(callerUGI.getUserName(), allowAccess));
        }
        RMAuditLogger.logSuccess(callerUGI.getUserName(), "Get Applications Request", "ClientRMService");
        GetApplicationsResponse response = (GetApplicationsResponse)this.recordFactory.newRecordInstance(GetApplicationsResponse.class);
        response.setApplicationList(reports);
        return response;
    }

    private Set<String> getLowerCasedAppTypes(GetApplicationsRequest request) {
        HashSet<String> applicationTypes = new HashSet<String>();
        if (request.getApplicationTypes() != null && !request.getApplicationTypes().isEmpty()) {
            for (String type : request.getApplicationTypes()) {
                applicationTypes.add(StringUtils.toLowerCase((String)type));
            }
        }
        return applicationTypes;
    }

    public GetClusterNodesResponse getClusterNodes(GetClusterNodesRequest request) throws YarnException {
        GetClusterNodesResponse response = (GetClusterNodesResponse)this.recordFactory.newRecordInstance(GetClusterNodesResponse.class);
        EnumSet<NodeState> nodeStates = request.getNodeStates();
        if (nodeStates == null || nodeStates.isEmpty()) {
            nodeStates = EnumSet.allOf(NodeState.class);
        }
        List<RMNode> nodes = RMServerUtils.queryRMNodes(this.rmContext, nodeStates);
        ArrayList<NodeReport> nodeReports = new ArrayList<NodeReport>(nodes.size());
        for (RMNode nodeInfo : nodes) {
            nodeReports.add(this.createNodeReports(nodeInfo));
        }
        response.setNodeReports(nodeReports);
        return response;
    }

    public GetQueueInfoResponse getQueueInfo(GetQueueInfoRequest request) throws YarnException {
        UserGroupInformation callerUGI;
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        GetQueueInfoResponse response = (GetQueueInfoResponse)this.recordFactory.newRecordInstance(GetQueueInfoResponse.class);
        RMAuditLogger.ArgsBuilder arguments = new RMAuditLogger.ArgsBuilder().append(RMAuditLogger.Keys.QUEUENAME, request.getQueueName()).append(RMAuditLogger.Keys.INCLUDEAPPS, String.valueOf(request.getIncludeApplications())).append(RMAuditLogger.Keys.INCLUDECHILDQUEUES, String.valueOf(request.getIncludeChildQueues())).append(RMAuditLogger.Keys.RECURSIVE, String.valueOf(request.getRecursive()));
        try {
            QueueInfo queueInfo = this.scheduler.getQueueInfo(request.getQueueName(), request.getIncludeChildQueues(), request.getRecursive());
            ArrayList<Object> appReports = EMPTY_APPS_REPORT;
            if (request.getIncludeApplications()) {
                List<ApplicationAttemptId> apps = this.scheduler.getAppsInQueue(request.getQueueName());
                appReports = new ArrayList(apps.size());
                for (ApplicationAttemptId app : apps) {
                    RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(app.getApplicationId());
                    if (rmApp == null || !this.checkAccess(callerUGI, rmApp.getUser(), ApplicationAccessType.VIEW_APP, rmApp)) continue;
                    appReports.add(rmApp.createAndGetApplicationReport(callerUGI.getUserName(), true));
                }
            }
            queueInfo.setApplications(appReports);
            response.setQueueInfo(queueInfo);
            RMAuditLogger.logSuccess(callerUGI.getUserName(), "Get Queue Info Request", "ClientRMService", arguments);
        }
        catch (IOException ioe) {
            LOG.info((Object)("Failed to getQueueInfo for " + request.getQueueName()), (Throwable)ioe);
            RMAuditLogger.logFailure(callerUGI.getUserName(), "Get Queue Info Request", "UNKNOWN", "ClientRMService", ioe.getMessage(), arguments);
        }
        return response;
    }

    private NodeReport createNodeReports(RMNode rmNode) {
        SchedulerNodeReport schedulerNodeReport = this.scheduler.getNodeReport(rmNode.getNodeID());
        Resource used = BuilderUtils.newResource(0L, 0);
        int numContainers = 0;
        if (schedulerNodeReport != null) {
            used = schedulerNodeReport.getUsedResource();
            numContainers = schedulerNodeReport.getNumContainers();
        }
        NodeReport report = BuilderUtils.newNodeReport(rmNode.getNodeID(), rmNode.getState(), rmNode.getHttpAddress(), rmNode.getRackName(), used, rmNode.getTotalCapability(), numContainers, rmNode.getHealthReport(), rmNode.getLastHealthReportTime(), rmNode.getNodeLabels(), rmNode.getAggregatedContainersUtilization(), rmNode.getNodeUtilization(), rmNode.getDecommissioningTimeout(), null);
        return report;
    }

    public GetQueueUserAclsInfoResponse getQueueUserAcls(GetQueueUserAclsInfoRequest request) throws YarnException {
        GetQueueUserAclsInfoResponse response = (GetQueueUserAclsInfoResponse)this.recordFactory.newRecordInstance(GetQueueUserAclsInfoResponse.class);
        response.setUserAclsInfoList(this.scheduler.getQueueUserAclInfo());
        return response;
    }

    public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws YarnException {
        try {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be issued only with kerberos authentication");
            }
            GetDelegationTokenResponse response = (GetDelegationTokenResponse)this.recordFactory.newRecordInstance(GetDelegationTokenResponse.class);
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            Text owner = new Text(ugi.getUserName());
            Text realUser = null;
            if (ugi.getRealUser() != null) {
                realUser = new Text(ugi.getRealUser().getUserName());
            }
            RMDelegationTokenIdentifier tokenIdentifier = new RMDelegationTokenIdentifier(owner, new Text(request.getRenewer()), realUser);
            Token realRMDToken = new Token((TokenIdentifier)tokenIdentifier, (SecretManager)this.rmDTSecretManager);
            response.setRMDelegationToken(BuilderUtils.newDelegationToken(realRMDToken.getIdentifier(), realRMDToken.getKind().toString(), realRMDToken.getPassword(), realRMDToken.getService().toString()));
            return response;
        }
        catch (IOException io) {
            throw RPCUtil.getRemoteException((Throwable)io);
        }
    }

    public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws YarnException {
        try {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be renewed only with kerberos authentication");
            }
            org.apache.hadoop.yarn.api.records.Token protoToken = request.getDelegationToken();
            Token token = new Token(protoToken.getIdentifier().array(), protoToken.getPassword().array(), new Text(protoToken.getKind()), new Text(protoToken.getService()));
            String user = this.getRenewerForToken((Token<RMDelegationTokenIdentifier>)token);
            long nextExpTime = this.rmDTSecretManager.renewToken(token, user);
            RenewDelegationTokenResponse renewResponse = (RenewDelegationTokenResponse)Records.newRecord(RenewDelegationTokenResponse.class);
            renewResponse.setNextExpirationTime(nextExpTime);
            return renewResponse;
        }
        catch (IOException e) {
            throw RPCUtil.getRemoteException((Throwable)e);
        }
    }

    public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws YarnException {
        try {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be cancelled only with kerberos authentication");
            }
            org.apache.hadoop.yarn.api.records.Token protoToken = request.getDelegationToken();
            Token token = new Token(protoToken.getIdentifier().array(), protoToken.getPassword().array(), new Text(protoToken.getKind()), new Text(protoToken.getService()));
            String user = UserGroupInformation.getCurrentUser().getUserName();
            this.rmDTSecretManager.cancelToken(token, user);
            return (CancelDelegationTokenResponse)Records.newRecord(CancelDelegationTokenResponse.class);
        }
        catch (IOException e) {
            throw RPCUtil.getRemoteException((Throwable)e);
        }
    }

    public MoveApplicationAcrossQueuesResponse moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest request) throws YarnException {
        String targetQueue;
        RMApp application;
        ApplicationId applicationId = request.getApplicationId();
        UserGroupInformation callerUGI = this.getCallerUgi(applicationId, "Move Application Request");
        if (!this.accessToTargetQueueAllowed(callerUGI, application = this.verifyUserAccessForRMApp(applicationId, callerUGI, "Move Application Request", ApplicationAccessType.MODIFY_APP, true), targetQueue = request.getTargetQueue())) {
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Move Application Request", "Target queue doesn't exist or user doesn't have permissions to submit to target queue: " + targetQueue, "ClientRMService", "Unauthorized user", applicationId);
            throw RPCUtil.getRemoteException((Throwable)new AccessControlException("User " + callerUGI.getShortUserName() + " cannot submit applications to" + " target queue or the target queue doesn't exist: " + targetQueue + " while moving " + applicationId));
        }
        if (!ACTIVE_APP_STATES.contains((Object)application.getState())) {
            String msg = "App in " + (Object)((Object)application.getState()) + " state cannot be moved.";
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Move Application Request", "UNKNOWN", "ClientRMService", msg);
            throw new YarnException(msg);
        }
        try {
            this.rmAppManager.moveApplicationAcrossQueue(application.getApplicationId(), request.getTargetQueue());
        }
        catch (YarnException ex) {
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Move Application Request", "UNKNOWN", "ClientRMService", ex.getMessage());
            throw ex;
        }
        RMAuditLogger.logSuccess(callerUGI.getShortUserName(), "Move Application Request", "ClientRMService", applicationId);
        return (MoveApplicationAcrossQueuesResponse)this.recordFactory.newRecordInstance(MoveApplicationAcrossQueuesResponse.class);
    }

    private boolean accessToTargetQueueAllowed(UserGroupInformation callerUGI, RMApp application, String targetQueue) {
        return this.queueACLsManager.checkAccess(callerUGI, QueueACL.SUBMIT_APPLICATIONS, application, Server.getRemoteAddress(), null, targetQueue) || this.queueACLsManager.checkAccess(callerUGI, QueueACL.ADMINISTER_QUEUE, application, Server.getRemoteAddress(), null, targetQueue);
    }

    private String getRenewerForToken(Token<RMDelegationTokenIdentifier> token) throws IOException {
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
        return loginUser.getUserName().equals(user.getUserName()) ? ((RMDelegationTokenIdentifier)token.decodeIdentifier()).getRenewer().toString() : user.getShortUserName();
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAclWithLoadedConfiguration(configuration, policyProvider);
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            return EnumSet.of(UserGroupInformation.AuthenticationMethod.KERBEROS, UserGroupInformation.AuthenticationMethod.KERBEROS_SSL, UserGroupInformation.AuthenticationMethod.CERTIFICATE).contains(UserGroupInformation.getCurrentUser().getRealAuthenticationMethod());
        }
        return true;
    }

    @VisibleForTesting
    public Server getServer() {
        return this.server;
    }

    public GetNewReservationResponse getNewReservation(GetNewReservationRequest request) throws YarnException, IOException {
        this.checkReservationSystem();
        GetNewReservationResponse response = (GetNewReservationResponse)this.recordFactory.newRecordInstance(GetNewReservationResponse.class);
        ReservationId reservationId = this.reservationSystem.getNewReservationId();
        response.setReservationId(reservationId);
        return response;
    }

    public ReservationSubmissionResponse submitReservation(ReservationSubmissionRequest request) throws YarnException, IOException {
        this.checkReservationSystem();
        ReservationSubmissionResponse response = (ReservationSubmissionResponse)this.recordFactory.newRecordInstance(ReservationSubmissionResponse.class);
        ReservationId reservationId = request.getReservationId();
        Plan plan = this.rValidator.validateReservationSubmissionRequest(this.reservationSystem, request, reservationId);
        ReservationAllocation allocation = plan.getReservationById(reservationId);
        if (allocation != null) {
            boolean isNewDefinition;
            boolean bl = isNewDefinition = !allocation.getReservationDefinition().equals(request.getReservationDefinition());
            if (isNewDefinition) {
                String message = "Reservation allocation already exists with the reservation id " + reservationId.toString() + ", but a different" + " reservation definition was provided. Please try again with a " + "new reservation id, or consider updating the reservation instead.";
                throw RPCUtil.getRemoteException((String)message);
            }
            return response;
        }
        String queueName = request.getQueue();
        String user = this.checkReservationACLs(queueName, "Submit Reservation Request", null);
        try {
            boolean result = plan.getReservationAgent().createReservation(reservationId, user, plan, request.getReservationDefinition());
            if (result) {
                this.reservationSystem.setQueueForReservation(reservationId, queueName);
                this.refreshScheduler(queueName, request.getReservationDefinition(), reservationId.toString());
            }
        }
        catch (PlanningException e) {
            RMAuditLogger.logFailure(user, "Submit Reservation Request", e.getMessage(), "ClientRMService", "Unable to create the reservation: " + reservationId);
            throw RPCUtil.getRemoteException((Throwable)e);
        }
        RMAuditLogger.logSuccess(user, "Submit Reservation Request", "ClientRMService: " + reservationId);
        return response;
    }

    public ReservationUpdateResponse updateReservation(ReservationUpdateRequest request) throws YarnException, IOException {
        this.checkReservationSystem();
        ReservationUpdateResponse response = (ReservationUpdateResponse)this.recordFactory.newRecordInstance(ReservationUpdateResponse.class);
        Plan plan = this.rValidator.validateReservationUpdateRequest(this.reservationSystem, request);
        ReservationId reservationId = request.getReservationId();
        String queueName = this.reservationSystem.getQueueForReservation(reservationId);
        String user = this.checkReservationACLs(queueName, "Update Reservation Request", reservationId);
        try {
            boolean result = plan.getReservationAgent().updateReservation(reservationId, user, plan, request.getReservationDefinition());
            if (!result) {
                String errMsg = "Unable to update reservation: " + reservationId;
                RMAuditLogger.logFailure(user, "Update Reservation Request", errMsg, "ClientRMService", errMsg);
                throw RPCUtil.getRemoteException((String)errMsg);
            }
        }
        catch (PlanningException e) {
            RMAuditLogger.logFailure(user, "Update Reservation Request", e.getMessage(), "ClientRMService", "Unable to update the reservation: " + reservationId);
            throw RPCUtil.getRemoteException((Throwable)e);
        }
        RMAuditLogger.logSuccess(user, "Update Reservation Request", "ClientRMService: " + reservationId);
        return response;
    }

    public ReservationDeleteResponse deleteReservation(ReservationDeleteRequest request) throws YarnException, IOException {
        this.checkReservationSystem();
        ReservationDeleteResponse response = (ReservationDeleteResponse)this.recordFactory.newRecordInstance(ReservationDeleteResponse.class);
        Plan plan = this.rValidator.validateReservationDeleteRequest(this.reservationSystem, request);
        ReservationId reservationId = request.getReservationId();
        String queueName = this.reservationSystem.getQueueForReservation(reservationId);
        String user = this.checkReservationACLs(queueName, "Delete Reservation Request", reservationId);
        try {
            boolean result = plan.getReservationAgent().deleteReservation(reservationId, user, plan);
            if (!result) {
                String errMsg = "Could not delete reservation: " + reservationId;
                RMAuditLogger.logFailure(user, "Delete Reservation Request", errMsg, "ClientRMService", errMsg);
                throw RPCUtil.getRemoteException((String)errMsg);
            }
        }
        catch (PlanningException e) {
            RMAuditLogger.logFailure(user, "Delete Reservation Request", e.getMessage(), "ClientRMService", "Unable to delete the reservation: " + reservationId);
            throw RPCUtil.getRemoteException((Throwable)e);
        }
        RMAuditLogger.logSuccess(user, "Delete Reservation Request", "ClientRMService: " + reservationId);
        return response;
    }

    public ReservationListResponse listReservations(ReservationListRequest requestInfo) throws YarnException, IOException {
        this.checkReservationSystem();
        ReservationListResponse response = (ReservationListResponse)this.recordFactory.newRecordInstance(ReservationListResponse.class);
        Plan plan = this.rValidator.validateReservationListRequest(this.reservationSystem, requestInfo);
        boolean includeResourceAllocations = requestInfo.getIncludeResourceAllocations();
        ReservationId reservationId = null;
        if (requestInfo.getReservationId() != null && !requestInfo.getReservationId().isEmpty()) {
            reservationId = ReservationId.parseReservationId((String)requestInfo.getReservationId());
        }
        this.checkReservationACLs(requestInfo.getQueue(), "List Reservation Request", reservationId);
        long startTime = Math.max(requestInfo.getStartTime(), 0L);
        long endTime = requestInfo.getEndTime() <= -1L ? Long.MAX_VALUE : requestInfo.getEndTime();
        Set<ReservationAllocation> reservations = plan.getReservations(reservationId, new ReservationInterval(startTime, endTime));
        List<ReservationAllocationState> info = ReservationSystemUtil.convertAllocationsToReservationInfo(reservations, includeResourceAllocations);
        response.setReservationAllocationState(info);
        return response;
    }

    public GetNodesToLabelsResponse getNodeToLabels(GetNodesToLabelsRequest request) throws YarnException, IOException {
        RMNodeLabelsManager labelsMgr = this.rmContext.getNodeLabelManager();
        return GetNodesToLabelsResponse.newInstance((Map)labelsMgr.getNodeLabels());
    }

    public GetLabelsToNodesResponse getLabelsToNodes(GetLabelsToNodesRequest request) throws YarnException, IOException {
        RMNodeLabelsManager labelsMgr = this.rmContext.getNodeLabelManager();
        if (request.getNodeLabels() == null || request.getNodeLabels().isEmpty()) {
            return GetLabelsToNodesResponse.newInstance((Map)labelsMgr.getLabelsToNodes());
        }
        return GetLabelsToNodesResponse.newInstance((Map)labelsMgr.getLabelsToNodes(request.getNodeLabels()));
    }

    public GetClusterNodeLabelsResponse getClusterNodeLabels(GetClusterNodeLabelsRequest request) throws YarnException, IOException {
        RMNodeLabelsManager labelsMgr = this.rmContext.getNodeLabelManager();
        return GetClusterNodeLabelsResponse.newInstance((List)labelsMgr.getClusterNodeLabels());
    }

    private void checkReservationSystem() throws YarnException {
        if (this.reservationSystem == null) {
            throw RPCUtil.getRemoteException((String)"Reservation is not enabled. Please enable & try again");
        }
    }

    private void refreshScheduler(String planName, ReservationDefinition contract, String reservationId) {
        if (contract.getArrival() - this.clock.getTime() < this.reservationSystem.getPlanFollowerTimeStep()) {
            LOG.debug((Object)MessageFormat.format("Reservation {0} is within threshold so attempting to create synchronously.", reservationId));
            this.reservationSystem.synchronizePlan(planName, true);
            LOG.info((Object)MessageFormat.format("Created reservation {0} synchronously.", reservationId));
        }
    }

    private String checkReservationACLs(String queueName, String auditConstant, ReservationId reservationId) throws YarnException, IOException {
        ReservationAllocation reservation;
        UserGroupInformation callerUGI;
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, queueName, "ClientRMService", "Error getting UGI");
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        if (this.reservationSystem == null) {
            return callerUGI.getShortUserName();
        }
        ReservationsACLsManager manager = this.reservationSystem.getReservationsACLsManager();
        ReservationACL reservationACL = this.getReservationACLFromAuditConstant(auditConstant);
        if (manager == null) {
            return callerUGI.getShortUserName();
        }
        String reservationCreatorName = "";
        Plan plan = this.reservationSystem.getPlan(queueName);
        if (reservationId != null && plan != null && (reservation = plan.getReservationById(reservationId)) != null) {
            reservationCreatorName = reservation.getUser();
        }
        if (reservationCreatorName != null && !reservationCreatorName.isEmpty() && reservationCreatorName.equals(callerUGI.getUserName())) {
            return callerUGI.getShortUserName();
        }
        if (manager.checkAccess(callerUGI, reservationACL, queueName)) {
            return callerUGI.getShortUserName();
        }
        if (manager.checkAccess(callerUGI, ReservationACL.ADMINISTER_RESERVATIONS, queueName)) {
            return callerUGI.getShortUserName();
        }
        this.handleNoAccess(callerUGI.getShortUserName(), queueName, auditConstant, reservationACL.toString(), reservationACL.name());
        throw new IllegalStateException();
    }

    private ReservationACL getReservationACLFromAuditConstant(String auditConstant) throws YarnException {
        if (auditConstant.equals("Submit Reservation Request")) {
            return ReservationACL.SUBMIT_RESERVATIONS;
        }
        if (auditConstant.equals("List Reservation Request")) {
            return ReservationACL.LIST_RESERVATIONS;
        }
        if (auditConstant.equals("Delete Reservation Request") || auditConstant.equals("Update Reservation Request")) {
            return ReservationACL.ADMINISTER_RESERVATIONS;
        }
        String error = "Audit Constant " + auditConstant + " is not recognized.";
        LOG.error((Object)error);
        throw RPCUtil.getRemoteException((Throwable)new UnrecognizedOptionException(error));
    }

    private void handleNoAccess(String name, String queue, String auditConstant, String acl, String op) throws YarnException {
        RMAuditLogger.logFailure(name, auditConstant, "User doesn't have permissions to " + acl, "ClientRMService", auditConstant);
        throw RPCUtil.getRemoteException((Throwable)new AccessControlException("User " + name + " cannot perform operation " + op + " on queue " + queue));
    }

    public UpdateApplicationPriorityResponse updateApplicationPriority(UpdateApplicationPriorityRequest request) throws YarnException, IOException {
        ApplicationId applicationId = request.getApplicationId();
        Priority newAppPriority = request.getApplicationPriority();
        UserGroupInformation callerUGI = this.getCallerUgi(applicationId, "Update Application Priority");
        RMApp application = this.verifyUserAccessForRMApp(applicationId, callerUGI, "Update Application Priority", ApplicationAccessType.MODIFY_APP, true);
        UpdateApplicationPriorityResponse response = (UpdateApplicationPriorityResponse)this.recordFactory.newRecordInstance(UpdateApplicationPriorityResponse.class);
        if (!ACTIVE_APP_STATES.contains((Object)application.getState())) {
            if (application.isAppInCompletedStates()) {
                RMAuditLogger.logSuccess(callerUGI.getShortUserName(), "Update Application Priority", "ClientRMService", applicationId);
                response.setApplicationPriority(application.getApplicationPriority());
                return response;
            }
            String msg = "Application in " + (Object)((Object)application.getState()) + " state cannot update priority.";
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Update Application Priority", "UNKNOWN", "ClientRMService", msg);
            throw new YarnException(msg);
        }
        try {
            this.rmAppManager.updateApplicationPriority(callerUGI, application.getApplicationId(), newAppPriority);
        }
        catch (YarnException ex) {
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Update Application Priority", "UNKNOWN", "ClientRMService", ex.getMessage());
            throw ex;
        }
        RMAuditLogger.logSuccess(callerUGI.getShortUserName(), "Update Application Priority", "ClientRMService", applicationId);
        response.setApplicationPriority(application.getApplicationPriority());
        return response;
    }

    public SignalContainerResponse signalToContainer(SignalContainerRequest request) throws YarnException, IOException {
        UserGroupInformation callerUGI;
        ContainerId containerId = request.getContainerId();
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        ApplicationId applicationId = containerId.getApplicationAttemptId().getApplicationId();
        RMApp application = (RMApp)this.rmContext.getRMApps().get(applicationId);
        if (application == null) {
            RMAuditLogger.logFailure(callerUGI.getUserName(), "Signal Container Request", "UNKNOWN", "ClientRMService", "Trying to signal an absent container", applicationId, containerId, null);
            throw RPCUtil.getRemoteException((String)("Trying to signal an absent container " + containerId));
        }
        if (!this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.MODIFY_APP, application)) {
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Signal Container Request", "User doesn't have permissions to " + ApplicationAccessType.MODIFY_APP.toString(), "ClientRMService", "Unauthorized user", applicationId);
            throw RPCUtil.getRemoteException((Throwable)new AccessControlException("User " + callerUGI.getShortUserName() + " cannot perform operation " + ApplicationAccessType.MODIFY_APP.name() + " on " + applicationId));
        }
        RMContainer container = this.scheduler.getRMContainer(containerId);
        if (container == null) {
            RMAuditLogger.logFailure(callerUGI.getUserName(), "Signal Container Request", "UNKNOWN", "ClientRMService", "Trying to signal an absent container", applicationId, containerId, null);
            throw RPCUtil.getRemoteException((String)("Trying to signal an absent container " + containerId));
        }
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeSignalContainerEvent(container.getContainer().getNodeId(), request));
        RMAuditLogger.logSuccess(callerUGI.getShortUserName(), "Signal Container Request", "ClientRMService", applicationId, containerId, null);
        return (SignalContainerResponse)this.recordFactory.newRecordInstance(SignalContainerResponse.class);
    }

    public UpdateApplicationTimeoutsResponse updateApplicationTimeouts(UpdateApplicationTimeoutsRequest request) throws YarnException, IOException {
        ApplicationId applicationId = request.getApplicationId();
        Map<ApplicationTimeoutType, String> applicationTimeouts = request.getApplicationTimeouts();
        UserGroupInformation callerUGI = this.getCallerUgi(applicationId, "Update Application Timeouts");
        RMApp application = this.verifyUserAccessForRMApp(applicationId, callerUGI, "Update Application Timeouts", ApplicationAccessType.MODIFY_APP, true);
        if (applicationTimeouts.isEmpty()) {
            String message = "At least one ApplicationTimeoutType should be configured for updating timeouts.";
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Update Application Timeouts", "UNKNOWN", "ClientRMService", message, applicationId);
            throw RPCUtil.getRemoteException((String)message);
        }
        UpdateApplicationTimeoutsResponse response = (UpdateApplicationTimeoutsResponse)this.recordFactory.newRecordInstance(UpdateApplicationTimeoutsResponse.class);
        RMAppState state = application.getState();
        if (!EnumSet.of(RMAppState.SUBMITTED, RMAppState.ACCEPTED, RMAppState.RUNNING).contains((Object)state)) {
            if (application.isAppInCompletedStates()) {
                RMAuditLogger.logSuccess(callerUGI.getShortUserName(), "Update Application Timeouts", "ClientRMService", applicationId);
                response.setApplicationTimeouts(applicationTimeouts);
                return response;
            }
            String msg = "Application is in " + (Object)((Object)state) + " state can not update timeout.";
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Update Application Timeouts", "UNKNOWN", "ClientRMService", msg);
            throw RPCUtil.getRemoteException((String)msg);
        }
        try {
            applicationTimeouts = this.rmAppManager.updateApplicationTimeout(application, applicationTimeouts);
        }
        catch (YarnException ex) {
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Update Application Timeouts", "UNKNOWN", "ClientRMService", ex.getMessage());
            throw ex;
        }
        RMAuditLogger.logSuccess(callerUGI.getShortUserName(), "Update Application Timeouts", "ClientRMService", applicationId);
        response.setApplicationTimeouts(applicationTimeouts);
        return response;
    }

    private UserGroupInformation getCallerUgi(ApplicationId applicationId, String operation) throws YarnException {
        UserGroupInformation callerUGI;
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            RMAuditLogger.logFailure("UNKNOWN", operation, "UNKNOWN", "ClientRMService", "Error getting UGI", applicationId);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        return callerUGI;
    }

    private RMApp verifyUserAccessForRMApp(ApplicationId applicationId, UserGroupInformation callerUGI, String operation, ApplicationAccessType accessType, boolean needCheckAccess) throws YarnException {
        RMApp application = (RMApp)this.rmContext.getRMApps().get(applicationId);
        if (application == null) {
            RMAuditLogger.logFailure(callerUGI.getUserName(), operation, "UNKNOWN", "ClientRMService", "Trying to " + operation + " of an absent application", applicationId);
            throw new ApplicationNotFoundException("Application with id '" + applicationId + "' doesn't exist in RM. " + "Please check that the job " + "submission was successful.");
        }
        if (needCheckAccess && !this.checkAccess(callerUGI, application.getUser(), accessType, application)) {
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), operation, "User doesn't have permissions to " + accessType.toString(), "ClientRMService", "Unauthorized user", applicationId);
            throw RPCUtil.getRemoteException((Throwable)new AccessControlException("User " + callerUGI.getShortUserName() + " cannot perform operation " + accessType.name() + " on " + applicationId));
        }
        return application;
    }

    public GetAllResourceProfilesResponse getResourceProfiles(GetAllResourceProfilesRequest request) throws YarnException, IOException {
        GetAllResourceProfilesResponse response = GetAllResourceProfilesResponse.newInstance();
        response.setResourceProfiles(this.resourceProfilesManager.getResourceProfiles());
        return response;
    }

    public GetResourceProfileResponse getResourceProfile(GetResourceProfileRequest request) throws YarnException, IOException {
        GetResourceProfileResponse response = GetResourceProfileResponse.newInstance();
        response.setResource(this.resourceProfilesManager.getProfile(request.getProfileName()));
        return response;
    }

    public GetAllResourceTypeInfoResponse getResourceTypeInfo(GetAllResourceTypeInfoRequest request) throws YarnException, IOException {
        GetAllResourceTypeInfoResponse response = GetAllResourceTypeInfoResponse.newInstance();
        response.setResourceTypeInfo(ResourceUtils.getResourcesTypeInfo());
        return response;
    }

    @VisibleForTesting
    public void setDisplayPerUserApps(boolean displayPerUserApps) {
        this.filterAppsByUser = displayPerUserApps;
    }
}

