/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.amrmproxy;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AMRMProxyApplicationContext;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AMRMProxyApplicationContextImpl;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AMRMProxyTokenSecretManager;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.RequestInterceptor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.apache.hadoop.yarn.server.nodemanager.scheduler.DistributedScheduler;
import org.apache.hadoop.yarn.server.security.MasterKeyData;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.utils.YarnServerSecurityUtils;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMRMProxyService
extends CompositeService
implements ApplicationMasterProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(AMRMProxyService.class);
    private static final String NMSS_USER_KEY = "user";
    private static final String NMSS_AMRMTOKEN_KEY = "amrmtoken";
    private Server server;
    private final Context nmContext;
    private final AsyncDispatcher dispatcher;
    private InetSocketAddress listenerEndpoint;
    private AMRMProxyTokenSecretManager secretManager;
    private Map<ApplicationId, RequestInterceptorChainWrapper> applPipelineMap;
    private RegistryOperations registry;

    public AMRMProxyService(Context nmContext, AsyncDispatcher dispatcher) {
        super(AMRMProxyService.class.getName());
        Preconditions.checkArgument((nmContext != null ? 1 : 0) != 0, (Object)"nmContext is null");
        Preconditions.checkArgument((dispatcher != null ? 1 : 0) != 0, (Object)"dispatcher is null");
        this.nmContext = nmContext;
        this.dispatcher = dispatcher;
        this.applPipelineMap = new ConcurrentHashMap<ApplicationId, RequestInterceptorChainWrapper>();
        this.dispatcher.register(ApplicationEventType.class, (EventHandler)new ApplicationEventHandler());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.secretManager = new AMRMProxyTokenSecretManager(this.nmContext.getNMStateStore());
        this.secretManager.init(conf);
        if (conf.getBoolean("yarn.nodemanager.amrmproxy.ha.enable", false)) {
            this.registry = FederationStateStoreFacade.createInstance(conf, "yarn.registry.class", "org.apache.hadoop.registry.client.impl.FSRegistryOperationsService", RegistryOperations.class);
            this.addService(this.registry);
        }
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        LOG.info("Starting AMRMProxyService");
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.listenerEndpoint = conf.getSocketAddr("yarn.nodemanager.amrmproxy.address", "0.0.0.0:8049", 8049);
        Configuration serverConf = new Configuration(conf);
        serverConf.set("hadoop.security.authentication", SaslRpcServer.AuthMethod.TOKEN.toString());
        int numWorkerThreads = serverConf.getInt("yarn.nodemanager.amrmproxy.client.thread-count", 3);
        this.secretManager.start();
        this.server = rpc.getServer(ApplicationMasterProtocol.class, (Object)this, this.listenerEndpoint, serverConf, (SecretManager)this.secretManager, numWorkerThreads);
        this.server.start();
        LOG.info("AMRMProxyService listening on address: " + this.server.getListenerAddress());
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        LOG.info("Stopping AMRMProxyService");
        if (this.server != null) {
            this.server.stop();
        }
        this.secretManager.stop();
        super.serviceStop();
    }

    public void recover() throws IOException {
        LOG.info("Recovering AMRMProxyService");
        NMStateStoreService.RecoveredAMRMProxyState state = this.nmContext.getNMStateStore().loadAMRMProxyState();
        this.secretManager.recover(state);
        LOG.info("Recovering {} running applications for AMRMProxy", (Object)state.getAppContexts().size());
        for (Map.Entry<ApplicationAttemptId, Map<String, byte[]>> entry : state.getAppContexts().entrySet()) {
            ApplicationAttemptId attemptId = entry.getKey();
            LOG.info("Recovering app attempt {}", (Object)attemptId);
            try {
                String user = null;
                Token amrmToken = null;
                for (Map.Entry<String, byte[]> contextEntry : entry.getValue().entrySet()) {
                    if (contextEntry.getKey().equals(NMSS_USER_KEY)) {
                        user = new String(contextEntry.getValue(), "UTF-8");
                        continue;
                    }
                    if (!contextEntry.getKey().equals(NMSS_AMRMTOKEN_KEY)) continue;
                    amrmToken = new Token();
                    amrmToken.decodeFromUrlString(new String(contextEntry.getValue(), "UTF-8"));
                    amrmToken.setService(new Text());
                }
                if (amrmToken == null) {
                    throw new IOException("No amrmToken found for app attempt " + attemptId);
                }
                if (user == null) {
                    throw new IOException("No user found for app attempt " + attemptId);
                }
                Token<AMRMTokenIdentifier> localToken = this.secretManager.createAndGetAMRMToken(attemptId);
                Credentials amCred = null;
                for (Container container : this.nmContext.getContainers().values()) {
                    LOG.debug("From NM Context container " + container.getContainerId());
                    if (!container.getContainerId().getApplicationAttemptId().equals((Object)attemptId) || container.getContainerTokenIdentifier() == null) continue;
                    LOG.debug("Container type " + container.getContainerTokenIdentifier().getContainerType());
                    if (container.getContainerTokenIdentifier().getContainerType() != ContainerType.APPLICATION_MASTER) continue;
                    LOG.info("AM container {} found in context, has credentials: {}", (Object)container.getContainerId(), (Object)(container.getCredentials() != null ? 1 : 0));
                    amCred = container.getCredentials();
                }
                if (amCred == null) {
                    LOG.error("No credentials found for AM container of {}. Yarn registry access might not work", (Object)attemptId);
                }
                this.initializePipeline(attemptId, user, (Token<AMRMTokenIdentifier>)amrmToken, localToken, entry.getValue(), true, amCred);
            }
            catch (Throwable e) {
                LOG.error("Exception when recovering " + attemptId + ", removing it from NMStateStore and move on", e);
                this.nmContext.getNMStateStore().removeAMRMProxyAppContext(attemptId);
            }
        }
    }

    public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        LOG.info("Registering application master. Host:" + request.getHost() + " Port:" + request.getRpcPort() + " Tracking Url:" + request.getTrackingUrl());
        RequestInterceptorChainWrapper pipeline = this.authorizeAndGetInterceptorChain();
        return pipeline.getRootInterceptor().registerApplicationMaster(request);
    }

    public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
        LOG.info("Finishing application master. Tracking Url:" + request.getTrackingUrl());
        RequestInterceptorChainWrapper pipeline = this.authorizeAndGetInterceptorChain();
        return pipeline.getRootInterceptor().finishApplicationMaster(request);
    }

    public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
        AMRMTokenIdentifier amrmTokenIdentifier = YarnServerSecurityUtils.authorizeRequest();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(amrmTokenIdentifier);
        AllocateResponse allocateResponse = pipeline.getRootInterceptor().allocate(request);
        this.updateAMRMTokens(amrmTokenIdentifier, pipeline, allocateResponse);
        return allocateResponse;
    }

    public void processApplicationStartRequest(StartContainerRequest request) throws IOException, YarnException {
        LOG.info("Callback received for initializing request processing pipeline for an AM");
        ContainerTokenIdentifier containerTokenIdentifierForKey = BuilderUtils.newContainerTokenIdentifier(request.getContainerToken());
        ApplicationAttemptId appAttemptId = containerTokenIdentifierForKey.getContainerID().getApplicationAttemptId();
        Credentials credentials = YarnServerSecurityUtils.parseCredentials(request.getContainerLaunchContext());
        Token<AMRMTokenIdentifier> amrmToken = this.getFirstAMRMToken(credentials.getAllTokens());
        if (amrmToken == null) {
            throw new YarnRuntimeException("AMRMToken not found in the start container request for application:" + appAttemptId.toString());
        }
        Token<AMRMTokenIdentifier> localToken = this.secretManager.createAndGetAMRMToken(appAttemptId);
        credentials.addToken(localToken.getService(), localToken);
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        request.getContainerLaunchContext().setTokens(ByteBuffer.wrap(dob.getData(), 0, dob.getLength()));
        this.initializePipeline(appAttemptId, containerTokenIdentifierForKey.getApplicationSubmitter(), amrmToken, localToken, null, false, credentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializePipeline(ApplicationAttemptId applicationAttemptId, String user, Token<AMRMTokenIdentifier> amrmToken, Token<AMRMTokenIdentifier> localToken, Map<String, byte[]> recoveredDataMap, boolean isRecovery, Credentials credentials) {
        RequestInterceptorChainWrapper chainWrapper = null;
        Map<ApplicationId, RequestInterceptorChainWrapper> map = this.applPipelineMap;
        synchronized (map) {
            if (this.applPipelineMap.containsKey(applicationAttemptId.getApplicationId())) {
                LOG.warn("Request to start an already existing appId was received.  This can happen if an application failed and a new attempt was created on this machine.  ApplicationId: " + applicationAttemptId.toString());
                RequestInterceptorChainWrapper chainWrapperBackup = this.applPipelineMap.get(applicationAttemptId.getApplicationId());
                if (chainWrapperBackup != null && chainWrapperBackup.getApplicationAttemptId() != null && !chainWrapperBackup.getApplicationAttemptId().equals((Object)applicationAttemptId)) {
                    LOG.info("Remove the previous pipeline for ApplicationId: " + applicationAttemptId.toString());
                    RequestInterceptorChainWrapper pipeline = this.applPipelineMap.remove(applicationAttemptId.getApplicationId());
                    if (!isRecovery && this.nmContext.getNMStateStore() != null) {
                        try {
                            this.nmContext.getNMStateStore().removeAMRMProxyAppContext(applicationAttemptId);
                        }
                        catch (IOException e) {
                            LOG.error("Error removing AMRMProxy application context for " + applicationAttemptId, (Throwable)e);
                        }
                    }
                    try {
                        pipeline.getRootInterceptor().shutdown();
                    }
                    catch (Throwable ex) {
                        LOG.warn("Failed to shutdown the request processing pipeline for app:" + applicationAttemptId.getApplicationId(), ex);
                    }
                } else {
                    return;
                }
            }
            chainWrapper = new RequestInterceptorChainWrapper();
            this.applPipelineMap.put(applicationAttemptId.getApplicationId(), chainWrapper);
        }
        LOG.info("Initializing request processing pipeline for application.  ApplicationId:" + applicationAttemptId + " for the user: " + user);
        try {
            RequestInterceptor interceptorChain = this.createRequestInterceptorChain();
            interceptorChain.init(this.createApplicationMasterContext(this.nmContext, applicationAttemptId, user, amrmToken, localToken, credentials, this.registry));
            if (isRecovery) {
                if (recoveredDataMap == null) {
                    throw new YarnRuntimeException("null recoveredDataMap recieved for recover");
                }
                interceptorChain.recover(recoveredDataMap);
            }
            chainWrapper.init(interceptorChain, applicationAttemptId);
            if (!isRecovery && this.nmContext.getNMStateStore() != null) {
                try {
                    this.nmContext.getNMStateStore().storeAMRMProxyAppContextEntry(applicationAttemptId, NMSS_USER_KEY, user.getBytes("UTF-8"));
                    this.nmContext.getNMStateStore().storeAMRMProxyAppContextEntry(applicationAttemptId, NMSS_AMRMTOKEN_KEY, amrmToken.encodeToUrlString().getBytes("UTF-8"));
                }
                catch (IOException e) {
                    LOG.error("Error storing AMRMProxy application context entry for " + applicationAttemptId, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.applPipelineMap.remove(applicationAttemptId.getApplicationId());
            throw e;
        }
    }

    protected void stopApplication(ApplicationId applicationId) {
        Preconditions.checkArgument((applicationId != null ? 1 : 0) != 0, (Object)"applicationId is null");
        RequestInterceptorChainWrapper pipeline = this.applPipelineMap.remove(applicationId);
        if (pipeline == null) {
            LOG.info("No interceptor pipeline for application {}, likely because its AM is not run in this node.", (Object)applicationId);
        } else {
            this.secretManager.applicationMasterFinished(pipeline.getApplicationAttemptId());
            LOG.info("Stopping the request processing pipeline for application: " + applicationId);
            try {
                pipeline.getRootInterceptor().shutdown();
            }
            catch (Throwable ex) {
                LOG.warn("Failed to shutdown the request processing pipeline for app:" + applicationId, ex);
            }
            if (this.nmContext.getNMStateStore() != null) {
                try {
                    this.nmContext.getNMStateStore().removeAMRMProxyAppContext(pipeline.getApplicationAttemptId());
                }
                catch (IOException e) {
                    LOG.error("Error removing AMRMProxy application context for " + applicationId, (Throwable)e);
                }
            }
        }
    }

    private void updateAMRMTokens(AMRMTokenIdentifier amrmTokenIdentifier, RequestInterceptorChainWrapper pipeline, AllocateResponse allocateResponse) {
        MasterKeyData nextMasterKey;
        AMRMProxyApplicationContextImpl context = (AMRMProxyApplicationContextImpl)pipeline.getRootInterceptor().getApplicationContext();
        if (allocateResponse.getAMRMToken() != null) {
            LOG.info("RM rolled master-key for amrm-tokens");
            org.apache.hadoop.yarn.api.records.Token token = allocateResponse.getAMRMToken();
            allocateResponse.setAMRMToken(null);
            Token newToken = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)token, (Text)null);
            if (context.setAMRMToken((Token<AMRMTokenIdentifier>)newToken) && this.nmContext.getNMStateStore() != null) {
                try {
                    this.nmContext.getNMStateStore().storeAMRMProxyAppContextEntry(context.getApplicationAttemptId(), NMSS_AMRMTOKEN_KEY, newToken.encodeToUrlString().getBytes("UTF-8"));
                }
                catch (IOException e) {
                    LOG.error("Error storing AMRMProxy application context entry for " + context.getApplicationAttemptId(), (Throwable)e);
                }
            }
        }
        if ((nextMasterKey = this.secretManager.getNextMasterKeyData()) != null && nextMasterKey.getMasterKey().getKeyId() != amrmTokenIdentifier.getKeyId()) {
            Token<AMRMTokenIdentifier> localToken = context.getLocalAMRMToken();
            if (nextMasterKey.getMasterKey().getKeyId() != context.getLocalAMRMTokenKeyId()) {
                LOG.info("The local AMRMToken has been rolled-over. Send new local AMRMToken back to application: " + pipeline.getApplicationId());
                localToken = this.secretManager.createAndGetAMRMToken(pipeline.getApplicationAttemptId());
                context.setLocalAMRMToken(localToken);
            }
            allocateResponse.setAMRMToken(org.apache.hadoop.yarn.api.records.Token.newInstance((byte[])localToken.getIdentifier(), (String)localToken.getKind().toString(), (byte[])localToken.getPassword(), (String)localToken.getService().toString()));
        }
    }

    private AMRMProxyApplicationContext createApplicationMasterContext(Context context, ApplicationAttemptId applicationAttemptId, String user, Token<AMRMTokenIdentifier> amrmToken, Token<AMRMTokenIdentifier> localToken, Credentials credentials, RegistryOperations registryImpl) {
        AMRMProxyApplicationContextImpl appContext = new AMRMProxyApplicationContextImpl(context, this.getConfig(), applicationAttemptId, user, amrmToken, localToken, credentials, registryImpl);
        return appContext;
    }

    protected Map<ApplicationId, RequestInterceptorChainWrapper> getPipelines() {
        return this.applPipelineMap;
    }

    protected RequestInterceptor createRequestInterceptorChain() {
        Configuration conf = this.getConfig();
        List<String> interceptorClassNames = this.getInterceptorClassNames(conf);
        RequestInterceptor pipeline = null;
        RequestInterceptor current = null;
        for (String interceptorClassName : interceptorClassNames) {
            try {
                Class interceptorClass = conf.getClassByName(interceptorClassName);
                if (RequestInterceptor.class.isAssignableFrom(interceptorClass)) {
                    RequestInterceptor interceptorInstance = (RequestInterceptor)ReflectionUtils.newInstance((Class)interceptorClass, (Configuration)conf);
                    if (pipeline == null) {
                        pipeline = interceptorInstance;
                        current = interceptorInstance;
                        continue;
                    }
                    current.setNextInterceptor(interceptorInstance);
                    current = interceptorInstance;
                    continue;
                }
                throw new YarnRuntimeException("Class: " + interceptorClassName + " not instance of " + RequestInterceptor.class.getCanonicalName());
            }
            catch (ClassNotFoundException e) {
                throw new YarnRuntimeException("Could not instantiate ApplicationMasterRequestInterceptor: " + interceptorClassName, (Throwable)e);
            }
        }
        if (pipeline == null) {
            throw new YarnRuntimeException("RequestInterceptor pipeline is not configured in the system");
        }
        return pipeline;
    }

    private List<String> getInterceptorClassNames(Configuration conf) {
        String configuredInterceptorClassNames = conf.get("yarn.nodemanager.amrmproxy.interceptor-class.pipeline", "org.apache.hadoop.yarn.server.nodemanager.amrmproxy.DefaultRequestInterceptor");
        ArrayList<String> interceptorClassNames = new ArrayList<String>();
        Collection tempList = StringUtils.getStringCollection((String)configuredInterceptorClassNames);
        for (String item : tempList) {
            interceptorClassNames.add(item.trim());
        }
        if (this.nmContext.isDistributedSchedulingEnabled()) {
            interceptorClassNames.add(0, DistributedScheduler.class.getName());
        }
        return interceptorClassNames;
    }

    private RequestInterceptorChainWrapper authorizeAndGetInterceptorChain() throws YarnException {
        AMRMTokenIdentifier tokenIdentifier = YarnServerSecurityUtils.authorizeRequest();
        return this.getInterceptorChain(tokenIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestInterceptorChainWrapper getInterceptorChain(AMRMTokenIdentifier tokenIdentifier) throws YarnException {
        ApplicationAttemptId appAttemptId = tokenIdentifier.getApplicationAttemptId();
        Map<ApplicationId, RequestInterceptorChainWrapper> map = this.applPipelineMap;
        synchronized (map) {
            if (!this.applPipelineMap.containsKey(appAttemptId.getApplicationId())) {
                throw new YarnException("The AM request processing pipeline is not initialized for app: " + appAttemptId.getApplicationId().toString());
            }
            return this.applPipelineMap.get(appAttemptId.getApplicationId());
        }
    }

    private Token<AMRMTokenIdentifier> getFirstAMRMToken(Collection<Token<? extends TokenIdentifier>> allTokens) {
        for (Token<? extends TokenIdentifier> token : allTokens) {
            if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
            return token;
        }
        return null;
    }

    @InterfaceAudience.Private
    public InetSocketAddress getBindAddress() {
        return this.listenerEndpoint;
    }

    @InterfaceAudience.Private
    public AMRMProxyTokenSecretManager getSecretManager() {
        return this.secretManager;
    }

    @InterfaceAudience.Private
    public static class RequestInterceptorChainWrapper {
        private RequestInterceptor rootInterceptor;
        private ApplicationAttemptId applicationAttemptId;

        public synchronized void init(RequestInterceptor rootInterceptor, ApplicationAttemptId applicationAttemptId) {
            this.rootInterceptor = rootInterceptor;
            this.applicationAttemptId = applicationAttemptId;
        }

        public synchronized RequestInterceptor getRootInterceptor() {
            return this.rootInterceptor;
        }

        public synchronized ApplicationAttemptId getApplicationAttemptId() {
            return this.applicationAttemptId;
        }

        public synchronized ApplicationId getApplicationId() {
            return this.applicationAttemptId.getApplicationId();
        }
    }

    class ApplicationEventHandler
    implements EventHandler<ApplicationEvent> {
        ApplicationEventHandler() {
        }

        public void handle(ApplicationEvent event) {
            Application app = (Application)AMRMProxyService.this.nmContext.getApplications().get(event.getApplicationID());
            if (app != null) {
                switch ((ApplicationEventType)event.getType()) {
                    case APPLICATION_RESOURCES_CLEANEDUP: {
                        LOG.info("Application stop event received for stopping AppId:" + event.getApplicationID().toString());
                        AMRMProxyService.this.stopApplication(event.getApplicationID());
                        break;
                    }
                    default: {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("AMRMProxy is ignoring event: " + event.getType());
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                LOG.warn("Event " + (Object)((Object)event) + " sent to absent application " + event.getApplicationID());
            }
        }
    }
}

