/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.dao;

import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.com.sun.jersey.api.json.JSONConfiguration;
import org.apache.hadoop.shaded.com.sun.jersey.api.json.JSONJAXBContext;
import org.apache.hadoop.shaded.com.sun.jersey.api.json.JSONMarshaller;
import org.apache.hadoop.shaded.com.sun.jersey.api.json.JSONUnmarshaller;
import org.apache.hadoop.shaded.org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@XmlRootElement(name="federation-policy")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WeightedPolicyInfo {
    private static final Logger LOG = LoggerFactory.getLogger(WeightedPolicyInfo.class);
    private static JSONJAXBContext jsonjaxbContext = WeightedPolicyInfo.initContext();
    private Map<SubClusterIdInfo, Float> routerPolicyWeights = new HashMap<SubClusterIdInfo, Float>();
    private Map<SubClusterIdInfo, Float> amrmPolicyWeights = new HashMap<SubClusterIdInfo, Float>();
    private float headroomAlpha;

    private static JSONJAXBContext initContext() {
        try {
            return new JSONJAXBContext(JSONConfiguration.DEFAULT, WeightedPolicyInfo.class);
        }
        catch (JAXBException e) {
            LOG.error("Error parsing the policy.", (Throwable)e);
            return null;
        }
    }

    public static WeightedPolicyInfo fromByteBuffer(ByteBuffer bb) throws FederationPolicyInitializationException {
        if (jsonjaxbContext == null) {
            throw new FederationPolicyInitializationException("JSONJAXBContext should not be null.");
        }
        try {
            JSONUnmarshaller unmarshaller = jsonjaxbContext.createJSONUnmarshaller();
            byte[] bytes = new byte[bb.remaining()];
            bb.get(bytes);
            String params = new String(bytes, StandardCharsets.UTF_8);
            WeightedPolicyInfo weightedPolicyInfo = unmarshaller.unmarshalFromJSON(new StringReader(params), WeightedPolicyInfo.class);
            return weightedPolicyInfo;
        }
        catch (JAXBException j) {
            throw new FederationPolicyInitializationException(j);
        }
    }

    public Map<SubClusterIdInfo, Float> getRouterPolicyWeights() {
        return this.routerPolicyWeights;
    }

    public void setRouterPolicyWeights(Map<SubClusterIdInfo, Float> policyWeights) {
        this.routerPolicyWeights = policyWeights;
    }

    public Map<SubClusterIdInfo, Float> getAMRMPolicyWeights() {
        return this.amrmPolicyWeights;
    }

    public void setAMRMPolicyWeights(Map<SubClusterIdInfo, Float> policyWeights) {
        this.amrmPolicyWeights = policyWeights;
    }

    public ByteBuffer toByteBuffer() throws FederationPolicyInitializationException {
        if (jsonjaxbContext == null) {
            throw new FederationPolicyInitializationException("JSONJAXBContext should not be null.");
        }
        try {
            String s = this.toJSONString();
            return ByteBuffer.wrap(s.getBytes(StandardCharsets.UTF_8));
        }
        catch (JAXBException j) {
            throw new FederationPolicyInitializationException(j);
        }
    }

    private String toJSONString() throws JAXBException {
        JSONMarshaller marshaller = jsonjaxbContext.createJSONMarshaller();
        marshaller.setProperty("jaxb.formatted.output", true);
        StringWriter sw = new StringWriter(256);
        marshaller.marshallToJSON((Object)this, sw);
        return sw.toString();
    }

    public boolean equals(Object other) {
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        WeightedPolicyInfo otherPolicy = (WeightedPolicyInfo)other;
        Map<SubClusterIdInfo, Float> otherAMRMWeights = otherPolicy.getAMRMPolicyWeights();
        Map<SubClusterIdInfo, Float> otherRouterWeights = otherPolicy.getRouterPolicyWeights();
        boolean amrmWeightsMatch = otherAMRMWeights != null && this.getAMRMPolicyWeights() != null && CollectionUtils.isEqualCollection(otherAMRMWeights.entrySet(), this.getAMRMPolicyWeights().entrySet());
        boolean routerWeightsMatch = otherRouterWeights != null && this.getRouterPolicyWeights() != null && CollectionUtils.isEqualCollection(otherRouterWeights.entrySet(), this.getRouterPolicyWeights().entrySet());
        return amrmWeightsMatch && routerWeightsMatch;
    }

    public int hashCode() {
        return 31 * this.amrmPolicyWeights.hashCode() + this.routerPolicyWeights.hashCode();
    }

    public float getHeadroomAlpha() {
        return this.headroomAlpha;
    }

    public void setHeadroomAlpha(float headroomAlpha) {
        this.headroomAlpha = headroomAlpha;
    }

    public String toString() {
        try {
            return this.toJSONString();
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return "Error serializing to string.";
        }
    }
}

