/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.terracotta.offheapstore;

import java.nio.IntBuffer;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import org.apache.hadoop.shaded.org.terracotta.offheapstore.AbstractLockedOffHeapHashMap;
import org.apache.hadoop.shaded.org.terracotta.offheapstore.exceptions.OversizeMappingException;
import org.apache.hadoop.shaded.org.terracotta.offheapstore.paging.PageSource;
import org.apache.hadoop.shaded.org.terracotta.offheapstore.pinning.PinnableCache;
import org.apache.hadoop.shaded.org.terracotta.offheapstore.pinning.PinnableSegment;
import org.apache.hadoop.shaded.org.terracotta.offheapstore.storage.StorageEngine;
import org.apache.hadoop.shaded.org.terracotta.offheapstore.util.DebuggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOffHeapClockCache<K, V>
extends AbstractLockedOffHeapHashMap<K, V>
implements PinnableCache<K, V>,
PinnableSegment<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOffHeapClockCache.class);
    private static final int PRESENT_CLOCK = Integer.MIN_VALUE;
    private final Random rndm = new Random();
    private int clockHand;

    public AbstractOffHeapClockCache(PageSource source, StorageEngine<? super K, ? super V> storageEngine) {
        super(source, storageEngine);
    }

    public AbstractOffHeapClockCache(PageSource source, boolean tableAllocationsSteal, StorageEngine<? super K, ? super V> storageEngine) {
        super(source, tableAllocationsSteal, storageEngine);
    }

    public AbstractOffHeapClockCache(PageSource source, StorageEngine<? super K, ? super V> storageEngine, boolean bootstrap) {
        super(source, storageEngine, bootstrap);
    }

    public AbstractOffHeapClockCache(PageSource source, StorageEngine<? super K, ? super V> storageEngine, int tableSize) {
        super(source, storageEngine, tableSize);
    }

    public AbstractOffHeapClockCache(PageSource source, boolean tableAllocationsSteal, StorageEngine<? super K, ? super V> storageEngine, int tableSize) {
        super(source, tableAllocationsSteal, storageEngine, tableSize);
    }

    public AbstractOffHeapClockCache(PageSource source, StorageEngine<? super K, ? super V> storageEngine, int tableSize, boolean bootstrap) {
        super(source, storageEngine, tableSize, bootstrap);
    }

    @Override
    protected void storageEngineFailure(Object failure) {
        if (this.isEmpty()) {
            StringBuilder sb = new StringBuilder("Storage Engine and Eviction Failed - Empty Map\n");
            sb.append("Storage Engine : ").append(this.storageEngine);
            throw new OversizeMappingException(sb.toString());
        }
        int evictionIndex = this.getEvictionIndex();
        if (evictionIndex < 0) {
            StringBuilder sb = new StringBuilder("Storage Engine and Eviction Failed - Everything Pinned (" + this.getSize() + " mappings) \n");
            sb.append("Storage Engine : ").append(this.storageEngine);
            throw new OversizeMappingException(sb.toString());
        }
        this.evict(evictionIndex, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void tableExpansionFailure(int start, int length) {
        int evictionIndex = this.getEvictionIndex(start, length);
        if (evictionIndex >= 0) {
            this.evict(evictionIndex, false);
            return;
        }
        if (this.tryIncreaseReprobe()) {
            LOGGER.debug("Increased reprobe to {} slots for a {} slot table in a last ditch attempt to avoid storage failure.", (Object)this.getReprobeLength(), (Object)this.getTableCapacity());
            return;
        }
        StringBuilder sb = new StringBuilder("Table Expansion and Eviction Failed.\n");
        sb.append("Current Table Size (slots) : ").append(this.getTableCapacity()).append('\n');
        sb.append("Current Reprobe Length     : ").append(this.getReprobeLength()).append('\n');
        sb.append("Resize Will Require        : ").append(DebuggingUtils.toBase2SuffixedString(this.getTableCapacity() * 4L * 4L * 2L)).append("B\n");
        sb.append("Table Page Source          : ").append(this.tableSource);
        throw new OversizeMappingException(sb.toString());
    }

    @Override
    protected void hit(IntBuffer entry) {
        entry.put(0, Integer.MIN_VALUE | entry.get(0));
    }

    public int getEvictionIndex() {
        if (this.clockHand >= this.hashtable.capacity()) {
            this.clockHand = 0;
        }
        int initialHand = this.clockHand;
        int loops = 0;
        do {
            int hand;
            if ((this.clockHand += 4) + 0 >= this.hashtable.capacity()) {
                this.clockHand = 0;
            }
            if (this.evictable(hand = this.hashtable.get(this.clockHand + 0)) && (hand & Integer.MIN_VALUE) == 0) {
                return this.clockHand;
            }
            if ((hand & Integer.MIN_VALUE) != Integer.MIN_VALUE) continue;
            this.hashtable.put(this.clockHand + 0, hand & Integer.MAX_VALUE);
        } while (initialHand != this.clockHand || ++loops != 2);
        return -1;
    }

    private int getEvictionIndex(int start, int length) {
        int index = this.getEvictionIndex();
        int tableLength = this.hashtable.capacity();
        int probeLength = length * 4;
        if (probeLength >= this.hashtable.capacity()) {
            return index;
        }
        int end = start + probeLength & tableLength - 1;
        if (index < 0) {
            return index;
        }
        if (end > start && index >= start && index <= end) {
            return index;
        }
        if (end < start && (index >= start || index < end)) {
            return index;
        }
        this.evict(index, false);
        int clock = start;
        for (int i = 0; i < length; ++i) {
            int hand;
            if ((clock += 4) >= tableLength) {
                clock = start;
            }
            if (!this.evictable(hand = this.hashtable.get(clock + 0)) || (hand & Integer.MIN_VALUE) != 0) continue;
            return clock;
        }
        int lastEvictable = -1;
        int clock2 = start;
        for (int i = 0; i < this.rndm.nextInt(length) || lastEvictable < 0 && i < length; ++i) {
            int hand;
            if ((clock2 += 4) >= tableLength) {
                clock2 = start;
            }
            if (!this.evictable(hand = this.hashtable.get(clock2 + 0))) continue;
            lastEvictable = clock2;
        }
        return lastEvictable;
    }

    protected boolean evictable(int status) {
        return (status & 1) == 1 && (status & 0x40000000) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean evict(int index, boolean shrink) {
        Lock l = this.writeLock();
        l.lock();
        try {
            if (this.evictable(this.hashtable.get(index + 0))) {
                this.removeAtTableOffset(index, shrink);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public boolean isPinned(Object key) {
        Integer metadata = this.getMetadata(key, 0x40000000);
        return metadata != null && metadata != 0;
    }

    @Override
    public void setPinning(K key, boolean pinned) {
        if (pinned) {
            this.getAndSetMetadata((Object)key, 0x40000000, 0x40000000);
        } else {
            this.getAndSetMetadata((Object)key, 0x40000000, 0);
        }
    }

    @Override
    public V putPinned(K key, V value) {
        return this.put(key, value, 0x40000000);
    }

    @Override
    public V getAndPin(K key) {
        return this.getValueAndSetMetadata((Object)key, 0x40000000, 0x40000000);
    }
}

