/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.runners;

import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import org.apache.hadoop.shaded.org.mockito.internal.runners.RunnerImpl;
import org.apache.hadoop.shaded.org.mockito.internal.runners.util.RunnerProvider;
import org.apache.hadoop.shaded.org.mockito.internal.runners.util.TestMethodsFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunnerFactory {
    private final RunnerProvider runnerProvider;

    RunnerFactory(RunnerProvider runnerProvider) {
        this.runnerProvider = runnerProvider;
    }

    public RunnerFactory() {
        this(new RunnerProvider());
    }

    public RunnerImpl create(Class<?> klass) throws InvocationTargetException {
        try {
            if (this.runnerProvider.isJUnit45OrHigherAvailable()) {
                return this.runnerProvider.newInstance("org.apache.hadoop.shaded.org.mockito.internal.runners.JUnit45AndHigherRunnerImpl", klass);
            }
            return this.runnerProvider.newInstance("org.apache.hadoop.shaded.org.mockito.internal.runners.JUnit44RunnerImpl", klass);
        }
        catch (InvocationTargetException e) {
            if (!new TestMethodsFinder().hasTestMethods(klass)) {
                throw new MockitoException("\n\nNo tests found in " + klass.getSimpleName() + "\n" + "Haven't you forgot @Test annotation?\n", e);
            }
            throw e;
        }
        catch (Throwable t) {
            throw new MockitoException("\n\nMockitoRunner can only be used with JUnit 4.4 or higher.\nYou can upgrade your JUnit version or write your own Runner (please consider contributing your runner to the Mockito community).\nBear in mind that you can still enjoy all features of the framework without using runners (they are completely optional).\nIf you get this error despite using JUnit 4.4 or higher then please report this error to the mockito mailing list.\n", t);
        }
    }
}

