/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.protocol.proto.AliasMapProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.AliasMapProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMapProtocol;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.shaded.com.google.protobuf.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InMemoryAliasMapProtocolClientSideTranslatorPB
implements InMemoryAliasMapProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryAliasMapProtocolClientSideTranslatorPB.class);
    private AliasMapProtocolPB rpcProxy;

    public InMemoryAliasMapProtocolClientSideTranslatorPB(Configuration conf) {
        String addr = conf.getTrimmed("dfs.provided.aliasmap.inmemory.dnrpc-address", "0.0.0.0:50200");
        InetSocketAddress aliasMapAddr = NetUtils.createSocketAddr((String)addr);
        RPC.setProtocolEngine((Configuration)conf, AliasMapProtocolPB.class, ProtobufRpcEngine.class);
        LOG.info("Connecting to address: " + addr);
        try {
            this.rpcProxy = (AliasMapProtocolPB)RPC.getProxy(AliasMapProtocolPB.class, (long)RPC.getProtocolVersion(AliasMapProtocolPB.class), (InetSocketAddress)aliasMapAddr, null, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)0);
        }
        catch (IOException e) {
            throw new RuntimeException("Error in connecting to " + addr + " Got: " + e);
        }
    }

    @Override
    public InMemoryAliasMapProtocol.IterationResult list(Optional<Block> marker) throws IOException {
        AliasMapProtocolProtos.ListRequestProto.Builder builder = AliasMapProtocolProtos.ListRequestProto.newBuilder();
        if (marker.isPresent()) {
            builder.setMarker(PBHelperClient.convert((Block)marker.get()));
        }
        AliasMapProtocolProtos.ListRequestProto request = builder.build();
        try {
            AliasMapProtocolProtos.ListResponseProto response = this.rpcProxy.list(null, request);
            List<AliasMapProtocolProtos.KeyValueProto> fileRegionsList = response.getFileRegionsList();
            List<FileRegion> fileRegions = fileRegionsList.stream().map(kv -> new FileRegion(PBHelperClient.convert((HdfsProtos.BlockProto)kv.getKey()), PBHelperClient.convert((HdfsProtos.ProvidedStorageLocationProto)kv.getValue()))).collect(Collectors.toList());
            HdfsProtos.BlockProto nextMarker = response.getNextMarker();
            if (nextMarker.isInitialized()) {
                return new InMemoryAliasMapProtocol.IterationResult(fileRegions, Optional.of(PBHelperClient.convert((HdfsProtos.BlockProto)nextMarker)));
            }
            return new InMemoryAliasMapProtocol.IterationResult(fileRegions, Optional.empty());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    @Nonnull
    public Optional<ProvidedStorageLocation> read(@Nonnull Block block) throws IOException {
        AliasMapProtocolProtos.ReadRequestProto request = AliasMapProtocolProtos.ReadRequestProto.newBuilder().setKey(PBHelperClient.convert((Block)block)).build();
        try {
            AliasMapProtocolProtos.ReadResponseProto response = this.rpcProxy.read(null, request);
            HdfsProtos.ProvidedStorageLocationProto providedStorageLocation = response.getValue();
            if (providedStorageLocation.isInitialized()) {
                return Optional.of(PBHelperClient.convert((HdfsProtos.ProvidedStorageLocationProto)providedStorageLocation));
            }
            return Optional.empty();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void write(@Nonnull Block block, @Nonnull ProvidedStorageLocation providedStorageLocation) throws IOException {
        AliasMapProtocolProtos.WriteRequestProto request = AliasMapProtocolProtos.WriteRequestProto.newBuilder().setKeyValuePair(AliasMapProtocolProtos.KeyValueProto.newBuilder().setKey(PBHelperClient.convert((Block)block)).setValue(PBHelperClient.convert((ProvidedStorageLocation)providedStorageLocation)).build()).build();
        try {
            this.rpcProxy.write(null, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public String getBlockPoolId() throws IOException {
        try {
            AliasMapProtocolProtos.BlockPoolResponseProto response = this.rpcProxy.getBlockPoolId(null, AliasMapProtocolProtos.BlockPoolRequestProto.newBuilder().build());
            return response.getBlockPoolId();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    public void stop() {
        RPC.stopProxy((Object)this.rpcProxy);
    }
}

