/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.api;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.flume.FlumeException;
import org.apache.flume.api.AbstractRpcClient;
import org.apache.flume.util.SSLUtil;

public abstract class SSLContextAwareAbstractRpcClient
extends AbstractRpcClient {
    protected boolean enableSsl;
    protected boolean trustAllCerts;
    protected String truststore;
    protected String truststorePassword;
    protected String truststoreType;
    protected final Set<String> excludeProtocols = new LinkedHashSet<String>(Arrays.asList("SSLv3"));
    protected final Set<String> includeProtocols = new LinkedHashSet<String>(Arrays.asList("TLSv1.2"));
    protected final Set<String> excludeCipherSuites = new LinkedHashSet<String>();
    protected final Set<String> includeCipherSuites = new LinkedHashSet<String>();

    protected void configureSSL(Properties properties) throws FlumeException {
        this.enableSsl = Boolean.parseBoolean(properties.getProperty("ssl"));
        this.trustAllCerts = Boolean.parseBoolean(properties.getProperty("trust-all-certs"));
        this.truststore = properties.getProperty("truststore", SSLUtil.getGlobalTruststorePath());
        this.truststorePassword = properties.getProperty("truststore-password", SSLUtil.getGlobalTruststorePassword());
        this.truststoreType = properties.getProperty("truststore-type", SSLUtil.getGlobalTruststoreType("JKS"));
        this.parseList(properties.getProperty("exclude-protocols", SSLUtil.getGlobalExcludeProtocols()), this.excludeProtocols);
        this.parseList(properties.getProperty("include-protocols", SSLUtil.getGlobalIncludeProtocols()), this.includeProtocols);
        this.parseList(properties.getProperty("exclude-cipher-suites", SSLUtil.getGlobalExcludeCipherSuites()), this.excludeCipherSuites);
        this.parseList(properties.getProperty("include-cipher-suites", SSLUtil.getGlobalIncludeCipherSuites()), this.includeCipherSuites);
    }

    private void parseList(String value, Set<String> set) {
        if (Objects.nonNull(value)) {
            set.addAll(Arrays.asList(value.split(" ")));
        }
    }
}

