/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.avro.file.Codec;
import org.apache.avro.file.CodecFactory;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ZstandardCodec
extends Codec {
    private ByteArrayOutputStream outputBuffer;

    @Override
    public String getName() {
        return "zstandard";
    }

    @Override
    public ByteBuffer compress(ByteBuffer uncompressedData) throws IOException {
        ByteArrayOutputStream baos = this.getOutputBuffer(uncompressedData.remaining());
        ZstdCompressorOutputStream outputStream = new ZstdCompressorOutputStream(baos);
        this.writeAndClose(uncompressedData, outputStream);
        return ByteBuffer.wrap(baos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer decompress(ByteBuffer compressedData) throws IOException {
        ByteArrayOutputStream baos = this.getOutputBuffer(compressedData.remaining());
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(compressedData.array(), compressedData.arrayOffset() + compressedData.position(), compressedData.remaining());
        try (ZstdCompressorInputStream ios = new ZstdCompressorInputStream(bytesIn);){
            IOUtils.copy(ios, baos);
        }
        return ByteBuffer.wrap(baos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndClose(ByteBuffer data, OutputStream to) throws IOException {
        byte[] input = data.array();
        int offset = data.arrayOffset() + data.position();
        int length = data.remaining();
        try {
            to.write(input, offset, length);
        }
        finally {
            to.close();
        }
    }

    private ByteArrayOutputStream getOutputBuffer(int suggestedLength) {
        if (this.outputBuffer == null) {
            this.outputBuffer = new ByteArrayOutputStream(suggestedLength);
        }
        this.outputBuffer.reset();
        return this.outputBuffer;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && obj.getClass() == this.getClass();
    }

    static class Option
    extends CodecFactory {
        Option() {
        }

        @Override
        protected Codec createInstance() {
            return new ZstandardCodec();
        }
    }
}

