/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.netty4.io.netty.handler.codec.http;

import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpObjectEncoder;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;

public class HttpResponseEncoder
extends HttpObjectEncoder<HttpResponse> {
    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return super.acceptOutboundMessage(msg) && !(msg instanceof HttpRequest);
    }

    @Override
    protected void encodeInitialLine(ByteBuf buf, HttpResponse response) throws Exception {
        response.getProtocolVersion().encode(buf);
        buf.writeByte(32);
        response.getStatus().encode(buf);
        buf.writeBytes(CRLF);
    }

    @Override
    protected void sanitizeHeadersBeforeEncode(HttpResponse msg, boolean isAlwaysEmpty) {
        int status;
        if (isAlwaysEmpty && ((status = msg.getStatus().code()) >= 100 && status <= 199 || status == HttpResponseStatus.NO_CONTENT.code())) {
            msg.headers().remove("Content-Length");
            msg.headers().remove("Transfer-Encoding");
        }
    }

    @Override
    protected boolean isContentAlwaysEmpty(HttpResponse msg) {
        int status = msg.getStatus().code();
        if (status >= 100 && status <= 199) {
            if (status == HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
                return msg.headers().contains("Sec-WebSocket-Version");
            }
            return true;
        }
        return status == HttpResponseStatus.NO_CONTENT.code() || status == HttpResponseStatus.NOT_MODIFIED.code();
    }
}

