/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.core;

import java.util.ArrayList;
import java.util.List;
import jline.console.completer.Completer;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.JLineLogHandler;
import org.springframework.shell.core.Parser;
import org.springframework.util.Assert;

public class ParserCompleter
implements Completer {
    private final Parser parser;

    public ParserCompleter(Parser parser) {
        Assert.notNull(parser, "Parser required");
        this.parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int complete(String buffer, int cursor, List candidates) {
        int result;
        try {
            JLineLogHandler.cancelRedrawProhibition();
            ArrayList<Completion> completions = new ArrayList<Completion>();
            result = this.parser.completeAdvanced(buffer, cursor, completions);
            for (Completion completion : completions) {
                candidates.add(completion.getValue());
            }
        }
        finally {
            JLineLogHandler.prohibitRedraw();
        }
        return result;
    }
}

