/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SimpleTrigger;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Constants;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class SimpleTriggerFactoryBean
implements FactoryBean<SimpleTrigger>,
BeanNameAware,
InitializingBean {
    private static final Constants constants = new Constants(SimpleTrigger.class);
    private String name;
    private String group;
    private JobDetail jobDetail;
    private JobDataMap jobDataMap = new JobDataMap();
    private Date startTime;
    private long startDelay;
    private long repeatInterval;
    private int repeatCount = -1;
    private int priority;
    private int misfireInstruction;
    private String description;
    private String beanName;
    private SimpleTrigger simpleTrigger;

    public void setName(String name) {
        this.name = name;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setJobDetail(JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }

    public void setJobDataMap(JobDataMap jobDataMap) {
        this.jobDataMap = jobDataMap;
    }

    public JobDataMap getJobDataMap() {
        return this.jobDataMap;
    }

    public void setJobDataAsMap(Map<String, ?> jobDataAsMap) {
        this.jobDataMap.putAll(jobDataAsMap);
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setStartDelay(long startDelay) {
        Assert.isTrue(startDelay >= 0L, "Start delay cannot be negative");
        this.startDelay = startDelay;
    }

    public void setRepeatInterval(long repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setMisfireInstruction(int misfireInstruction) {
        this.misfireInstruction = misfireInstruction;
    }

    public void setMisfireInstructionName(String constantName) {
        this.misfireInstruction = constants.asNumber(constantName).intValue();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public void afterPropertiesSet() {
        Method jobKeyMethod;
        Class simpleTriggerClass;
        if (this.name == null) {
            this.name = this.beanName;
        }
        if (this.group == null) {
            this.group = "DEFAULT";
        }
        if (this.jobDetail != null) {
            this.jobDataMap.put((Object)"jobDetail", (Object)this.jobDetail);
        }
        if (this.startDelay > 0L || this.startTime == null) {
            this.startTime = new Date(System.currentTimeMillis() + this.startDelay);
        }
        try {
            simpleTriggerClass = this.getClass().getClassLoader().loadClass("org.quartz.impl.triggers.SimpleTriggerImpl");
            jobKeyMethod = JobDetail.class.getMethod("getKey", new Class[0]);
        }
        catch (ClassNotFoundException ex) {
            simpleTriggerClass = SimpleTrigger.class;
            jobKeyMethod = null;
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Incompatible Quartz version");
        }
        BeanWrapperImpl bw = new BeanWrapperImpl(simpleTriggerClass);
        MutablePropertyValues pvs = new MutablePropertyValues();
        pvs.add("name", this.name);
        pvs.add("group", this.group);
        if (jobKeyMethod != null) {
            pvs.add("jobKey", ReflectionUtils.invokeMethod(jobKeyMethod, this.jobDetail));
        } else {
            pvs.add("jobName", this.jobDetail.getName());
            pvs.add("jobGroup", this.jobDetail.getGroup());
        }
        pvs.add("jobDataMap", this.jobDataMap);
        pvs.add("startTime", this.startTime);
        pvs.add("repeatInterval", this.repeatInterval);
        pvs.add("repeatCount", this.repeatCount);
        pvs.add("priority", this.priority);
        pvs.add("misfireInstruction", this.misfireInstruction);
        pvs.add("description", this.description);
        bw.setPropertyValues(pvs);
        this.simpleTrigger = (SimpleTrigger)bw.getWrappedInstance();
    }

    @Override
    public SimpleTrigger getObject() {
        return this.simpleTrigger;
    }

    @Override
    public Class<?> getObjectType() {
        return SimpleTrigger.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

