/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.util;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.falcon.FalconException;
import org.apache.falcon.hadoop.HadoopClientFactory;
import org.apache.falcon.util.ApplicationProperties;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StartupProperties
extends ApplicationProperties {
    public static final String SAFEMODE_PROPERTY = "falcon.safeMode";
    private static final String SAFEMODE_FILE = ".safemode";
    private static final String CONFIGSTORE_PROPERTY = "config.store.uri";
    private static FileSystem fileSystem;
    private static Path storePath;
    private static final Pattern WINDOWS_URI_PATTERN;
    static final boolean WINDOWS;
    private static final String FILE_SCHEME = "file://";
    private static final String PROPERTY_FILE = "startup.properties";
    private static final Logger LOG;
    private static final AtomicReference<StartupProperties> INSTANCE;

    private StartupProperties() throws FalconException {
        StartupProperties.fixWindowsUris(this);
    }

    static void fixWindowsUris(Properties properties) {
        if (!WINDOWS) {
            return;
        }
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String value = (String)entry.getValue();
            if (!WINDOWS_URI_PATTERN.matcher(value).find()) continue;
            String newValue = "file:///" + value.substring(FILE_SCHEME.length()).replace("\\", "/");
            properties.setProperty((String)entry.getKey(), newValue);
        }
    }

    @Override
    protected String getPropertyFile() {
        return PROPERTY_FILE;
    }

    public static Properties get() {
        try {
            if (INSTANCE.get() == null) {
                INSTANCE.compareAndSet(null, new StartupProperties());
                storePath = new Path(INSTANCE.get().getProperty(CONFIGSTORE_PROPERTY));
                fileSystem = HadoopClientFactory.get().createFalconFileSystem(storePath.toUri());
                String isSafeMode = StartupProperties.doesSafemodeFileExist() ? "true" : "false";
                LOG.info("Initializing Falcon StartupProperties with safemode set to {}.", (Object)isSafeMode);
                INSTANCE.get().setProperty(SAFEMODE_PROPERTY, isSafeMode);
            }
            return INSTANCE.get();
        }
        catch (FalconException e) {
            throw new RuntimeException("Unable to read application startup properties", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to verify Falcon safemode", e);
        }
    }

    public static void createSafemodeFile() throws IOException {
        boolean success;
        Path safemodeFilePath = StartupProperties.getSafemodeFilePath();
        if (!StartupProperties.doesSafemodeFileExist() && !(success = fileSystem.createNewFile(safemodeFilePath))) {
            LOG.error("Failed to create safemode file at {}", (Object)safemodeFilePath.toUri());
            throw new IOException("Failed to create safemode file at " + safemodeFilePath.toUri());
        }
        INSTANCE.get().setProperty(SAFEMODE_PROPERTY, "true");
    }

    public static boolean deleteSafemodeFile() throws IOException {
        INSTANCE.get().setProperty(SAFEMODE_PROPERTY, "false");
        return !StartupProperties.doesSafemodeFileExist() || fileSystem.delete(StartupProperties.getSafemodeFilePath(), true);
    }

    public static boolean doesSafemodeFileExist() throws IOException {
        return fileSystem.exists(StartupProperties.getSafemodeFilePath());
    }

    private static Path getSafemodeFilePath() {
        return new Path(storePath, SAFEMODE_FILE);
    }

    public static boolean isServerInSafeMode() {
        return Boolean.parseBoolean(StartupProperties.get().getProperty(SAFEMODE_PROPERTY, "false"));
    }

    static {
        WINDOWS_URI_PATTERN = Pattern.compile("^file://[a-zA-Z]:");
        WINDOWS = System.getProperty("os.name").startsWith("Windows");
        LOG = LoggerFactory.getLogger(StartupProperties.class);
        INSTANCE = new AtomicReference();
    }
}

