/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.util;

import java.awt.Dimension;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.falcon.monitors.Alert;
import org.apache.falcon.monitors.Monitored;
import org.apache.falcon.monitors.TimeTaken;

public final class ResourcesReflectionUtil {
    private static final Map<String, MethodAnnotation> METHODS = new HashMap<String, MethodAnnotation>();

    private ResourcesReflectionUtil() {
    }

    public static Map<Integer, String> getResourceDimensionsName(String methodName) {
        return METHODS.get(methodName) != null ? Collections.unmodifiableMap(METHODS.get(methodName).params) : null;
    }

    public static String getResourceMonitorName(String methodName) {
        return METHODS.get(methodName) != null ? METHODS.get(methodName).monitoredName : null;
    }

    public static Integer getResourceTimeTakenName(String methodName) {
        return METHODS.get(methodName) != null ? METHODS.get(methodName).timeTakenArgIndex : null;
    }

    private static void buildAnnotationsMapForClass(String className) {
        Method[] declMethods;
        Class<?> clazz;
        try {
            clazz = ResourcesReflectionUtil.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load class " + className, e);
        }
        for (Method declMethod : declMethods = clazz.getMethods()) {
            Annotation[] methodAnnots;
            for (Annotation methodAnnot : methodAnnots = declMethod.getDeclaredAnnotations()) {
                String simpleName = methodAnnot.annotationType().getSimpleName();
                if (!simpleName.equals(Monitored.class.getSimpleName()) && !simpleName.equals(Alert.class.getSimpleName())) continue;
                MethodAnnotation annotation = new MethodAnnotation();
                annotation.monitoredName = ResourcesReflectionUtil.getAnnotationValue(methodAnnot, "event");
                Annotation[][] paramAnnots = declMethod.getParameterAnnotations();
                annotation.params = ResourcesReflectionUtil.getDeclaredParamAnnots(paramAnnots, annotation);
                METHODS.put(clazz.getSimpleName() + "." + declMethod.getName(), annotation);
            }
        }
    }

    private static Map<Integer, String> getDeclaredParamAnnots(Annotation[][] paramAnnots, MethodAnnotation annotation) {
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        for (int i = 0; i < paramAnnots.length; ++i) {
            for (int j = 0; j < paramAnnots[i].length; ++j) {
                if (paramAnnots[i][j].annotationType().getSimpleName().equals(Dimension.class.getSimpleName())) {
                    params.put(i, ResourcesReflectionUtil.getAnnotationValue(paramAnnots[i][j], "value"));
                }
                if (!paramAnnots[i][j].annotationType().getSimpleName().equals(TimeTaken.class.getSimpleName())) continue;
                annotation.timeTakenArgIndex = i;
            }
        }
        return params;
    }

    private static String getAnnotationValue(Annotation annotation, String attributeName) {
        String value = null;
        if (annotation != null) {
            try {
                value = (String)annotation.annotationType().getMethod(attributeName, new Class[0]).invoke((Object)annotation, new Object[0]);
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
        }
        return value;
    }

    static {
        ResourcesReflectionUtil.buildAnnotationsMapForClass("org.apache.falcon.resource.proxy.SchedulableEntityManagerProxy");
        ResourcesReflectionUtil.buildAnnotationsMapForClass("org.apache.falcon.resource.proxy.InstanceManagerProxy");
        ResourcesReflectionUtil.buildAnnotationsMapForClass("org.apache.falcon.resource.AbstractInstanceManager");
        ResourcesReflectionUtil.buildAnnotationsMapForClass("org.apache.falcon.messaging.JMSMessageConsumer");
        ResourcesReflectionUtil.buildAnnotationsMapForClass("org.apache.falcon.aspect.GenericAlert");
    }

    public static class MethodAnnotation {
        private String monitoredName;
        private Map<Integer, String> params = new HashMap<Integer, String>();
        private Integer timeTakenArgIndex;

        public String toString() {
            return "{" + this.monitoredName + "[" + this.params.toString() + "]}";
        }
    }
}

