/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.util;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public final class FSDRUtils {
    private static final List<String> HDFS_SCHEME_PREFIXES = Arrays.asList("file", "hdfs", "hftp", "hsftp", "webhdfs", "swebhdfs");
    private static Configuration defaultConf = new Configuration();

    private FSDRUtils() {
    }

    public static Configuration getDefaultConf() {
        return defaultConf;
    }

    public static void setDefaultConf(Configuration conf) {
        defaultConf = conf;
    }

    public static boolean isHCFS(Path filePath) throws FalconException {
        String scheme;
        if (filePath == null) {
            throw new FalconException("filePath cannot be empty");
        }
        try {
            FileSystem f = FileSystem.get((URI)filePath.toUri(), (Configuration)FSDRUtils.getDefaultConf());
            scheme = f.getScheme();
            if (StringUtils.isBlank(scheme)) {
                throw new FalconException("Cannot get valid scheme for " + filePath);
            }
        }
        catch (IOException e) {
            throw new FalconException(e);
        }
        return !HDFS_SCHEME_PREFIXES.contains(scheme.toLowerCase().trim());
    }
}

