/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.util;

import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.hadoop.HadoopClientFactory;
import org.apache.falcon.util.ReplicationDistCpOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.DistCpOptions;

public final class DistCPOptionsUtil {
    private static final String TDE_ENCRYPTION_ENABLED = "tdeEncryptionEnabled";

    private DistCPOptionsUtil() {
    }

    public static DistCpOptions getDistCpOptions(CommandLine cmd, List<Path> sourcePaths, Path targetPath, boolean isSnapshot, String replicatedSnapshotName, String currentSnapshotName, Configuration conf) throws FalconException, IOException {
        String preserveTimes;
        String preserveXattr;
        String preserveAcl;
        String preserveChecksumType;
        String preserveGroup;
        String preserveUser;
        String preservePermission;
        String preserveReplicationCount;
        String preserveBlockSize;
        String ignoreErrors;
        DistCpOptions distcpOptions = new DistCpOptions(sourcePaths, targetPath);
        distcpOptions.setBlocking(true);
        distcpOptions.setMaxMaps(Integer.parseInt(cmd.getOptionValue("maxMaps")));
        distcpOptions.setMapBandwidth(Integer.parseInt(cmd.getOptionValue("mapBandwidth")));
        String tdeEncryptionEnabled = cmd.getOptionValue(TDE_ENCRYPTION_ENABLED);
        if (StringUtils.isNotBlank(tdeEncryptionEnabled) && tdeEncryptionEnabled.equalsIgnoreCase(Boolean.TRUE.toString())) {
            distcpOptions.setSyncFolder(true);
            distcpOptions.setSkipCRC(true);
        } else {
            String skipChecksum;
            if (!isSnapshot) {
                String overwrite = cmd.getOptionValue(ReplicationDistCpOption.DISTCP_OPTION_OVERWRITE.getName());
                if (StringUtils.isNotEmpty(overwrite) && overwrite.equalsIgnoreCase(Boolean.TRUE.toString())) {
                    distcpOptions.setOverwrite(Boolean.parseBoolean(overwrite));
                } else {
                    distcpOptions.setSyncFolder(true);
                }
            }
            if (StringUtils.isNotEmpty(skipChecksum = cmd.getOptionValue(ReplicationDistCpOption.DISTCP_OPTION_SKIP_CHECKSUM.getName()))) {
                distcpOptions.setSkipCRC(Boolean.parseBoolean(skipChecksum));
            }
        }
        if (isSnapshot) {
            distcpOptions.setSyncFolder(true);
            distcpOptions.setDeleteMissing(true);
        } else {
            FileSystem fs;
            String removeDeletedFiles = cmd.getOptionValue(ReplicationDistCpOption.DISTCP_OPTION_REMOVE_DELETED_FILES.getName(), "true");
            boolean deleteMissing = Boolean.parseBoolean(removeDeletedFiles);
            distcpOptions.setDeleteMissing(deleteMissing);
            if (deleteMissing && !(fs = HadoopClientFactory.get().createProxiedFileSystem(targetPath.toUri(), conf)).exists(targetPath)) {
                fs.mkdirs(targetPath);
            }
        }
        if (isSnapshot && StringUtils.isNotBlank(replicatedSnapshotName)) {
            distcpOptions.setUseDiff(true, replicatedSnapshotName, currentSnapshotName);
        }
        if (StringUtils.isNotBlank(ignoreErrors = cmd.getOptionValue(ReplicationDistCpOption.DISTCP_OPTION_IGNORE_ERRORS.getName()))) {
            distcpOptions.setIgnoreFailures(Boolean.parseBoolean(ignoreErrors));
        }
        if (StringUtils.isNotBlank(preserveBlockSize = cmd.getOptionValue(ReplicationDistCpOption.DISTCP_OPTION_PRESERVE_BLOCK_SIZE.getName())) && Boolean.parseBoolean(preserveBlockSize)) {
            distcpOptions.preserve(DistCpOptions.FileAttribute.BLOCKSIZE);
        }
        if (StringUtils.isNotBlank(preserveReplicationCount = cmd.getOptionValue(ReplicationDistCpOption.DISTCP_OPTION_PRESERVE_REPLICATION_NUMBER.getName())) && Boolean.parseBoolean(preserveReplicationCount)) {
            distcpOptions.preserve(DistCpOptions.FileAttribute.REPLICATION);
        }
        if (StringUtils.isNotBlank(preservePermission = cmd.getOptionValue(ReplicationDistCpOption.DISTCP_OPTION_PRESERVE_PERMISSIONS.getName())) && Boolean.parseBoolean(preservePermission)) {
            distcpOptions.preserve(DistCpOptions.FileAttribute.PERMISSION);
        }
        if (StringUtils.isNotBlank(preserveUser = cmd.getOptionValue(ReplicationDistCpOption.DISTCP_OPTION_PRESERVE_USER.getName())) && Boolean.parseBoolean(preserveUser)) {
            distcpOptions.preserve(DistCpOptions.FileAttribute.USER);
        }
        if (StringUtils.isNotBlank(preserveGroup = cmd.getOptionValue(ReplicationDistCpOption.DISTCP_OPTION_PRESERVE_GROUP.getName())) && Boolean.parseBoolean(preserveGroup)) {
            distcpOptions.preserve(DistCpOptions.FileAttribute.GROUP);
        }
        if (StringUtils.isNotBlank(preserveChecksumType = cmd.getOptionValue(ReplicationDistCpOption.DISTCP_OPTION_PRESERVE_CHECKSUM_TYPE.getName())) && Boolean.parseBoolean(preserveChecksumType)) {
            distcpOptions.preserve(DistCpOptions.FileAttribute.CHECKSUMTYPE);
        }
        if (StringUtils.isNotBlank(preserveAcl = cmd.getOptionValue(ReplicationDistCpOption.DISTCP_OPTION_PRESERVE_ACL.getName())) && Boolean.parseBoolean(preserveAcl)) {
            distcpOptions.preserve(DistCpOptions.FileAttribute.ACL);
        }
        if (StringUtils.isNotBlank(preserveXattr = cmd.getOptionValue(ReplicationDistCpOption.DISTCP_OPTION_PRESERVE_XATTR.getName())) && Boolean.parseBoolean(preserveXattr)) {
            distcpOptions.preserve(DistCpOptions.FileAttribute.XATTR);
        }
        if (StringUtils.isNotBlank(preserveTimes = cmd.getOptionValue(ReplicationDistCpOption.DISTCP_OPTION_PRESERVE_TIMES.getName())) && Boolean.parseBoolean(preserveTimes)) {
            distcpOptions.preserve(DistCpOptions.FileAttribute.TIMES);
        }
        return distcpOptions;
    }
}

