/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.service;

import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.service.FalconService;
import org.apache.falcon.service.GroupsService;
import org.apache.falcon.service.Services;
import org.apache.falcon.util.RuntimeProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUserService
implements FalconService {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyUserService.class);
    private Map<String, Set<String>> proxyUserHosts = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> proxyUserGroups = new HashMap<String, Set<String>>();
    private static final String CONF_PREFIX = "falcon.service.ProxyUserService.proxyuser.";
    private static final String GROUPS = ".groups";
    private static final String HOSTS = ".hosts";
    public static final String SERVICE_NAME = ProxyUserService.class.getSimpleName();

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    @Override
    public void init() throws FalconException {
        Set<Map.Entry<Object, Object>> entrySet = RuntimeProperties.get().entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            HashSet<String> values;
            String value;
            String proxyUser;
            String key = (String)entry.getKey();
            if (key.startsWith(CONF_PREFIX) && key.endsWith(GROUPS)) {
                proxyUser = key.substring(0, key.lastIndexOf(GROUPS));
                if (RuntimeProperties.get().getProperty(proxyUser + HOSTS) == null) {
                    throw new FalconException(proxyUser + HOSTS + " property not set in runtime properties. Please add it.");
                }
                proxyUser = proxyUser.substring(CONF_PREFIX.length());
                value = ((String)entry.getValue()).trim();
                LOG.info("Loading proxyuser settings [{}]=[{}]", (Object)key, (Object)value);
                values = null;
                if (!value.equals("*")) {
                    values = new HashSet<String>(Arrays.asList(value.split(",")));
                }
                this.proxyUserGroups.put(proxyUser, values);
            }
            if (!key.startsWith(CONF_PREFIX) || !key.endsWith(HOSTS)) continue;
            proxyUser = key.substring(0, key.lastIndexOf(HOSTS));
            if (RuntimeProperties.get().getProperty(proxyUser + GROUPS) == null) {
                throw new FalconException(proxyUser + GROUPS + " property not set in runtime properties. Please add it.");
            }
            proxyUser = proxyUser.substring(CONF_PREFIX.length());
            value = ((String)entry.getValue()).trim();
            LOG.info("Loading proxyuser settings [{}]=[{}]", (Object)key, (Object)value);
            values = null;
            if (!value.equals("*")) {
                String[] hosts = value.split(",");
                for (int i = 0; i < hosts.length; ++i) {
                    String hostName = hosts[i];
                    try {
                        hosts[i] = this.normalizeHostname(hostName);
                    }
                    catch (Exception ex) {
                        throw new FalconException("Exception normalizing host name: " + hostName + "." + ex.getMessage(), ex);
                    }
                    LOG.info("Hostname, original [{}], normalized [{}]", (Object)hostName, (Object)hosts[i]);
                }
                values = new HashSet<String>(Arrays.asList(hosts));
            }
            this.proxyUserHosts.put(proxyUser, values);
        }
    }

    public void validate(String proxyUser, String proxyHost, String doAsUser) throws IOException {
        ProxyUserService.validateNotEmpty(proxyUser, "proxyUser", "If you're attempting to use user-impersonation via a proxy user, please make sure that falcon.service.ProxyUserService.proxyuser.#USER#.hosts and falcon.service.ProxyUserService.proxyuser.#USER#.groups are configured correctly");
        ProxyUserService.validateNotEmpty(proxyHost, "proxyHost", "If you're attempting to use user-impersonation via a proxy user, please make sure that falcon.service.ProxyUserService.proxyuser." + proxyUser + ".hosts and falcon.service.ProxyUserService.proxyuser." + proxyUser + ".groups are configured correctly");
        ProxyUserService.validateNotEmpty(doAsUser, "doAsUser", null);
        LOG.debug("Authorization check proxyuser [{}] host [{}] doAs [{}]", new Object[]{proxyUser, proxyHost, doAsUser});
        if (!this.proxyUserHosts.containsKey(proxyUser)) {
            throw new AccessControlException(MessageFormat.format("User [{0}] not defined as proxyuser. Please add it to runtime properties.", proxyUser));
        }
        this.validateRequestorHost(proxyUser, proxyHost, this.proxyUserHosts.get(proxyUser));
        this.validateGroup(proxyUser, doAsUser, this.proxyUserGroups.get(proxyUser));
    }

    private void validateRequestorHost(String proxyUser, String hostname, Set<String> validHosts) throws IOException {
        if (validHosts != null && !validHosts.contains(hostname) && !validHosts.contains(this.normalizeHostname(hostname))) {
            throw new AccessControlException(MessageFormat.format("Unauthorized host [{0}] for proxyuser [{1}]", hostname, proxyUser));
        }
    }

    private void validateGroup(String proxyUser, String user, Set<String> validGroups) throws IOException {
        if (validGroups != null) {
            List<String> userGroups = ((GroupsService)Services.get().getService(GroupsService.SERVICE_NAME)).getGroups(user);
            for (String g : validGroups) {
                if (!userGroups.contains(g)) continue;
                return;
            }
            throw new AccessControlException(MessageFormat.format("Unauthorized proxyuser [{0}] for user [{1}], not in proxyuser groups", proxyUser, user));
        }
    }

    private String normalizeHostname(String name) {
        try {
            InetAddress address = InetAddress.getByName(name);
            return address.getCanonicalHostName();
        }
        catch (IOException ex) {
            throw new AccessControlException(MessageFormat.format("Could not resolve host [{0}], [{1}]", name, ex.getMessage()));
        }
    }

    private static void validateNotEmpty(String str, String name, String info) {
        if (StringUtils.isBlank(str)) {
            throw new IllegalArgumentException(name + " cannot be null or empty" + (info == null ? "" : ", " + info));
        }
    }

    @Override
    public void destroy() {
    }
}

