/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.service;

import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.lang.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.persistence.EntityBean;
import org.apache.falcon.persistence.InstanceBean;
import org.apache.falcon.service.FalconService;
import org.apache.falcon.util.StateStoreProperties;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FalconJPAService
implements FalconService {
    private static final Logger LOG = LoggerFactory.getLogger(FalconJPAService.class);
    public static final String PREFIX = "falcon.statestore.";
    public static final String DB_SCHEMA = "falcon.statestore.schema.name";
    public static final String URL = "falcon.statestore.jdbc.url";
    public static final String DRIVER = "falcon.statestore.jdbc.driver";
    public static final String USERNAME = "falcon.statestore.jdbc.username";
    public static final String PASSWORD = "falcon.statestore.jdbc.password";
    public static final String CONN_DATA_SOURCE = "falcon.statestore.connection.data.source";
    public static final String CONN_PROPERTIES = "falcon.statestore.connection.properties";
    public static final String MAX_ACTIVE_CONN = "falcon.statestore.pool.max.active.conn";
    public static final String CREATE_DB_SCHEMA = "falcon.statestore.create.db.schema";
    public static final String VALIDATE_DB_CONN = "falcon.statestore.validate.db.connection";
    public static final String VALIDATE_DB_CONN_EVICTION_INTERVAL = "falcon.statestore.validate.db.connection.eviction.interval";
    public static final String VALIDATE_DB_CONN_EVICTION_NUM = "falcon.statestore.validate.db.connection.eviction.num";
    private EntityManagerFactory entityManagerFactory;
    private String persistenceUnit;
    private static final FalconJPAService FALCON_JPA_SERVICE = new FalconJPAService();

    private FalconJPAService() {
    }

    public static FalconJPAService get() {
        return FALCON_JPA_SERVICE;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setPersistenceUnit(String dbType) {
        if (StringUtils.isEmpty((String)dbType)) {
            throw new IllegalArgumentException(" DB type cannot be null or empty");
        }
        dbType = dbType.split(":")[0];
        this.persistenceUnit = "falcon-" + dbType;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void init() throws FalconException {
        Properties props = this.getPropsforStore();
        this.entityManagerFactory = Persistence.createEntityManagerFactory((String)this.persistenceUnit, (Map)props);
        EntityManager entityManager = this.getEntityManager();
        entityManager.find(EntityBean.class, (Object)1);
        entityManager.find(InstanceBean.class, (Object)1);
        LOG.info("All entities initialized");
        entityManager.getTransaction().begin();
        OpenJPAEntityManagerFactorySPI spi = (OpenJPAEntityManagerFactorySPI)this.entityManagerFactory;
        String logMsg = spi.getConfiguration().getConnectionProperties().replaceAll("Password=.*?,", "Password=***,");
        LOG.info("JPA configuration: {0}", (Object)logMsg);
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    private Properties getPropsforStore() throws FalconException {
        String dbSchema = StateStoreProperties.get().getProperty(DB_SCHEMA);
        String url = StateStoreProperties.get().getProperty(URL);
        String driver = StateStoreProperties.get().getProperty(DRIVER);
        String user = StateStoreProperties.get().getProperty(USERNAME);
        String password = StateStoreProperties.get().getProperty(PASSWORD).trim();
        String maxConn = StateStoreProperties.get().getProperty(MAX_ACTIVE_CONN).trim();
        String dataSource = StateStoreProperties.get().getProperty(CONN_DATA_SOURCE);
        String connPropsConfig = StateStoreProperties.get().getProperty(CONN_PROPERTIES);
        boolean autoSchemaCreation = Boolean.parseBoolean(StateStoreProperties.get().getProperty(CREATE_DB_SCHEMA, "false"));
        boolean validateDbConn = Boolean.parseBoolean(StateStoreProperties.get().getProperty(VALIDATE_DB_CONN, "true"));
        String evictionInterval = StateStoreProperties.get().getProperty(VALIDATE_DB_CONN_EVICTION_INTERVAL).trim();
        String evictionNum = StateStoreProperties.get().getProperty(VALIDATE_DB_CONN_EVICTION_NUM).trim();
        if (!url.startsWith("jdbc:")) {
            throw new FalconException("invalid JDBC URL, must start with 'jdbc:'" + url);
        }
        String dbType = url.substring("jdbc:".length());
        if (dbType.indexOf(":") <= 0) {
            throw new FalconException("invalid JDBC URL, missing vendor 'jdbc:[VENDOR]:...'" + url);
        }
        this.setPersistenceUnit(dbType);
        String connProps = "DriverClassName={0},Url={1},Username={2},Password={3},MaxActive={4}";
        connProps = MessageFormat.format(connProps, driver, url, user, password, maxConn);
        Properties props = new Properties();
        if (autoSchemaCreation) {
            connProps = connProps + ",TestOnBorrow=false,TestOnReturn=false,TestWhileIdle=false";
            props.setProperty("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        } else if (validateDbConn) {
            String interval = "timeBetweenEvictionRunsMillis=" + evictionInterval;
            String num = "numTestsPerEvictionRun=" + evictionNum;
            connProps = connProps + ",TestOnBorrow=true,TestOnReturn=true,TestWhileIdle=true," + interval + "," + num;
            connProps = connProps + ",ValidationQuery=select 1";
            connProps = MessageFormat.format(connProps, dbSchema);
        } else {
            connProps = connProps + ",TestOnBorrow=false,TestOnReturn=false,TestWhileIdle=false";
        }
        if (connPropsConfig != null) {
            connProps = connProps + "," + connPropsConfig;
        }
        props.setProperty("openjpa.ConnectionProperties", connProps);
        props.setProperty("openjpa.ConnectionDriverName", dataSource);
        return props;
    }

    @Override
    public void destroy() throws FalconException {
        if (this.entityManagerFactory.isOpen()) {
            this.entityManagerFactory.close();
        }
    }

    public EntityManager getEntityManager() {
        return this.getEntityManagerFactory().createEntityManager();
    }
}

