/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.resource;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.process.Input;
import org.apache.falcon.entity.v0.process.Output;
import org.apache.falcon.entity.v0.process.Process;

@XmlRootElement(name="entities")
@XmlAccessorType(value=XmlAccessType.FIELD)
@SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class EntityList {
    public static final String INPUT_TAG = "Input";
    public static final String OUTPUT_TAG = "Output";
    @XmlElement
    private int totalResults;
    @XmlElement(name="entity")
    private final EntityElement[] elements;

    public int getTotalResults() {
        return this.totalResults;
    }

    public EntityList() {
        this.elements = null;
        this.totalResults = 0;
    }

    public EntityList(EntityElement[] elements, int totalResults) {
        this.totalResults = totalResults;
        this.elements = elements;
    }

    public EntityList(Entity[] elements, int totalResults) {
        this.totalResults = totalResults;
        int len = elements.length;
        EntityElement[] items = new EntityElement[len];
        for (int i = 0; i < len; ++i) {
            items[i] = this.createEntityElement(elements[i]);
        }
        this.elements = items;
    }

    private EntityElement createEntityElement(Entity e) {
        EntityElement element = new EntityElement();
        element.type = e.getEntityType().name().toLowerCase();
        element.name = e.getName();
        element.status = null;
        element.tag = new ArrayList<String>();
        element.pipeline = new ArrayList<String>();
        element.cluster = new ArrayList<String>();
        return element;
    }

    public EntityList(Entity[] dependentEntities, Entity entity) {
        int len;
        this.totalResults = len = dependentEntities.length;
        EntityElement[] items = new EntityElement[len];
        for (int i = 0; i < len; ++i) {
            Entity e = dependentEntities[i];
            EntityElement o = new EntityElement();
            o.type = e.getEntityType().name().toLowerCase();
            o.name = e.getName();
            o.status = null;
            o.tag = this.getEntityTag(e, entity);
            items[i] = o;
        }
        this.elements = items;
    }

    public EntityElement[] getElements() {
        return this.elements;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.totalResults + "\n");
        for (EntityElement element : this.elements) {
            buffer.append(element.toString());
        }
        return buffer.toString();
    }

    private List<String> getEntityTag(Entity dependentEntity, Entity entity) {
        ArrayList<String> tagList = new ArrayList<String>();
        if (entity.getEntityType().equals((Object)EntityType.CLUSTER)) {
            return tagList;
        }
        Process process = null;
        String entityNameToMatch = null;
        if (dependentEntity.getEntityType().equals((Object)EntityType.PROCESS)) {
            process = (Process)dependentEntity;
            entityNameToMatch = entity.getName();
        } else if (dependentEntity.getEntityType().equals((Object)EntityType.FEED) && entity.getEntityType().equals((Object)EntityType.PROCESS)) {
            process = (Process)entity;
            entityNameToMatch = dependentEntity.getName();
        }
        if (process != null) {
            if (process.getInputs() != null) {
                for (Input i : process.getInputs().getInputs()) {
                    if (!i.getFeed().equals(entityNameToMatch)) continue;
                    tagList.add(INPUT_TAG);
                }
            }
            if (process.getOutputs() != null) {
                for (Output o : process.getOutputs().getOutputs()) {
                    if (!o.getFeed().equals(entityNameToMatch)) continue;
                    tagList.add(OUTPUT_TAG);
                }
            }
        }
        return tagList;
    }

    public static class EntityElement {
        @XmlElement
        public String type;
        @XmlElement
        public String name;
        @XmlElement
        public String status;
        @XmlElementWrapper(name="tags")
        public List<String> tag;
        @XmlElementWrapper(name="pipelines")
        public List<String> pipeline;
        @XmlElementWrapper(name="clusters")
        public List<String> cluster;

        public String toString() {
            String outString = "(" + this.type + ") " + this.name;
            if (StringUtils.isNotEmpty(this.status)) {
                outString = outString + "(" + this.status + ")";
            }
            if (this.tag != null && !this.tag.isEmpty()) {
                outString = outString + " - " + this.tag.toString();
            }
            if (this.pipeline != null && !this.pipeline.isEmpty()) {
                outString = outString + " - " + this.pipeline.toString();
            }
            if (this.cluster != null && !this.cluster.isEmpty()) {
                outString = outString + " - " + this.cluster.toString();
            }
            outString = outString + "\n";
            return outString;
        }
    }

    public static enum EntityFilterByFields {
        TYPE,
        NAME,
        STATUS,
        PIPELINES,
        CLUSTER,
        TAGS;

    }

    public static enum EntityFieldList {
        TYPE,
        NAME,
        STATUS,
        TAGS,
        PIPELINES,
        CLUSTERS;

    }
}

