/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.falcon.Pair;
import org.apache.falcon.Tag;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityType;

public class WorkflowNameBuilder<T extends Entity> {
    private static final String PREFIX = "FALCON";
    private T entity;
    private Tag tag;
    private List<String> suffixes;

    public WorkflowNameBuilder(T entity) {
        this.entity = entity;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public void setSuffixes(List<String> suffixes) {
        this.suffixes = suffixes;
    }

    public WorkflowName getWorkflowName() {
        return new WorkflowName(PREFIX, ((Entity)this.entity).getEntityType().name(), this.tag == null ? null : this.tag.name(), ((Entity)this.entity).getName(), this.suffixes == null ? new ArrayList() : this.suffixes);
    }

    public Tag getWorkflowTag(String workflowName) {
        return WorkflowName.getTagAndSuffixes(workflowName) == null ? null : (Tag)((Object)WorkflowName.getTagAndSuffixes((String)workflowName).first);
    }

    public String getWorkflowSuffixes(String workflowName) {
        return WorkflowName.getTagAndSuffixes(workflowName) == null ? "" : (String)WorkflowName.getTagAndSuffixes((String)workflowName).second;
    }

    public static class WorkflowName {
        private static final String SEPARATOR = "_";
        private static final Pattern WF_NAME_PATTERN;
        private String prefix;
        private String entityType;
        private String tag;
        private String entityName;
        private List<String> suffixes;

        public WorkflowName(String prefix, String entityType, String tag, String entityName, List<String> suffixes) {
            this.prefix = prefix;
            this.entityType = entityType;
            this.tag = tag;
            this.entityName = entityName;
            this.suffixes = suffixes;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.prefix).append(SEPARATOR).append(this.entityType).append(this.tag == null ? "" : SEPARATOR + this.tag).append(SEPARATOR).append(this.entityName);
            for (String suffix : this.suffixes) {
                builder.append(SEPARATOR).append(suffix);
            }
            return builder.toString();
        }

        public static Pair<Tag, String> getTagAndSuffixes(String workflowName) {
            Matcher matcher = WF_NAME_PATTERN.matcher(workflowName);
            if (matcher.matches()) {
                matcher.reset();
                if (matcher.find()) {
                    String tag = matcher.group(2);
                    String suffixes = matcher.group(4);
                    return new Pair<Tag, String>(Tag.valueOf(tag), suffixes);
                }
            }
            return null;
        }

        public static Pair<String, EntityType> getEntityNameAndType(String workflowName) {
            Matcher matcher = WF_NAME_PATTERN.matcher(workflowName);
            if (matcher.matches()) {
                matcher.reset();
                if (matcher.find()) {
                    String type = matcher.group(1);
                    String name = matcher.group(3);
                    return new Pair<String, EntityType>(name, EntityType.valueOf(type));
                }
            }
            return null;
        }

        static {
            StringBuilder typePattern = new StringBuilder("(");
            for (EntityType type : EntityType.values()) {
                typePattern.append(type.name());
                typePattern.append("|");
            }
            typePattern = typePattern.deleteCharAt(typePattern.length() - 1);
            typePattern.append(")");
            StringBuilder tagsPattern = new StringBuilder("(");
            for (Tag tag : Tag.values()) {
                tagsPattern.append(tag.name());
                tagsPattern.append("|");
            }
            tagsPattern = tagsPattern.deleteCharAt(tagsPattern.length() - 1);
            tagsPattern.append(")");
            String name = "([a-zA-Z][\\-a-zA-Z0-9]*)";
            String suffix = "([_A-Za-z0-9-.]*)";
            String namePattern = "FALCON_" + typePattern + SEPARATOR + tagsPattern + SEPARATOR + name + suffix;
            WF_NAME_PATTERN = Pattern.compile(namePattern);
        }
    }
}

