/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.store.ConfigurationStore;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.datasource.Credential;
import org.apache.falcon.entity.v0.datasource.Credentialtype;
import org.apache.falcon.entity.v0.datasource.Datasource;
import org.apache.falcon.entity.v0.datasource.DatasourceType;
import org.apache.falcon.entity.v0.datasource.Interface;
import org.apache.falcon.entity.v0.datasource.Interfaces;
import org.apache.falcon.entity.v0.datasource.Interfacetype;
import org.apache.falcon.entity.v0.datasource.PasswordAliasType;
import org.apache.falcon.entity.v0.datasource.Property;
import org.apache.falcon.hadoop.HadoopClientFactory;
import org.apache.falcon.security.CredentialProviderHelper;
import org.apache.falcon.security.CurrentUser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatasourceHelper {
    public static final String HADOOP_CREDENTIAL_PROVIDER_FILEPATH = "hadoop.security.credential.provider.path";
    private static final Logger LOG = LoggerFactory.getLogger(DatasourceHelper.class);
    private static final ConfigurationStore STORE = ConfigurationStore.get();

    public static DatasourceType getDatasourceType(String datasourceName) throws FalconException {
        return DatasourceHelper.getDatasource(datasourceName).getType();
    }

    private DatasourceHelper() {
    }

    public static Datasource getDatasource(String datasourceName) throws FalconException {
        return (Datasource)STORE.get(EntityType.DATASOURCE, datasourceName);
    }

    public static String getReadOnlyEndpoint(Datasource datasource) {
        return DatasourceHelper.getInterface(datasource, Interfacetype.READONLY);
    }

    public static String getWriteEndpoint(Datasource datasource) {
        return DatasourceHelper.getInterface(datasource, Interfacetype.WRITE);
    }

    public static Credential getReadPasswordInfo(Datasource db) throws FalconException {
        for (Interface ifs : db.getInterfaces().getInterfaces()) {
            if (ifs.getType() != Interfacetype.READONLY || ifs.getCredential() == null) continue;
            return ifs.getCredential();
        }
        return DatasourceHelper.getDefaultPasswordInfo(db.getInterfaces());
    }

    public static Credential getWritePasswordInfo(Datasource db) throws FalconException {
        for (Interface ifs : db.getInterfaces().getInterfaces()) {
            if (ifs.getType() != Interfacetype.WRITE || ifs.getCredential() == null) continue;
            return ifs.getCredential();
        }
        return DatasourceHelper.getDefaultPasswordInfo(db.getInterfaces());
    }

    public static Properties fetchReadPasswordInfo(Datasource db) throws FalconException {
        Credential cred = DatasourceHelper.getReadPasswordInfo(db);
        return DatasourceHelper.fetchPasswordInfo(cred);
    }

    public static Properties fetchWritePasswordInfo(Datasource db) throws FalconException {
        Credential cred = DatasourceHelper.getWritePasswordInfo(db);
        return DatasourceHelper.fetchPasswordInfo(cred);
    }

    public static Properties fetchPasswordInfo(Credential cred) throws FalconException {
        Properties p = new Properties();
        p.put("user", cred.getUserName());
        if (cred.getType() == Credentialtype.PASSWORD_TEXT) {
            p.put("password", cred.getPasswordText());
        } else if (cred.getType() == Credentialtype.PASSWORD_FILE) {
            String actualPasswd = DatasourceHelper.fetchPasswordInfoFromFile(cred.getPasswordFile());
            p.put("password", actualPasswd);
        } else if (cred.getType() == Credentialtype.PASSWORD_ALIAS) {
            String actualPasswd = DatasourceHelper.fetchPasswordInfoFromCredentialStore(cred.getPasswordAlias());
            p.put("password", actualPasswd);
        }
        return p;
    }

    public static String buildJceksProviderPath(URI credURI) {
        StringBuilder sb = new StringBuilder();
        String credProviderPath = sb.append("jceks:").append("//").append(credURI.getScheme()).append("@").append(credURI.getHost()).append(credURI.getPath()).toString();
        return credProviderPath;
    }

    private static String getInterface(Datasource db, Interfacetype type) {
        for (Interface ifs : db.getInterfaces().getInterfaces()) {
            if (ifs.getType() != type) continue;
            return ifs.getEndpoint();
        }
        return null;
    }

    private static Credential getDefaultPasswordInfo(Interfaces ifs) throws FalconException {
        if (ifs.getCredential() != null) {
            return ifs.getCredential();
        }
        throw new FalconException("Missing Interfaces default credential");
    }

    private static String fetchPasswordInfoFromCredentialStore(PasswordAliasType c) throws FalconException {
        try {
            final String credPath = c.getProviderPath();
            final URI credURI = new URI(credPath);
            if (StringUtils.isBlank((String)credURI.getScheme()) || StringUtils.isBlank((String)credURI.getHost()) || StringUtils.isBlank((String)credURI.getPath())) {
                throw new FalconException("Password alias jceks provider HDFS path is incorrect.");
            }
            final String alias = c.getAlias();
            if (StringUtils.isBlank((String)alias)) {
                throw new FalconException("Password alias is empty.");
            }
            final String credProviderPath = DatasourceHelper.buildJceksProviderPath(credURI);
            LOG.info("Credential provider HDFS path : " + credProviderPath);
            if (CredentialProviderHelper.isProviderAvailable()) {
                UserGroupInformation ugi = CurrentUser.getProxyUGI();
                String password = (String)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws Exception {
                        Configuration conf = new Configuration();
                        conf.set("fs.defaultFS", credPath);
                        conf.set(DatasourceHelper.HADOOP_CREDENTIAL_PROVIDER_FILEPATH, credProviderPath);
                        FileSystem fs = FileSystem.get((URI)credURI, (Configuration)conf);
                        if (!fs.exists(new Path(credPath))) {
                            String msg = String.format("Credential provider hdfs path [%s] does not exist or access denied!", credPath);
                            LOG.error(msg);
                            throw new FalconException(msg);
                        }
                        return CredentialProviderHelper.resolveAlias(conf, alias);
                    }
                });
                return password;
            }
            throw new FalconException("Credential Provider is not initialized");
        }
        catch (Exception ioe) {
            String msg = "Exception while trying to fetch credential alias";
            LOG.error(msg, (Throwable)ioe);
            throw new FalconException(msg, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fetchPasswordInfoFromFile(String passwordFilePath) throws FalconException {
        String string;
        Path path = new Path(passwordFilePath);
        FileSystem fs = HadoopClientFactory.get().createProxiedFileSystem(path.toUri());
        if (!fs.exists(path)) {
            throw new IOException("The password file does not exist! ");
        }
        if (!fs.isFile(path)) {
            throw new IOException("The password file cannot be a directory! ");
        }
        FSDataInputStream is = fs.open(path);
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)is, (Writer)writer);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly(writer);
                fs.close();
                throw throwable;
            }
            catch (IOException ioe) {
                LOG.error("Error reading password file from HDFS : " + ioe);
                throw new FalconException(ioe);
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly(writer);
        fs.close();
        return string;
    }

    public static Map<String, String> getDatasourceProperties(Datasource datasource) {
        HashMap<String, String> returnProps = new HashMap<String, String>();
        if (datasource.getProperties() != null) {
            for (Property prop : datasource.getProperties().getProperties()) {
                returnProps.put(prop.getName(), prop.getValue());
            }
        }
        return returnProps;
    }
}

