/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.cliParser;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CLIParser {
    private static final String LEFT_PADDING = "      ";
    private String cliName;
    private String[] cliHelp;
    private Map<String, Options> commands = new LinkedHashMap<String, Options>();
    private Map<String, Boolean> commandWithArgs = new LinkedHashMap<String, Boolean>();
    private Map<String, String> commandsHelp = new LinkedHashMap<String, String>();

    public CLIParser(String aCliName, String[] aCliHelp) {
        this.cliName = aCliName;
        this.cliHelp = (String[])aCliHelp.clone();
    }

    public void addCommand(String command, String argsHelp, String commandHelp, Options commandOptions, boolean hasArguments) {
        String helpMsg = argsHelp + (hasArguments ? "<ARGS> " : "") + ": " + commandHelp;
        this.commandsHelp.put(command, helpMsg);
        this.commands.put(command, commandOptions);
        this.commandWithArgs.put(command, hasArguments);
    }

    public Command parse(String[] args) throws ParseException {
        if (args.length == 0) {
            throw new ParseException("missing sub-command");
        }
        if (this.commands.containsKey(args[0])) {
            GnuParser parser = new GnuParser();
            String[] minusCommand = new String[args.length - 1];
            System.arraycopy(args, 1, minusCommand, 0, minusCommand.length);
            return new Command(args[0], parser.parse(this.commands.get(args[0]), minusCommand, this.commandWithArgs.get(args[0]).booleanValue()));
        }
        throw new ParseException(MessageFormat.format("invalid sub-command [{0}]", args[0]));
    }

    public String shortHelp() {
        return "use 'help' sub-command for help details";
    }

    public void showHelp() {
        PrintWriter pw = new PrintWriter(System.out);
        pw.println("usage: ");
        for (String s : this.cliHelp) {
            pw.println(LEFT_PADDING + s);
        }
        pw.println();
        HelpFormatter formatter = new HelpFormatter();
        for (Map.Entry<String, Options> entry : this.commands.entrySet()) {
            String s;
            s = LEFT_PADDING + this.cliName + " " + entry.getKey() + " ";
            if (entry.getValue().getOptions().size() > 0) {
                pw.println(s + "<OPTIONS> " + this.commandsHelp.get(entry.getKey()));
                formatter.printOptions(pw, 100, entry.getValue(), s.length(), 3);
            } else {
                pw.println(s + this.commandsHelp.get(entry.getKey()));
            }
            pw.println();
        }
        pw.flush();
    }

    public static final class Command {
        private String name;
        private CommandLine commandLine;

        private Command(String name, CommandLine commandLine) {
            this.name = name;
            this.commandLine = commandLine;
        }

        public String getName() {
            return this.name;
        }

        public CommandLine getCommandLine() {
            return this.commandLine;
        }
    }
}

