/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.cli;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.client.FalconCLIException;
import org.apache.falcon.client.FalconClient;
import org.apache.falcon.resource.ExtensionInstanceList;
import org.apache.falcon.resource.ExtensionJobList;

public class FalconExtensionCLI {
    public static final AtomicReference<PrintStream> OUT = new AtomicReference<PrintStream>(System.out);
    public static final String ENUMERATE_OPT = "enumerate";
    public static final String DEFINITION_OPT = "definition";
    public static final String DESCRIBE_OPT = "describe";
    public static final String INSTANCES_OPT = "instances";
    public static final String ENTENSION_NAME_OPT = "extensionName";
    public static final String JOB_NAME_OPT = "jobName";

    public void extensionCommand(CommandLine commandLine, FalconClient client) throws FalconCLIException {
        String result;
        HashSet<String> optionsList = new HashSet<String>();
        for (Option option : commandLine.getOptions()) {
            optionsList.add(option.getOpt());
        }
        String extensionName = commandLine.getOptionValue(ENTENSION_NAME_OPT);
        String jobName = commandLine.getOptionValue(JOB_NAME_OPT);
        String filePath = commandLine.getOptionValue("file");
        String doAsUser = commandLine.getOptionValue("doAs");
        if (optionsList.contains(ENUMERATE_OPT)) {
            result = client.enumerateExtensions();
            result = FalconExtensionCLI.prettyPrintJson(result);
        } else if (optionsList.contains(DEFINITION_OPT)) {
            this.validateRequiredParameter(extensionName, ENTENSION_NAME_OPT);
            result = client.getExtensionDefinition(extensionName);
            result = FalconExtensionCLI.prettyPrintJson(result);
        } else if (optionsList.contains(DESCRIBE_OPT)) {
            this.validateRequiredParameter(extensionName, ENTENSION_NAME_OPT);
            result = client.getExtensionDescription(extensionName);
        } else if (optionsList.contains("submit")) {
            this.validateRequiredParameter(extensionName, ENTENSION_NAME_OPT);
            this.validateRequiredParameter(filePath, "file");
            result = client.submitExtensionJob(extensionName, filePath, doAsUser).getMessage();
        } else if (optionsList.contains("submitAndSchedule")) {
            this.validateRequiredParameter(extensionName, ENTENSION_NAME_OPT);
            this.validateRequiredParameter(filePath, "file");
            result = client.submitAndScheduleExtensionJob(extensionName, filePath, doAsUser).getMessage();
        } else if (optionsList.contains("update")) {
            this.validateRequiredParameter(extensionName, ENTENSION_NAME_OPT);
            this.validateRequiredParameter(filePath, "file");
            result = client.updateExtensionJob(extensionName, filePath, doAsUser).getMessage();
        } else if (optionsList.contains("validate")) {
            this.validateRequiredParameter(extensionName, ENTENSION_NAME_OPT);
            this.validateRequiredParameter(filePath, "file");
            result = client.validateExtensionJob(extensionName, filePath, doAsUser).getMessage();
        } else if (optionsList.contains("schedule")) {
            this.validateRequiredParameter(jobName, JOB_NAME_OPT);
            result = client.scheduleExtensionJob(jobName, doAsUser).getMessage();
        } else if (optionsList.contains("suspend")) {
            this.validateRequiredParameter(jobName, JOB_NAME_OPT);
            result = client.suspendExtensionJob(jobName, doAsUser).getMessage();
        } else if (optionsList.contains("resume")) {
            this.validateRequiredParameter(jobName, JOB_NAME_OPT);
            result = client.resumeExtensionJob(jobName, doAsUser).getMessage();
        } else if (optionsList.contains("delete")) {
            this.validateRequiredParameter(jobName, JOB_NAME_OPT);
            result = client.deleteExtensionJob(jobName, doAsUser).getMessage();
        } else if (optionsList.contains("list")) {
            this.validateRequiredParameter(extensionName, ENTENSION_NAME_OPT);
            ExtensionJobList jobs = client.listExtensionJob(extensionName, doAsUser, commandLine.getOptionValue("sortOrder"), commandLine.getOptionValue("offset"), commandLine.getOptionValue("numResults"), commandLine.getOptionValue("fields"));
            result = jobs != null ? jobs.toString() : "No extension job (" + extensionName + ") found.";
        } else if (optionsList.contains(INSTANCES_OPT)) {
            this.validateRequiredParameter(jobName, JOB_NAME_OPT);
            ExtensionInstanceList instances = client.listExtensionInstance(jobName, doAsUser, commandLine.getOptionValue("fields"), commandLine.getOptionValue("start"), commandLine.getOptionValue("end"), commandLine.getOptionValue("instanceStatus"), commandLine.getOptionValue("orderBy"), commandLine.getOptionValue("sortOrder"), commandLine.getOptionValue("offset"), commandLine.getOptionValue("numResults"));
            result = instances != null ? instances.toString() : "No instance (" + jobName + ") found.";
        } else {
            throw new FalconCLIException("Invalid/missing extension command. Supported commands include enumerate, definition, describe, list, instances, submit, submitAndSchedule, schedule, suspend, resume, delete, update, validate. Please refer to Falcon CLI twiki for more details.");
        }
        OUT.get().println(result);
    }

    public Options createExtensionOptions() {
        Options extensionOptions = new Options();
        Option enumerate = new Option(ENUMERATE_OPT, false, "Enumerate all extensions");
        Option definition = new Option(DEFINITION_OPT, false, "Get extension definition");
        Option describe = new Option(DESCRIBE_OPT, false, "Get extension description");
        Option list = new Option("list", false, "List extension jobs and associated entities");
        Option instances = new Option(INSTANCES_OPT, false, "List instances of an extension job");
        Option submit = new Option("submit", false, "Submit an extension job");
        Option submitAndSchedule = new Option("submitAndSchedule", false, "Submit and schedule an extension job");
        Option update = new Option("update", false, "Update an extension job");
        Option validate = new Option("validate", false, "Validate an extension job");
        Option schedule = new Option("schedule", false, "Schedule an extension job");
        Option suspend = new Option("suspend", false, "Suspend an extension job");
        Option resume = new Option("resume", false, "Resume an extension job");
        Option delete = new Option("delete", false, "Delete an extension job");
        OptionGroup group = new OptionGroup();
        group.addOption(enumerate);
        group.addOption(definition);
        group.addOption(describe);
        group.addOption(list);
        group.addOption(instances);
        group.addOption(submit);
        group.addOption(submitAndSchedule);
        group.addOption(update);
        group.addOption(validate);
        group.addOption(schedule);
        group.addOption(suspend);
        group.addOption(resume);
        group.addOption(delete);
        extensionOptions.addOptionGroup(group);
        Option url = new Option("url", true, "Falcon URL");
        Option doAs = new Option("doAs", true, "doAs user");
        Option debug = new Option("debug", false, "Use debug mode to see debugging statements on stdout");
        Option extensionName = new Option(ENTENSION_NAME_OPT, true, "Extension name");
        Option jobName = new Option(JOB_NAME_OPT, true, "Extension job name");
        Option instanceStatus = new Option("instanceStatus", true, "Instance status");
        Option sortOrder = new Option("sortOrder", true, "asc or desc order for results");
        Option offset = new Option("offset", true, "Start returning instances from this offset");
        Option numResults = new Option("numResults", true, "Number of results to return per request");
        Option fields = new Option("fields", true, "Entity fields to show for a request");
        Option start = new Option("start", true, "Start time of instances");
        Option end = new Option("end", true, "End time of instances");
        Option status = new Option("status", true, "Filter returned instances by status");
        Option orderBy = new Option("orderBy", true, "Order returned instances by this field");
        Option filePath = new Option("file", true, "File path of extension parameters");
        extensionOptions.addOption(url);
        extensionOptions.addOption(doAs);
        extensionOptions.addOption(debug);
        extensionOptions.addOption(extensionName);
        extensionOptions.addOption(jobName);
        extensionOptions.addOption(instanceStatus);
        extensionOptions.addOption(sortOrder);
        extensionOptions.addOption(offset);
        extensionOptions.addOption(numResults);
        extensionOptions.addOption(fields);
        extensionOptions.addOption(start);
        extensionOptions.addOption(end);
        extensionOptions.addOption(status);
        extensionOptions.addOption(orderBy);
        extensionOptions.addOption(filePath);
        return extensionOptions;
    }

    private void validateRequiredParameter(String parameter, String parameterName) throws FalconCLIException {
        if (StringUtils.isBlank(parameter)) {
            throw new FalconCLIException("The parameter " + parameterName + " cannot be null or empty");
        }
    }

    private static String prettyPrintJson(String jsonString) {
        if (StringUtils.isBlank(jsonString)) {
            return "No result returned";
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(jsonString.trim());
        return gson.toJson(je);
    }
}

