/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.cli;

import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.falcon.cli.FalconCLI;
import org.apache.falcon.client.FalconCLIException;
import org.apache.falcon.client.FalconClient;

public class FalconAdminCLI
extends FalconCLI {
    private static final String STACK_OPTION = "stack";

    public Options createAdminOptions() {
        Options adminOptions = new Options();
        Option url = new Option("url", true, "Falcon URL");
        adminOptions.addOption(url);
        OptionGroup group = new OptionGroup();
        Option status = new Option("status", false, "show the current system status");
        Option version = new Option("version", false, "show Falcon server build version");
        Option stack = new Option(STACK_OPTION, false, "show the thread stack dump");
        Option doAs = new Option("doAs", true, "doAs user");
        Option safemode = new Option("setsafemode", true, "doAs user");
        Option help = new Option("help", false, "show Falcon help");
        Option debug = new Option("debug", false, "Use debug mode to see debugging statements on stdout");
        group.addOption(status);
        group.addOption(version);
        group.addOption(stack);
        group.addOption(help);
        group.addOption(safemode);
        adminOptions.addOptionGroup(group);
        adminOptions.addOption(doAs);
        adminOptions.addOption(debug);
        return adminOptions;
    }

    public int adminCommand(CommandLine commandLine, FalconClient client, String falconUrl) throws FalconCLIException, IOException {
        int exitValue;
        block16: {
            HashSet<String> optionsList = new HashSet<String>();
            for (Option option : commandLine.getOptions()) {
                optionsList.add(option.getOpt());
            }
            String doAsUser = commandLine.getOptionValue("doAs");
            exitValue = 0;
            if (optionsList.contains(STACK_OPTION)) {
                String result = client.getThreadDump(doAsUser);
                ((PrintStream)OUT.get()).println(result);
            } else if (optionsList.contains("status")) {
                try {
                    int status = client.getStatus(doAsUser);
                    if (status != 200) {
                        ((PrintStream)ERR.get()).println("Falcon server is not fully operational (on " + falconUrl + "). Please check log files.");
                        exitValue = status;
                        break block16;
                    }
                    ((PrintStream)OUT.get()).println("Falcon server is running (on " + falconUrl + ")");
                }
                catch (Exception e) {
                    ((PrintStream)ERR.get()).println("Falcon server doesn't seem to be running on " + falconUrl);
                    exitValue = -1;
                }
            } else if (optionsList.contains("version")) {
                String result = client.getVersion(doAsUser);
                ((PrintStream)OUT.get()).println("Falcon server build version: " + result);
            } else if (optionsList.contains("setsafemode")) {
                String safemode = commandLine.getOptionValue("setsafemode");
                ClientResponse response = client.setSafemode(safemode, doAsUser);
                if (response.getStatus() == 200) {
                    ((PrintStream)OUT.get()).println("Falcon server safemode set to : " + safemode);
                } else {
                    ((PrintStream)ERR.get()).println("Unable to set Falcon server to safemode value : " + safemode);
                    ((PrintStream)ERR.get()).println(response.toString());
                    exitValue = -1;
                }
            } else if (optionsList.contains("help")) {
                ((PrintStream)OUT.get()).println("Falcon Help");
            } else {
                throw new FalconCLIException("Invalid/missing admin command. Supported commands include status, version, setsafemode, help. Please refer to Falcon CLI twiki for more details.");
            }
        }
        return exitValue;
    }
}

