/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.cleanup;

import java.util.Collection;
import org.apache.falcon.FalconException;
import org.apache.falcon.cleanup.AbstractCleanupHandler;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.process.Cluster;
import org.apache.falcon.entity.v0.process.Process;

public class ProcessCleanupHandler
extends AbstractCleanupHandler {
    @Override
    public void cleanup() throws FalconException {
        Collection<String> processes = STORE.getEntities(EntityType.PROCESS);
        for (String processName : processes) {
            Process process = (Process)STORE.get(EntityType.PROCESS, processName);
            long retention = this.getRetention(process, process.getFrequency().getTimeUnit());
            for (Cluster cluster : process.getClusters().getClusters()) {
                this.delete(cluster.getName(), process, retention);
            }
        }
    }

    @Override
    protected String getRelativeLogPath() {
        return "job-*/*";
    }
}

