/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.cleanup;

import java.util.Collection;
import org.apache.falcon.FalconException;
import org.apache.falcon.cleanup.AbstractCleanupHandler;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.feed.Cluster;
import org.apache.falcon.entity.v0.feed.Feed;

public class FeedCleanupHandler
extends AbstractCleanupHandler {
    @Override
    public void cleanup() throws FalconException {
        Collection<String> feeds = STORE.getEntities(EntityType.FEED);
        for (String feedName : feeds) {
            Feed feed = (Feed)STORE.get(EntityType.FEED, feedName);
            long retention = this.getRetention(feed, feed.getFrequency().getTimeUnit());
            for (Cluster cluster : feed.getClusters().getClusters()) {
                this.delete(cluster.getName(), feed, retention);
            }
        }
    }

    @Override
    protected String getRelativeLogPath() {
        return "job-*/*/*";
    }
}

