/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.catalog;

import org.apache.falcon.FalconException;
import org.apache.falcon.catalog.AbstractCatalogService;
import org.apache.falcon.util.ReflectionUtils;
import org.apache.falcon.util.StartupProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CatalogServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogServiceFactory.class);
    public static final String CATALOG_SERVICE = "catalog.service.impl";

    private CatalogServiceFactory() {
    }

    public static boolean isEnabled() {
        boolean isEnabled = StartupProperties.get().containsKey(CATALOG_SERVICE);
        if (!isEnabled) {
            LOG.info("Catalog service disabled. Partitions will not registered");
        }
        return isEnabled;
    }

    public static AbstractCatalogService getCatalogService() throws FalconException {
        if (!CatalogServiceFactory.isEnabled()) {
            throw new FalconException("Catalog integration is not enabled in falcon. Implementation is missing: catalog.service.impl");
        }
        return (AbstractCatalogService)ReflectionUtils.getInstance(CATALOG_SERVICE);
    }
}

