/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon;

import java.util.Date;
import java.util.Formatter;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.entity.v0.SchemaHelper;
import org.apache.falcon.resource.EntitySummaryResult;
import org.apache.falcon.resource.FeedInstanceResult;
import org.apache.falcon.resource.FeedLookupResult;
import org.apache.falcon.resource.InstanceDependencyResult;
import org.apache.falcon.resource.InstancesResult;
import org.apache.falcon.resource.InstancesSummaryResult;
import org.apache.falcon.resource.SchedulableEntityInstanceResult;
import org.apache.falcon.resource.TriageResult;

public final class ResponseHelper {
    private ResponseHelper() {
    }

    public static String getString(EntitySummaryResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append("Consolidated Status: ").append((Object)result.getStatus()).append("\n");
        sb.append("\nEntity Summary Result :\n");
        if (result.getEntitySummaries() != null) {
            for (EntitySummaryResult.EntitySummary entitySummary : result.getEntitySummaries()) {
                String toAppend = entitySummary.toString();
                sb.append(toAppend).append("\n");
            }
        }
        sb.append("\nAdditional Information:\n");
        sb.append("Response: ").append(result.getMessage());
        sb.append("Request Id: ").append(result.getRequestId());
        return sb.toString();
    }

    public static String getString(InstancesResult result, String runid) {
        StringBuilder sb = new StringBuilder();
        sb.append("Consolidated Status: ").append((Object)result.getStatus()).append("\n");
        sb.append("\nInstances:\n");
        sb.append("Instance\t\tCluster\t\tSourceCluster\t\tStatus\t\tRunID\t\t\tLog\n");
        sb.append("-----------------------------------------------------------------------------------------------\n");
        if (result.getInstances() != null) {
            for (InstancesResult.Instance instance : result.getInstances()) {
                String toAppend = instance.getInstance() != null ? instance.getInstance() : "-";
                sb.append(toAppend).append("\t");
                toAppend = instance.getCluster() != null ? instance.getCluster() : "-";
                sb.append(toAppend).append("\t");
                toAppend = instance.getSourceCluster() != null ? instance.getSourceCluster() : "-";
                sb.append(toAppend).append("\t");
                toAppend = instance.getStatus() != null ? instance.getStatus().toString() : "-";
                sb.append(toAppend).append("\t");
                toAppend = runid != null ? runid : "latest";
                sb.append(toAppend).append("\t");
                toAppend = instance.getLogFile() != null ? instance.getLogFile() : "-";
                sb.append(toAppend).append("\n");
                if (instance.actions == null) continue;
                sb.append("actions:\n");
                for (InstancesResult.InstanceAction action : instance.actions) {
                    sb.append("    ").append(action.getAction()).append("\t");
                    sb.append(action.getStatus()).append("\t").append(action.getLogFile()).append("\n");
                }
            }
        }
        sb.append("\nAdditional Information:\n");
        sb.append("Response: ").append(result.getMessage());
        sb.append("Request Id: ").append(result.getRequestId());
        return sb.toString();
    }

    public static String getString(FeedInstanceResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append("Consolidated Status: ").append((Object)result.getStatus()).append("\n");
        sb.append("\nInstances:\n");
        Formatter formatter = new Formatter(sb);
        formatter.format("%-16s%-20s%-16s%-16s%-20s%-16s", "Cluster", "Instance", "Status", "Size", "CreationTime", "Details");
        sb.append("\n");
        sb.append("-----------------------------------------------------------------------------------------------\n");
        if (result.getInstances() != null) {
            for (FeedInstanceResult.Instance instance : result.getInstances()) {
                formatter.format("%-16s", instance.getCluster() != null ? instance.getCluster() : "-");
                formatter.format("%-20s", instance.getInstance() != null ? instance.getInstance() : "-");
                formatter.format("%-16s", instance.getStatus() != null ? instance.getStatus() : "-");
                formatter.format("%-16s", instance.getSize() != -1L ? instance.getSizeH() : "-");
                formatter.format("%-20s", instance.getCreationTime() != 0L ? SchemaHelper.formatDateUTC(new Date(instance.getCreationTime())) : "-");
                formatter.format("%-16s", StringUtils.isEmpty(instance.getUri()) ? "-" : instance.getUri());
                sb.append("\n");
            }
        }
        sb.append("\nAdditional Information:\n");
        sb.append("Response: ").append(result.getMessage());
        sb.append("Request Id: ").append(result.getRequestId());
        return sb.toString();
    }

    public static String getString(InstancesResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append("Consolidated Status: ").append((Object)result.getStatus()).append("\n");
        sb.append("\nInstances:\n");
        sb.append("Instance\t\tCluster\t\tSourceCluster\t\tStatus\t\tStart\t\tEnd\t\tDetails\t\t\t\t\tLog\n");
        sb.append("-----------------------------------------------------------------------------------------------\n");
        if (result.getInstances() != null) {
            for (InstancesResult.Instance instance : result.getInstances()) {
                String toAppend = instance.getInstance() != null ? instance.getInstance() : "-";
                sb.append(toAppend).append("\t");
                toAppend = instance.getCluster() != null ? instance.getCluster() : "-";
                sb.append(toAppend).append("\t");
                toAppend = instance.getSourceCluster() != null ? instance.getSourceCluster() : "-";
                sb.append(toAppend).append("\t");
                toAppend = instance.getStatus() != null ? instance.getStatus().toString() : "-";
                sb.append(toAppend).append("\t");
                toAppend = instance.getStartTime() != null ? SchemaHelper.formatDateUTC(instance.getStartTime()) : "-";
                sb.append(toAppend).append("\t");
                toAppend = instance.getEndTime() != null ? SchemaHelper.formatDateUTC(instance.getEndTime()) : "-";
                sb.append(toAppend).append("\t");
                toAppend = !StringUtils.isEmpty(instance.getDetails()) ? instance.getDetails() : "-";
                sb.append(toAppend).append("\t");
                toAppend = instance.getLogFile() != null ? instance.getLogFile() : "-";
                sb.append(toAppend).append("\n");
                if (instance.getWfParams() != null) {
                    InstancesResult.KeyValuePair[] props = instance.getWfParams();
                    sb.append("Workflow params").append("\n");
                    InstancesResult.KeyValuePair[] keyValuePairArray = props;
                    int n = keyValuePairArray.length;
                    for (int i = 0; i < n; ++i) {
                        InstancesResult.KeyValuePair entry = keyValuePairArray[i];
                        sb.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
                    }
                    sb.append("\n");
                }
                if (instance.actions == null) continue;
                sb.append("actions:\n");
                for (InstancesResult.InstanceAction action : instance.actions) {
                    sb.append(" ").append(action.getAction()).append("\t");
                    sb.append(action.getStatus()).append("\t").append(action.getLogFile()).append("\n");
                }
            }
        }
        sb.append("\nAdditional Information:\n");
        sb.append("Response: ").append(result.getMessage());
        sb.append("Request Id: ").append(result.getRequestId());
        return sb.toString();
    }

    public static String getString(InstancesSummaryResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append("Consolidated Status: ").append((Object)result.getStatus()).append("\n");
        sb.append("\nInstances Summary:\n");
        if (result.getInstancesSummary() != null) {
            for (InstancesSummaryResult.InstanceSummary summary : result.getInstancesSummary()) {
                String toAppend = summary.getCluster() != null ? summary.getCluster() : "-";
                sb.append("Cluster: ").append(toAppend).append("\n");
                sb.append("Status\t\tCount\n");
                sb.append("-------------------------\n");
                for (Map.Entry<String, Long> entry : summary.getSummaryMap().entrySet()) {
                    sb.append(entry.getKey()).append("\t\t").append(entry.getValue()).append("\n");
                }
            }
        }
        sb.append("\nAdditional Information:\n");
        sb.append("Response: ").append(result.getMessage());
        sb.append("Request Id: ").append(result.getRequestId());
        return sb.toString();
    }

    public static String getString(TriageResult triageResult) {
        StringBuilder sb = new StringBuilder();
        sb.append(triageResult.toString());
        sb.append("\nAdditional Information:\n");
        sb.append("Response: ").append(triageResult.getMessage());
        sb.append("Request Id: ").append(triageResult.getRequestId());
        return sb.toString();
    }

    public static String getString(FeedLookupResult feedLookupResult) {
        StringBuilder sb = new StringBuilder();
        String results = feedLookupResult.toString();
        if (StringUtils.isEmpty(results)) {
            sb.append("No matching feeds found!");
        } else {
            sb.append(results);
        }
        sb.append("\n\nResponse: ").append(feedLookupResult.getMessage());
        sb.append("\nRequest Id: ").append(feedLookupResult.getRequestId());
        return sb.toString();
    }

    public static String getString(InstanceDependencyResult dependencyResult) {
        StringBuilder sb = new StringBuilder();
        String results = dependencyResult.toString();
        if (StringUtils.isEmpty(results)) {
            sb.append("No dependencies found!");
        } else {
            sb.append(results);
        }
        sb.append("\n\nResponse: ").append(dependencyResult.getMessage());
        sb.append("\nRequest Id: ").append(dependencyResult.getRequestId());
        return sb.toString();
    }

    public static String getString(SchedulableEntityInstanceResult instances) {
        StringBuilder sb = new StringBuilder();
        String results = instances.toString();
        if (StringUtils.isEmpty(results)) {
            sb.append("No sla miss found!");
        } else {
            sb.append(results);
        }
        sb.append("\n\nResponse: ").append(instances.getMessage());
        sb.append("\nRequest Id: ").append(instances.getRequestId());
        return sb.toString();
    }
}

