/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.core;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.shell.core.TokenizingException;
import org.springframework.util.Assert;

public class Tokenizer {
    private static final char ESCAPE_CHAR = '\\';
    private final char[] buffer;
    private int pos = 0;
    private final Map<String, String> result = new LinkedHashMap<String, String>();
    private boolean allowUnbalancedLastQuotedValue;
    private boolean openingQuotesHaveNotBeenClosed;
    private char lastValueDelimiter;
    private int lastValueStartOffset = -1;

    public Tokenizer(String text) {
        this(text, false);
    }

    public Tokenizer(String text, boolean allowUnbalancedLastQuotedValue) {
        this.buffer = text.toCharArray();
        this.allowUnbalancedLastQuotedValue = allowUnbalancedLastQuotedValue;
        this.tokenize();
    }

    private void eatWhiteSpace() {
        while (this.lookAhead(' ')) {
            ++this.pos;
        }
    }

    public void tokenize() {
        while (this.pos < this.buffer.length) {
            this.eatWhiteSpace();
            if (this.pos >= this.buffer.length) continue;
            this.eatKeyValuePair();
        }
    }

    public Map<String, String> getTokens() {
        return this.result;
    }

    private boolean lookAhead(char ... toMatch) {
        for (int i = 0; i < toMatch.length; ++i) {
            if (this.pos + i < this.buffer.length && this.buffer[this.pos + i] == toMatch[i]) continue;
            return false;
        }
        return true;
    }

    private void eatKeyValuePair() {
        if (this.lookAhead('-', '-')) {
            this.pos += 2;
            this.eatKeyEqualsValue();
        } else {
            int offsetInCaseOfFailure = this.pos;
            String value = this.eatValue(true);
            this.store("", value, offsetInCaseOfFailure);
        }
    }

    private void store(String key, String value, int failureOffset) {
        String alreadyThere = this.result.put(key, value);
        if (alreadyThere != null) {
            if ("".equals(key)) {
                String explanation = String.format("You cannot specify '%s' as another value for the default ('') option in a single command.%nYou already provided '%s' earlier.%nDid you forget to add quotes around the value of another option?", value, alreadyThere);
                throw new TokenizingException(failureOffset, this.buffer, explanation);
            }
            String explanation = String.format("You cannot specify '%s' as another value for the '--%s' option in a single command.%nYou already provided '%s' earlier.", value, key, alreadyThere);
            throw new TokenizingException(failureOffset, this.buffer, explanation);
        }
    }

    private String eatValue(boolean emptyKey) {
        StringBuilder sb = new StringBuilder();
        char endDelimiter = ' ';
        if (this.buffer[this.pos] == '\"' || this.buffer[this.pos] == '\'') {
            endDelimiter = this.buffer[this.pos];
            ++this.pos;
        }
        this.lastValueDelimiter = endDelimiter;
        this.lastValueStartOffset = this.pos;
        while (this.pos < this.buffer.length && this.buffer[this.pos] != endDelimiter) {
            if (this.buffer[this.pos] == '\\') {
                sb.append(this.processCharacterEscapeCodes(endDelimiter));
                continue;
            }
            if (this.lookAhead('\\', endDelimiter)) {
                sb.append(endDelimiter);
                this.pos += 2;
                continue;
            }
            sb.append(this.buffer[this.pos]);
            ++this.pos;
        }
        if (emptyKey && endDelimiter == ' ') {
            while (!this.lookAhead('-', '-') && this.pos < this.buffer.length) {
                sb.append(this.buffer[this.pos++]);
            }
            while (Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                sb.setLength(sb.length() - 1);
            }
            return sb.toString();
        }
        if (endDelimiter != ' ' && this.pos == this.buffer.length && (this.buffer[this.pos - 1] != endDelimiter || sb.length() == 0)) {
            if (this.allowUnbalancedLastQuotedValue) {
                this.openingQuotesHaveNotBeenClosed = true;
                return sb.toString();
            }
            throw new TokenizingException(this.pos, this.buffer, "Cannot have an unbalanced number of quotation marks");
        }
        ++this.pos;
        return sb.toString();
    }

    private char processCharacterEscapeCodes(char endDelimiter) {
        ++this.pos;
        if (this.pos >= this.buffer.length) {
            throw new TokenizingException(this.buffer.length, this.buffer, "Ran out of input in escape sequence");
        }
        switch (this.buffer[this.pos]) {
            case '\\': {
                ++this.pos;
                return '\\';
            }
            case 't': {
                ++this.pos;
                return '\t';
            }
            case 'r': {
                ++this.pos;
                return '\r';
            }
            case 'n': {
                ++this.pos;
                return '\n';
            }
            case 'f': {
                ++this.pos;
                return '\f';
            }
            case 'u': {
                if (this.pos + 5 > this.buffer.length) {
                    throw new TokenizingException(this.buffer.length, this.buffer, "Ran out of input in unicode escape sequence");
                }
                String hex = new String(this.buffer, this.pos + 1, 4);
                try {
                    char code = (char)Integer.parseInt(hex, 16);
                    this.pos += 5;
                    return code;
                }
                catch (NumberFormatException e) {
                    throw new TokenizingException(this.pos - 1, this.buffer, "Illegal unicode escape sequence: \\u" + hex);
                }
            }
        }
        if (this.buffer[this.pos] == endDelimiter) {
            ++this.pos;
            return endDelimiter;
        }
        return '\\';
    }

    public int getLastValueStartOffset() {
        Assert.isTrue(this.lastValueStartOffset >= 0, "lastValueStartOffset has not been set yet");
        return this.lastValueStartOffset;
    }

    public char getLastValueDelimiter() {
        Assert.isTrue(this.lastValueDelimiter != '\u0000', "lastValueDelimiter has not been set yet");
        return this.lastValueDelimiter;
    }

    public boolean openingQuotesHaveNotBeenClosed() {
        return this.openingQuotesHaveNotBeenClosed;
    }

    public boolean lastValueIsComplete() {
        return !this.openingQuotesHaveNotBeenClosed && this.lastValueDelimiter != ' ';
    }

    public String escape(String value) {
        String result = value.replace("" + this.lastValueDelimiter, "\\" + this.lastValueDelimiter);
        result = result.replace("\r", "\\r");
        result = result.replace("\n", "\\n");
        result = result.replace("\t", "\\t");
        result = result.replace("\f", "\\f");
        return result;
    }

    private void eatKeyEqualsValue() {
        String value;
        int offsetInCaseOfFailure = this.pos - 2;
        String key = this.eatKey();
        this.eatWhiteSpace();
        if (this.pos >= this.buffer.length || this.lookAhead('-', '-')) {
            this.lastValueDelimiter = (char)32;
            this.lastValueStartOffset = this.pos;
            value = "";
        } else {
            value = this.eatValue(false);
        }
        if (key.equals("") && value.equals("")) {
            return;
        }
        this.store(key, value, offsetInCaseOfFailure);
    }

    private String eatKey() {
        int start = this.pos;
        while (this.pos < this.buffer.length && this.buffer[this.pos] != ' ') {
            ++this.pos;
        }
        return new String(this.buffer, start, this.pos - start);
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append(this.buffer).append('\n');
        for (int i = 0; i < this.lastValueStartOffset; ++i) {
            result.append(' ');
        }
        result.append('^');
        return result.toString();
    }
}

