/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.core;

import java.lang.reflect.Method;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MethodTarget {
    private final Method method;
    private final Object target;
    private final String remainingBuffer;
    private final String key;

    public MethodTarget(Method method, Object target) {
        this(method, target, null, null);
    }

    public MethodTarget(Method method, Object target, String remainingBuffer, String key) {
        Assert.notNull(method, "Method is required");
        Assert.notNull(target, "Target is required");
        this.key = StringUtils.trimWhitespace(key);
        this.method = method;
        this.remainingBuffer = remainingBuffer;
        this.target = target;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MethodTarget)) {
            return false;
        }
        MethodTarget otherMethodTarget = (MethodTarget)other;
        return this.method.equals(otherMethodTarget.getMethod()) && this.target.equals(otherMethodTarget.getTarget());
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.method) + ObjectUtils.nullSafeHashCode(this.target);
    }

    public final String toString() {
        ToStringCreator tsc = new ToStringCreator(this);
        tsc.append("target", this.target);
        tsc.append("method", this.method);
        tsc.append("remainingBuffer", this.remainingBuffer);
        tsc.append("key", this.key);
        return tsc.toString();
    }

    public String getKey() {
        return this.key;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getRemainingBuffer() {
        return this.remainingBuffer;
    }

    public Object getTarget() {
        return this.target;
    }
}

