/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.converters;

import java.io.File;
import java.util.List;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;
import org.springframework.shell.support.util.FileUtils;
import org.springframework.util.Assert;

public abstract class FileConverter
implements Converter<File> {
    private static final String HOME_DIRECTORY_SYMBOL = "~";
    private static final String home = System.getProperty("user.home");

    protected abstract File getWorkingDirectory();

    @Override
    public File convertFromText(String value, Class<?> requiredType, String optionContext) {
        return new File(this.convertUserInputIntoAFullyQualifiedPath(value));
    }

    @Override
    public boolean getAllPossibleValues(List<Completion> completions, Class<?> requiredType, String originalUserInput, String optionContext, MethodTarget target) {
        String adjustedUserInput = this.convertUserInputIntoAFullyQualifiedPath(originalUserInput);
        String directoryData = adjustedUserInput.substring(0, adjustedUserInput.lastIndexOf(File.separator) + 1);
        adjustedUserInput = adjustedUserInput.substring(adjustedUserInput.lastIndexOf(File.separator) + 1);
        this.populate(completions, adjustedUserInput, originalUserInput, directoryData);
        return false;
    }

    protected void populate(List<Completion> completions, String adjustedUserInput, String originalUserInput, String directoryData) {
        File directory = new File(directoryData);
        if (!directory.isDirectory()) {
            return;
        }
        for (File file : directory.listFiles()) {
            if (adjustedUserInput != null && adjustedUserInput.length() != 0 && !file.getName().toLowerCase().startsWith(adjustedUserInput.toLowerCase())) continue;
            String completion = "";
            if (directoryData.length() > 0) {
                completion = completion + directoryData;
            }
            completion = completion + file.getName();
            completion = this.convertCompletionBackIntoUserInputStyle(originalUserInput, completion);
            if (file.isDirectory()) {
                completions.add(new Completion(completion + File.separator));
                continue;
            }
            completions.add(new Completion(completion));
        }
    }

    @Override
    public boolean supports(Class<?> requiredType, String optionContext) {
        return File.class.isAssignableFrom(requiredType);
    }

    private String convertCompletionBackIntoUserInputStyle(String originalUserInput, String completion) {
        if (FileUtils.denotesAbsolutePath(originalUserInput)) {
            return completion;
        }
        if (originalUserInput.startsWith(HOME_DIRECTORY_SYMBOL)) {
            Assert.notNull(home, "Home directory could not be determined from system properties");
            return HOME_DIRECTORY_SYMBOL + completion.substring(home.length());
        }
        return completion.substring(this.getWorkingDirectoryAsString().length());
    }

    private String convertUserInputIntoAFullyQualifiedPath(String userInput) {
        if (FileUtils.denotesAbsolutePath(userInput)) {
            return userInput;
        }
        if (userInput.startsWith(HOME_DIRECTORY_SYMBOL)) {
            Assert.notNull(home, "Home directory could not be determined from system properties");
            if (userInput.length() > 1) {
                return home + userInput.substring(1);
            }
        }
        String fullPath = this.getWorkingDirectoryAsString() + userInput;
        return fullPath;
    }

    private String getWorkingDirectoryAsString() {
        try {
            return this.getWorkingDirectory().getCanonicalPath() + File.separator;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

