/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.shell.CommandLine;
import org.springframework.shell.ShellException;
import org.springframework.shell.SimpleShellCommandLineOptions;
import org.springframework.shell.core.ExitShellRequest;
import org.springframework.shell.core.JLineShellComponent;
import org.springframework.shell.support.logging.HandlerUtils;
import org.springframework.util.StopWatch;

public class Bootstrap {
    private static final String[] CONTEXT_PATH = new String[]{"classpath*:/META-INF/spring/spring-shell-plugin.xml"};
    private static Bootstrap bootstrap;
    private static StopWatch sw;
    private static CommandLine commandLine;
    private GenericApplicationContext ctx;

    public static void main(String[] args) throws IOException {
        ExitShellRequest exitShellRequest;
        sw.start();
        try {
            bootstrap = new Bootstrap(args);
            exitShellRequest = bootstrap.run();
        }
        catch (RuntimeException t) {
            throw t;
        }
        finally {
            HandlerUtils.flushAllHandlers(Logger.getLogger(""));
        }
        System.exit(exitShellRequest.getExitCode());
    }

    public Bootstrap() {
        this(null, CONTEXT_PATH);
    }

    public Bootstrap(String[] args) throws IOException {
        this(args, CONTEXT_PATH);
    }

    public Bootstrap(String[] args, String[] contextPath) {
        try {
            commandLine = SimpleShellCommandLineOptions.parseCommandLine(args);
        }
        catch (IOException e) {
            throw new ShellException(e.getMessage(), e);
        }
        this.ctx = new GenericApplicationContext();
        this.ctx.registerShutdownHook();
        this.configureApplicationContext(this.ctx);
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(this.ctx);
        if (commandLine.getDisableInternalCommands()) {
            scanner.scan("org.springframework.shell.converters", "org.springframework.shell.plugin.support");
        } else {
            scanner.scan("org.springframework.shell.commands", "org.springframework.shell.converters", "org.springframework.shell.plugin.support");
        }
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(this.ctx);
        reader.loadBeanDefinitions(contextPath);
        this.ctx.refresh();
    }

    public ApplicationContext getApplicationContext() {
        return this.ctx;
    }

    private void configureApplicationContext(GenericApplicationContext annctx) {
        this.createAndRegisterBeanDefinition(annctx, JLineShellComponent.class, "shell");
        annctx.getBeanFactory().registerSingleton("commandLine", commandLine);
    }

    protected void createAndRegisterBeanDefinition(GenericApplicationContext annctx, Class<?> clazz) {
        this.createAndRegisterBeanDefinition(annctx, clazz, null);
    }

    protected void createAndRegisterBeanDefinition(GenericApplicationContext annctx, Class<?> clazz, String name) {
        RootBeanDefinition rbd = new RootBeanDefinition();
        rbd.setBeanClass(clazz);
        DefaultListableBeanFactory bf = (DefaultListableBeanFactory)annctx.getBeanFactory();
        if (name != null) {
            bf.registerBeanDefinition(name, rbd);
        } else {
            bf.registerBeanDefinition(clazz.getSimpleName(), rbd);
        }
    }

    private void setupLogging() {
        Logger rootLogger = Logger.getLogger("");
        HandlerUtils.wrapWithDeferredLogHandler(rootLogger, Level.SEVERE);
        Logger sfwLogger = Logger.getLogger("org.springframework");
        sfwLogger.setLevel(Level.WARNING);
        Logger rooLogger = Logger.getLogger("org.springframework.shell");
        rooLogger.setLevel(Level.FINE);
    }

    public ExitShellRequest run() {
        ExitShellRequest exitShellRequest;
        String[] commandsToExecuteAndThenQuit = commandLine.getShellCommandsToExecute();
        JLineShellComponent shell = this.ctx.getBean("shell", JLineShellComponent.class);
        if (null != commandsToExecuteAndThenQuit) {
            String cmd;
            boolean successful = false;
            exitShellRequest = ExitShellRequest.FATAL_EXIT;
            String[] arr$ = commandsToExecuteAndThenQuit;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (successful = shell.executeCommand(cmd = arr$[i$]).isSuccess()); ++i$) {
            }
            if (successful) {
                exitShellRequest = ExitShellRequest.NORMAL_EXIT;
            }
        } else {
            shell.start();
            shell.promptLoop();
            exitShellRequest = shell.getExitShellRequest();
            if (exitShellRequest == null) {
                exitShellRequest = ExitShellRequest.NORMAL_EXIT;
            }
            shell.waitForComplete();
        }
        this.ctx.close();
        sw.stop();
        if (shell.isDevelopmentMode()) {
            System.out.println("Total execution time: " + sw.getLastTaskTimeMillis() + " ms");
        }
        return exitShellRequest;
    }

    public JLineShellComponent getJLineShellComponent() {
        return this.ctx.getBean("shell", JLineShellComponent.class);
    }

    static {
        sw = new StopWatch("Spring Shell");
    }
}

