/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.v0.Frequency;
import org.apache.falcon.entity.v0.SchemaHelper;

public final class DateUtil {
    private static final long MINUTE_IN_MS = 60000L;
    private static final long HOUR_IN_MS = 3600000L;
    private static final long DAY_IN_MS = 86400000L;
    private static final long MONTH_IN_MS = 2678400000L;
    public static final Date NEVER = new Date(Long.parseLong("253379862775000"));
    public static final long HOUR_IN_MILLIS = 3600000L;
    private static final Pattern GMT_OFFSET_COLON_PATTERN = Pattern.compile("^GMT(\\-|\\+)(\\d{2})(\\d{2})$");
    public static final TimeZone UTC = DateUtil.getTimeZone("UTC");
    public static final String ISO8601_UTC_MASK = "yyyy-MM-dd'T'HH:mm'Z'";
    private static String activeTimeMask = "yyyy-MM-dd'T'HH:mm'Z'";
    private static TimeZone activeTimeZone = UTC;
    private static final Pattern VALID_TIMEZONE_PATTERN = Pattern.compile("^UTC$|^GMT(\\+|\\-)\\d{4}$");
    private static final String ISO8601_TZ_MASK_WITHOUT_OFFSET = "yyyy-MM-dd'T'HH:mm";
    private static boolean entityInUTC = true;

    private DateUtil() {
    }

    public static void setTimeZone(String tz) throws FalconException {
        if (StringUtils.isBlank(tz)) {
            tz = "UTC";
        }
        if (!VALID_TIMEZONE_PATTERN.matcher(tz).matches()) {
            throw new FalconException("Invalid entity timezone, it must be 'UTC' or 'GMT(+/-)####");
        }
        activeTimeZone = TimeZone.getTimeZone(tz);
        entityInUTC = activeTimeZone.equals(UTC);
        activeTimeMask = entityInUTC ? ISO8601_UTC_MASK : ISO8601_TZ_MASK_WITHOUT_OFFSET + tz.substring(3);
    }

    public static Date getNextMinute(Date time) throws Exception {
        Calendar insCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        insCal.setTime(time);
        insCal.add(12, 1);
        return insCal.getTime();
    }

    public static String getDateFormatFromTime(long milliSeconds) {
        return SchemaHelper.getDateFormat().format(new Date(milliSeconds));
    }

    public static Long getFrequencyInMillis(Frequency frequency) {
        switch (frequency.getTimeUnit()) {
            case months: {
                return 2678400000L * (long)frequency.getFrequencyAsInt();
            }
            case days: {
                return 86400000L * (long)frequency.getFrequencyAsInt();
            }
            case hours: {
                return 3600000L * (long)frequency.getFrequencyAsInt();
            }
            case minutes: {
                return 60000L * (long)frequency.getFrequencyAsInt();
            }
        }
        return null;
    }

    public static Date now() {
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date offsetTime(Date date, int seconds) {
        return new Date(1000L * (long)seconds + date.getTime());
    }

    public static Date parseDateFalconTZ(String s) throws ParseException {
        s = s.trim();
        ParsePosition pos = new ParsePosition(0);
        Date d = DateUtil.getISO8601DateFormat(activeTimeZone, activeTimeMask).parse(s, pos);
        if (d == null) {
            throw new ParseException("Could not parse [" + s + "] using [" + activeTimeMask + "] mask", pos.getErrorIndex());
        }
        if (s.length() > pos.getIndex()) {
            throw new ParseException("Correct datetime string is followed by invalid characters: " + s, pos.getIndex());
        }
        return d;
    }

    private static DateFormat getISO8601DateFormat(TimeZone tz, String mask) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(mask);
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(tz);
        return dateFormat;
    }

    private static DateFormat getSpecificDateFormat(String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setTimeZone(activeTimeZone);
        return dateFormat;
    }

    public static String formatDateCustom(Date d, String format) {
        return d != null ? DateUtil.getSpecificDateFormat(format).format(d) : "NULL";
    }

    public static String formatDateFalconTZ(Date d) {
        return d != null ? DateUtil.getISO8601DateFormat(activeTimeZone, activeTimeMask).format(d) : "NULL";
    }

    public static TimeZone getTimeZone(String tzId) {
        if (tzId == null) {
            throw new IllegalArgumentException("Timezone cannot be null");
        }
        TimeZone tz = TimeZone.getTimeZone(tzId = DateUtil.handleGMTOffsetTZNames(tzId));
        if (!tz.getID().equals(tzId)) {
            throw new IllegalArgumentException("Invalid TimeZone: " + tzId);
        }
        return tz;
    }

    private static String handleGMTOffsetTZNames(String tzId) {
        Matcher m = GMT_OFFSET_COLON_PATTERN.matcher(tzId);
        if (m.matches() && m.groupCount() == 3) {
            tzId = "GMT" + m.group(1) + m.group(2) + ":" + m.group(3);
        }
        return tzId;
    }

    public static Calendar getCalendar(String dateString) throws Exception {
        return DateUtil.getCalendar(dateString, activeTimeZone);
    }

    public static Calendar getCalendar(String dateString, TimeZone tz) throws Exception {
        Date date = DateUtil.parseDateFalconTZ(dateString);
        Calendar calDate = Calendar.getInstance();
        calDate.setTime(date);
        calDate.setTimeZone(tz);
        return calDate;
    }

    public static String formatDateFalconTZ(Calendar c) {
        return c != null ? DateUtil.formatDateFalconTZ(c.getTime()) : "NULL";
    }
}

