/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.service;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.falcon.FalconException;
import org.apache.falcon.service.FalconService;
import org.apache.falcon.util.ReflectionUtils;

public final class Services
implements Iterable<FalconService> {
    private static final Services INSTANCE = new Services();
    private final Map<String, FalconService> services = new LinkedHashMap<String, FalconService>();

    private Services() {
    }

    public static Services get() {
        return INSTANCE;
    }

    public synchronized void register(FalconService service) throws FalconException {
        if (this.services.containsKey(service.getName())) {
            throw new FalconException("Service " + service.getName() + " already registered");
        }
        this.services.put(service.getName(), service);
    }

    public <T extends FalconService> T getService(String serviceName) {
        if (this.services.containsKey(serviceName)) {
            return (T)this.services.get(serviceName);
        }
        throw new NoSuchElementException("Service " + serviceName + " not registered with registry");
    }

    public boolean isRegistered(String serviceName) {
        return this.services.containsKey(serviceName);
    }

    @Override
    public Iterator<FalconService> iterator() {
        return this.services.values().iterator();
    }

    public FalconService init(String serviceName) throws FalconException {
        if (this.isRegistered(serviceName)) {
            throw new FalconException("Service is already initialized " + serviceName);
        }
        FalconService service = (FalconService)ReflectionUtils.getInstance(serviceName + ".impl");
        this.register(service);
        return service;
    }

    public void reset() {
        this.services.clear();
    }
}

