/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.service;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.commons.el.ExpressionEvaluatorImpl;
import org.apache.falcon.FalconException;
import org.apache.falcon.aspect.GenericAlert;
import org.apache.falcon.cleanup.AbstractCleanupHandler;
import org.apache.falcon.cleanup.FeedCleanupHandler;
import org.apache.falcon.cleanup.ProcessCleanupHandler;
import org.apache.falcon.expression.ExpressionHelper;
import org.apache.falcon.service.FalconService;
import org.apache.falcon.util.StartupProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCleanupService
implements FalconService {
    private static final Logger LOG = LoggerFactory.getLogger(LogCleanupService.class);
    private final ExpressionEvaluator evaluator = new ExpressionEvaluatorImpl();
    private final ExpressionHelper resolver = ExpressionHelper.get();

    @Override
    public String getName() {
        return "Falcon Log cleanup service";
    }

    @Override
    public void init() throws FalconException {
        Timer timer = new Timer();
        timer.schedule((TimerTask)new CleanupThread(), 0L, this.getDelay());
        LOG.info("Falcon log cleanup service initialized");
    }

    @Override
    public void destroy() throws FalconException {
        LOG.info("Falcon log cleanup service destroyed");
    }

    private long getDelay() throws FalconException {
        String delay = StartupProperties.get().getProperty("falcon.cleanup.service.frequency", "days(1)");
        try {
            return (Long)this.evaluator.evaluate("${" + delay + "}", Long.class, (VariableResolver)this.resolver, (FunctionMapper)this.resolver);
        }
        catch (ELException e) {
            throw new FalconException("Exception in EL evaluation", e);
        }
    }

    private static class CleanupThread
    extends TimerTask {
        private final AbstractCleanupHandler processCleanupHandler = new ProcessCleanupHandler();
        private final AbstractCleanupHandler feedCleanupHandler = new FeedCleanupHandler();

        private CleanupThread() {
        }

        @Override
        public void run() {
            try {
                LOG.info("Cleaning up logs at: {}", (Object)new Date());
                this.processCleanupHandler.cleanup();
                this.feedCleanupHandler.cleanup();
            }
            catch (Throwable t) {
                LOG.error("Error in cleanup task: ", t);
                GenericAlert.alertLogCleanupServiceFailed("Exception in log cleanup service", t);
            }
        }
    }
}

